/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class UnexpectedBSSIDBeaconAlert
extends Alert {
    private static final String DESCRIPTION = "A station with an unexpected BSSID (hardware address) is advertising one of our SSIDs (network name). This could be a rogue access point trying to lure users to connect to it by making it look like a legitimate access point of a wireless network that users trust. Note that sophisticated attackers will likely not cause this kind of alert because they would act like a legitimate access point by sending frames with a spoofed BSSID.";
    private static final String DOC_LINK = "guidance-UNEXPECTED_BEACON_BSSID";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("A new access point was installed and the nzyme configuration has not been updated yet.");
        }
    };

    private UnexpectedBSSIDBeaconAlert(DateTime timestamp, Subsystem subsystem, Map<String, Object> fields, long frameCount) {
        super(timestamp, subsystem, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, true, frameCount);
    }

    @Override
    public String getMessage() {
        return "SSID [" + this.getSSID() + "] was advertised with beacon frame by unexpected BSSID [" + this.getBSSID() + "].";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.UNEXPECTED_BSSID_BEACON;
    }

    public String getSSID() {
        return (String)this.getFields().get("ssid");
    }

    public String getBSSID() {
        return (String)this.getFields().get("bssid");
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof UnexpectedBSSIDBeaconAlert)) {
            return false;
        }
        UnexpectedBSSIDBeaconAlert a2 = (UnexpectedBSSIDBeaconAlert)alert;
        return a2.getSSID().equals(this.getSSID()) && a2.getBSSID().equals(this.getBSSID());
    }

    public static UnexpectedBSSIDBeaconAlert create(DateTime timestamp, @NotNull String ssid, String bssid, int channel, int frequency, int antennaSignal, long frameCount) {
        if (Strings.isNullOrEmpty(ssid)) {
            throw new IllegalArgumentException("This alert cannot be raised for hidden/broadcast SSIDs.");
        }
        ImmutableMap.Builder<String, Object> fields = new ImmutableMap.Builder<String, Object>();
        fields.put("ssid", ssid);
        fields.put("bssid", bssid.toLowerCase());
        fields.put("channel", channel);
        fields.put("frequency", frequency);
        fields.put("antenna_signal", antennaSignal);
        return new UnexpectedBSSIDBeaconAlert(timestamp, Subsystem.DOT_11, fields.build(), frameCount);
    }
}

