/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class ProbeFailureAlert
extends Alert {
    private static final String DESCRIPTION = "An nzyme probe/adapter failed. It might have been disconnected, stopped on the operating system level or there could be a driver issue. Check your nzyme log file and follow the documentation.";
    private static final String DOC_LINK = "guidance-PROBE_FAILURE";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("In certain low-traffic environments, a probe might appear idle if no frames have been recorded because no frames existed. Follow the nzyme documentation to configure the `max_idle_time_seconds` variable accordingly.");
        }
    };

    private ProbeFailureAlert(DateTime timestamp, Map<String, Object> fields) {
        super(timestamp, Subsystem.NZYME_SYS, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, false, -1L);
    }

    @Override
    public String getMessage() {
        return "Probe [" + this.getProbeName() + "] failed. (" + this.getErrorDescription() + ")";
    }

    public String getProbeName() {
        return (String)this.getFields().get("probe_name");
    }

    public String getErrorDescription() {
        return (String)this.getFields().get("error_description");
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.PROBE_FAILURE;
    }

    @Override
    public boolean sameAs(Alert alert) {
        if (!(alert instanceof ProbeFailureAlert)) {
            return false;
        }
        ProbeFailureAlert a2 = (ProbeFailureAlert)alert;
        return a2.getProbeName().equals(this.getProbeName());
    }

    public static ProbeFailureAlert create(DateTime firstSeen, @NotNull String probeName, @NotNull String errorDescription) {
        if (Strings.isNullOrEmpty(probeName)) {
            throw new IllegalArgumentException("Probe name cannot be empty.");
        }
        if (Strings.isNullOrEmpty(errorDescription)) {
            throw new IllegalArgumentException("Error description cannot be empty.");
        }
        ImmutableMap.Builder<String, String> fields = new ImmutableMap.Builder<String, String>();
        fields.put("probe_name", probeName);
        fields.put("error_description", errorDescription);
        return new ProbeFailureAlert(firstSeen, fields.build());
    }
}

