/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme.alerts;

import com.google.common.collect.ImmutableMap;
import horse.wtf.nzyme.Subsystem;
import horse.wtf.nzyme.alerts.Alert;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

public class DeauthFloodAlert
extends Alert {
    private static final String DESCRIPTION = "More deauthentication or disassociation frames than usual were recorded. The expected number of frames can be different in any environment and is configured in your nzyme.conf file at \"deauth_monitor.global_threshold\". Deauthentication attacks are an attempt to force a device to disconnect from a legitimate access point and re-connect to a rogue access point controlled by an attacker. Such attacks can also be used for jamming, rendering the WiFi environment unusable through mass disconnections. Note that deauthentication and disassociation frames are an important part of WiFi communication and their occurrence is normal. This is why you have to find and configure a threshold that defines at what level an attack might be taking place.";
    private static final String DOC_LINK = "guidance-DEAUTH_FLOOD";
    private static final List<String> FALSE_POSITIVES = new ArrayList<String>(){
        {
            this.add("Your threshold may be configured too low and normal deauthentication/disassociation activity in your network is causing the alert.");
        }
    };

    private DeauthFloodAlert(DateTime timestamp, Map<String, Object> fields) {
        super(timestamp, Subsystem.DOT_11, fields, DESCRIPTION, DOC_LINK, FALSE_POSITIVES, false, -1L);
    }

    @Override
    public String getMessage() {
        return "Deauthentication flood detected. Rate <" + this.getDeauthRate() + "> is over threshold <" + this.getGlobalThreshold() + ">.";
    }

    @Override
    public Alert.TYPE getType() {
        return Alert.TYPE.DEAUTH_FLOOD;
    }

    @Override
    public boolean sameAs(Alert alert) {
        return alert instanceof DeauthFloodAlert;
    }

    public int getDeauthRate() {
        return (Integer)this.getFields().get("deauth_rate");
    }

    public int getGlobalThreshold() {
        return (Integer)this.getFields().get("global_threshold");
    }

    public static DeauthFloodAlert create(DateTime firstSeen, int rate, int threshold) {
        ImmutableMap.Builder<String, Integer> fields = new ImmutableMap.Builder<String, Integer>();
        fields.put("deauth_rate", rate);
        fields.put("global_threshold", threshold);
        return new DeauthFloodAlert(firstSeen, fields.build());
    }
}

