/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme;

import com.codahale.metrics.MetricRegistry;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import horse.wtf.nzyme.NzymeTracker;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.Version;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.bandits.Bandit;
import horse.wtf.nzyme.bandits.trackers.GroundStation;
import horse.wtf.nzyme.bandits.trackers.TrackerTrackSummary;
import horse.wtf.nzyme.bandits.trackers.hid.LogHID;
import horse.wtf.nzyme.bandits.trackers.hid.TextGUIHID;
import horse.wtf.nzyme.bandits.trackers.hid.TrackerHID;
import horse.wtf.nzyme.bandits.trackers.hid.webhid.WebHID;
import horse.wtf.nzyme.bandits.trackers.protobuf.TrackerMessage;
import horse.wtf.nzyme.bandits.trackers.trackerlogic.TrackerBanditManager;
import horse.wtf.nzyme.bandits.trackers.trackerlogic.TrackerStateWatchdog;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.base.BaseConfiguration;
import horse.wtf.nzyme.configuration.tracker.TrackerConfiguration;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.interceptors.BanditIdentifierInterceptorSet;
import horse.wtf.nzyme.dot11.probes.Dot11MonitorProbe;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.processing.FrameProcessor;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NzymeTrackerImpl
implements NzymeTracker {
    private static final Logger LOG = LogManager.getLogger(NzymeTrackerImpl.class);
    private final Version version = new Version();
    private final String nodeID;
    private final TrackerConfiguration configuration;
    private final BaseConfiguration baseConfiguration;
    private final ExecutorService probeExecutor;
    private final GroundStation groundStation;
    private final TrackerBanditManager banditManager;
    private final TrackerStateWatchdog trackerStateWatchdog;
    private final FrameProcessor frameProcessor;
    private final List<Dot11Probe> probes;
    private final MetricRegistry metrics;
    private final ObjectMapper om;
    private final Anonymizer anonymizer;
    private final List<TrackerHID> hids;

    public NzymeTrackerImpl(BaseConfiguration baseConfiguration, TrackerConfiguration configuration) {
        this.nodeID = baseConfiguration.nodeId();
        this.configuration = configuration;
        this.baseConfiguration = baseConfiguration;
        this.anonymizer = new Anonymizer(baseConfiguration.anonymize(), baseConfiguration.dataDirectory());
        this.frameProcessor = new FrameProcessor();
        this.probes = Lists.newArrayList();
        this.hids = Lists.newArrayList();
        this.metrics = new MetricRegistry();
        this.om = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES, false).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        this.banditManager = new TrackerBanditManager(this);
        this.trackerStateWatchdog = new TrackerStateWatchdog(this);
        this.trackerStateWatchdog.initialize();
        try {
            this.groundStation = new GroundStation(Role.TRACKER, baseConfiguration.nodeId(), this.version.getVersion().toString(), this.metrics, this.banditManager, null, configuration.uplinkDevice());
            for (TrackerHID.TYPE type : this.configuration.hids()) {
                TrackerHID hid;
                switch (type) {
                    case LOG: {
                        hid = new LogHID();
                        break;
                    }
                    case TEXTGUI: {
                        hid = new TextGUIHID(this);
                        break;
                    }
                    case WEB: {
                        hid = new WebHID(this);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown HID [" + type + "]");
                    }
                }
                hid.initialize();
                this.hids.add(hid);
                this.groundStation.registerHID(hid);
            }
        }
        catch (Exception e2) {
            throw new RuntimeException("Tracker Device configuration failed.", e2);
        }
        this.probeExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("probe-loop-%d").build());
    }

    @Override
    public void initialize() {
        LOG.info("Initializing nzyme tracker version: {}.", (Object)this.version.getVersionString());
        this.groundStation.onPingReceived(this.trackerStateWatchdog::registerPing);
        this.groundStation.onStartTrackRequestReceived(this.banditManager::setCurrentlyTrackedBandit);
        this.groundStation.onCancelTrackRequestReceived(cancelTrackRequest -> this.banditManager.cancelTracking());
        this.banditManager.onInitialTrack(bandit -> {
            for (TrackerHID hid : this.hids) {
                hid.onInitialContactWithTrackedBandit(bandit);
            }
        });
        this.banditManager.onBanditTrace((bandit, rssi, channel) -> {
            for (Dot11Probe probe : this.getProbes()) {
                if (!(probe instanceof Dot11MonitorProbe)) continue;
                ((Dot11MonitorProbe)probe).getChannelDesignator().onBanditTrace(channel);
            }
            for (TrackerHID hid : this.hids) {
                hid.onBanditTrace(bandit, rssi);
            }
        });
        Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("contact-sender-%d").build()).scheduleAtFixedRate(() -> {
            if (this.banditManager.isCurrentlyTracking() && this.banditManager.hasActiveTrack()) {
                try {
                    Bandit bandit = this.banditManager.getCurrentlyTrackedBandit();
                    TrackerTrackSummary trackSummary = this.banditManager.getTrackSummary();
                    this.groundStation.transmit(TrackerMessage.Wrapper.newBuilder().setContactStatus(TrackerMessage.ContactStatus.newBuilder().setSource(this.baseConfiguration.nodeId()).setUuid(bandit.uuid().toString()).setRssi(trackSummary.lastSignal()).setLastSeen(trackSummary.lastContact().getMillis()).setFrames(trackSummary.frameCount()).build()).build());
                }
                catch (Exception e2) {
                    LOG.error("Could not send contact status.", (Throwable)e2);
                }
            }
        }, 2L, 30L, TimeUnit.SECONDS);
        Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ground-station-%d").build()).submit(this.groundStation);
        for (Dot11MonitorDefinition m3 : this.configuration.dot11Monitors()) {
            Dot11MonitorProbe probe = new Dot11MonitorProbe(Dot11ProbeConfiguration.create("broad-monitor-" + m3.device(), null, this.baseConfiguration.nodeId(), m3.device(), m3.channels(), m3.channelHopInterval(), m3.channelHopCommand(), m3.skipEnableMonitor(), m3.maxIdleTimeSeconds(), null, null), this.frameProcessor, this.metrics, this.anonymizer, this, true);
            probe.onChannelSwitch((previousChannel, newChannel) -> {
                for (TrackerHID hid : this.hids) {
                    hid.onChannelSwitch(previousChannel, newChannel);
                }
            });
            this.probeExecutor.submit(probe.loop());
            this.probes.add(probe);
        }
        this.frameProcessor.registerDot11Interceptors(new BanditIdentifierInterceptorSet(this.getBanditManager()).getInterceptors());
    }

    @Override
    public void shutdown() {
        this.groundStation.stop();
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.om;
    }

    @Override
    public TrackerConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public BaseConfiguration getBaseConfiguration() {
        return this.baseConfiguration;
    }

    @Override
    public GroundStation getGroundStation() {
        return this.groundStation;
    }

    @Override
    public TrackerBanditManager getBanditManager() {
        return this.banditManager;
    }

    @Override
    public TrackerStateWatchdog getStateWatchdog() {
        return this.trackerStateWatchdog;
    }

    @Override
    public List<Dot11Probe> getProbes() {
        return this.probes;
    }

    @Override
    public List<TrackerHID> getHIDs() {
        return this.hids;
    }

    @Override
    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    @Override
    public void notifyUplinks(Notification notification, Dot11MetaInformation meta) {
    }

    @Override
    public void notifyUplinksOfAlert(Alert alert) {
    }

    @Override
    public void forwardFrame(Dot11Frame frame) {
    }
}

