/*
 * Decompiled with CFR 0.152.
 */
package horse.wtf.nzyme;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.ClassLoadingGaugeSet;
import com.codahale.metrics.jvm.FileDescriptorRatioGauge;
import com.codahale.metrics.jvm.GarbageCollectorMetricSet;
import com.codahale.metrics.jvm.JvmAttributeGaugeSet;
import com.codahale.metrics.jvm.MemoryUsageGaugeSet;
import com.codahale.metrics.jvm.ThreadStatesGaugeSet;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.jaxrs.json.JacksonJaxbJsonProvider;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.typesafe.config.ConfigException;
import horse.wtf.nzyme.NzymeLeader;
import horse.wtf.nzyme.Registry;
import horse.wtf.nzyme.Role;
import horse.wtf.nzyme.Version;
import horse.wtf.nzyme.alerts.Alert;
import horse.wtf.nzyme.alerts.ProbeFailureAlert;
import horse.wtf.nzyme.alerts.service.AlertsService;
import horse.wtf.nzyme.bandits.engine.ContactManager;
import horse.wtf.nzyme.bandits.trackers.GroundStation;
import horse.wtf.nzyme.bandits.trackers.TrackerManager;
import horse.wtf.nzyme.configuration.Dot11MonitorDefinition;
import horse.wtf.nzyme.configuration.Dot11TrapConfiguration;
import horse.wtf.nzyme.configuration.Dot11TrapDeviceDefinition;
import horse.wtf.nzyme.configuration.ForwarderDefinition;
import horse.wtf.nzyme.configuration.UplinkDefinition;
import horse.wtf.nzyme.configuration.base.BaseConfiguration;
import horse.wtf.nzyme.configuration.leader.LeaderConfiguration;
import horse.wtf.nzyme.database.Database;
import horse.wtf.nzyme.dot11.Dot11MetaInformation;
import horse.wtf.nzyme.dot11.anonymization.Anonymizer;
import horse.wtf.nzyme.dot11.clients.Clients;
import horse.wtf.nzyme.dot11.deauth.DeauthenticationMonitor;
import horse.wtf.nzyme.dot11.deception.traps.BeaconTrap;
import horse.wtf.nzyme.dot11.deception.traps.ProbeRequestTrap;
import horse.wtf.nzyme.dot11.deception.traps.Trap;
import horse.wtf.nzyme.dot11.frames.Dot11Frame;
import horse.wtf.nzyme.dot11.interceptors.BanditIdentifierInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.BroadMonitorInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.CryptoChangeInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.DeauthFrameCounterInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.PwnagotchiAdvertisementInterceptor;
import horse.wtf.nzyme.dot11.interceptors.SentryInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.UnexpectedBSSIDInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.UnexpectedChannelInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.UnexpectedFingerprintInterceptorSet;
import horse.wtf.nzyme.dot11.interceptors.UnexpectedSSIDInterceptorSet;
import horse.wtf.nzyme.dot11.networks.Networks;
import horse.wtf.nzyme.dot11.networks.sentry.Sentry;
import horse.wtf.nzyme.dot11.probes.Dot11MonitorProbe;
import horse.wtf.nzyme.dot11.probes.Dot11Probe;
import horse.wtf.nzyme.dot11.probes.Dot11ProbeConfiguration;
import horse.wtf.nzyme.dot11.probes.Dot11SenderProbe;
import horse.wtf.nzyme.dot11.probes.ProbeStatusMonitor;
import horse.wtf.nzyme.events.BrokenProbeEvent;
import horse.wtf.nzyme.events.Event;
import horse.wtf.nzyme.events.EventService;
import horse.wtf.nzyme.events.ShutdownEvent;
import horse.wtf.nzyme.events.StartupEvent;
import horse.wtf.nzyme.notifications.Notification;
import horse.wtf.nzyme.notifications.Uplink;
import horse.wtf.nzyme.notifications.uplinks.UplinkFactory;
import horse.wtf.nzyme.ouis.OUIManager;
import horse.wtf.nzyme.ouis.OUIUpdater;
import horse.wtf.nzyme.periodicals.PeriodicalManager;
import horse.wtf.nzyme.periodicals.alerting.beaconrate.BeaconRateAnomalyAlertMonitor;
import horse.wtf.nzyme.periodicals.alerting.beaconrate.BeaconRateCleaner;
import horse.wtf.nzyme.periodicals.alerting.beaconrate.BeaconRateWriter;
import horse.wtf.nzyme.periodicals.alerting.tracks.SignalTrackMonitor;
import horse.wtf.nzyme.periodicals.measurements.MeasurementsCleaner;
import horse.wtf.nzyme.periodicals.measurements.MeasurementsWriter;
import horse.wtf.nzyme.periodicals.sigidx.SignalIndexHistogramCleaner;
import horse.wtf.nzyme.periodicals.sigidx.SignalIndexHistogramWriter;
import horse.wtf.nzyme.periodicals.versioncheck.VersioncheckThread;
import horse.wtf.nzyme.processing.FrameProcessor;
import horse.wtf.nzyme.remote.forwarders.Forwarder;
import horse.wtf.nzyme.remote.forwarders.ForwarderFactory;
import horse.wtf.nzyme.remote.inputs.RemoteFrameInput;
import horse.wtf.nzyme.rest.CORSFilter;
import horse.wtf.nzyme.rest.NzymeExceptionMapper;
import horse.wtf.nzyme.rest.NzymeLeaderInjectionBinder;
import horse.wtf.nzyme.rest.ObjectMapperProvider;
import horse.wtf.nzyme.rest.authentication.AuthenticationFilter;
import horse.wtf.nzyme.rest.resources.AlertsResource;
import horse.wtf.nzyme.rest.resources.BanditsResource;
import horse.wtf.nzyme.rest.resources.DashboardResource;
import horse.wtf.nzyme.rest.resources.NetworksResource;
import horse.wtf.nzyme.rest.resources.PingResource;
import horse.wtf.nzyme.rest.resources.ReportsResource;
import horse.wtf.nzyme.rest.resources.TrackersResource;
import horse.wtf.nzyme.rest.resources.assets.WebInterfaceAssetsResource;
import horse.wtf.nzyme.rest.resources.authentication.AuthenticationResource;
import horse.wtf.nzyme.rest.resources.system.AssetInventoryResource;
import horse.wtf.nzyme.rest.resources.system.MetricsResource;
import horse.wtf.nzyme.rest.resources.system.ProbesResource;
import horse.wtf.nzyme.rest.resources.system.SystemResource;
import horse.wtf.nzyme.rest.tls.SSLEngineConfiguratorBuilder;
import horse.wtf.nzyme.scheduler.SchedulingService;
import horse.wtf.nzyme.systemstatus.SystemStatus;
import horse.wtf.nzyme.util.MetricNames;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.security.Key;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.message.DeflateEncoder;
import org.glassfish.jersey.message.GZipEncoder;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.server.filter.EncodingFilter;
import org.joda.time.DateTime;
import org.quartz.SchedulerException;

public class NzymeLeaderImpl
implements NzymeLeader {
    private static final org.apache.logging.log4j.Logger LOG = LogManager.getLogger(NzymeLeaderImpl.class);
    private final Version version = new Version();
    private final String nodeId;
    private final LeaderConfiguration configuration;
    private final Database database;
    private final ExecutorService probeExecutor;
    private final MetricRegistry metrics;
    private final Registry registry;
    private final SystemStatus systemStatus;
    private final EventService eventService;
    private final OUIManager ouiManager;
    private final List<Uplink> uplinks;
    private final List<Forwarder> forwarders;
    private final FrameProcessor frameProcessor;
    private final AtomicReference<ImmutableList<String>> ignoredFingerprints;
    private final Networks networks;
    private final Sentry sentry;
    private final Clients clients;
    private final DeauthenticationMonitor deauthenticationMonitor;
    private final ObjectMapper objectMapper;
    private final Key signingKey;
    private final List<Dot11Probe> probes;
    private final AlertsService alerts;
    private final ContactManager contactManager;
    private final TrackerManager trackerManager;
    private final Anonymizer anonymizer;
    private GroundStation groundStation;
    private HttpServer httpServer;
    private SchedulingService schedulingService;

    public NzymeLeaderImpl(BaseConfiguration baseConfiguration, LeaderConfiguration configuration, Database database) {
        this.nodeId = baseConfiguration.nodeId();
        this.signingKey = Keys.secretKeyFor(SignatureAlgorithm.HS512);
        this.configuration = configuration;
        this.database = database;
        this.uplinks = Lists.newArrayList();
        this.forwarders = Lists.newArrayList();
        this.frameProcessor = new FrameProcessor();
        this.ignoredFingerprints = new AtomicReference<ImmutableCollection>(ImmutableList.builder().build());
        this.metrics = new MetricRegistry();
        this.registry = new Registry();
        this.probes = Lists.newArrayList();
        this.systemStatus = new SystemStatus();
        this.eventService = new EventService(this);
        this.networks = new Networks(this);
        this.sentry = new Sentry(this, 5);
        this.clients = new Clients(this);
        this.objectMapper = new ObjectMapper();
        this.deauthenticationMonitor = new DeauthenticationMonitor(this);
        this.anonymizer = new Anonymizer(baseConfiguration.anonymize(), baseConfiguration.dataDirectory());
        try {
            this.schedulingService = new SchedulingService(this);
        }
        catch (SchedulerException e2) {
            throw new RuntimeException("Could not instantiate scheduling service.", e2);
        }
        this.metrics.register("gc", new GarbageCollectorMetricSet());
        this.metrics.register("classes", new ClassLoadingGaugeSet());
        this.metrics.register("fds", new FileDescriptorRatioGauge());
        this.metrics.register("jvm", new JvmAttributeGaugeSet());
        this.metrics.register("mem", new MemoryUsageGaugeSet());
        this.metrics.register("threadstates", new ThreadStatesGaugeSet());
        this.systemStatus.setStatus(SystemStatus.TYPE.RUNNING);
        this.systemStatus.setStatus(SystemStatus.TYPE.TRAINING);
        this.ouiManager = new OUIManager(this);
        this.alerts = new AlertsService(this);
        this.alerts.registerCallbacks(configuration.alertCallbacks());
        this.contactManager = new ContactManager(this);
        this.trackerManager = new TrackerManager();
        this.eventService.subscribe(Event.TYPE.BROKEN_PROBE, event -> {
            BrokenProbeEvent bpe = (BrokenProbeEvent)event;
            this.getAlertsService().handle(ProbeFailureAlert.create(DateTime.now(), bpe.getProbeName(), bpe.getErrorDescription()));
        });
        LOG.info("Training period ends in <{}> seconds.", (Object)configuration.alertingTrainingPeriodSeconds());
        Executors.newSingleThreadScheduledExecutor().schedule(() -> {
            LOG.info("Training period is over!");
            this.systemStatus.unsetStatus(SystemStatus.TYPE.TRAINING);
        }, (long)configuration.alertingTrainingPeriodSeconds(), TimeUnit.SECONDS);
        this.probeExecutor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("probe-loop-%d").build());
    }

    @Override
    public void initialize() {
        LOG.info("Initializing nzyme version: {}.", (Object)this.version.getVersionString());
        this.eventService.recordEvent(new StartupEvent());
        LOG.info("Active alerts: {}", (Object)this.configuration.dot11Alerts());
        try {
            this.ouiManager.fetchAndUpdate();
        }
        catch (IOException e2) {
            LOG.error("Could not initialize OUIs.", (Throwable)e2);
        }
        JmxReporter reporter = JmxReporter.forRegistry(this.metrics).build();
        reporter.start();
        this.metrics.register(MetricNames.DATABASE_SIZE, this.database::getTotalSize);
        UplinkFactory uplinkFactory = new UplinkFactory(this.getNodeID());
        for (UplinkDefinition uplinkDefinition : this.configuration.uplinks()) {
            this.registerUplink(uplinkFactory.fromConfigurationDefinition(uplinkDefinition));
        }
        ForwarderFactory forwarderFactory = new ForwarderFactory(this.getNodeID());
        for (ForwarderDefinition forwarderDefinition : this.configuration.forwarders()) {
            this.forwarders.add(forwarderFactory.fromConfigurationDefinition(forwarderDefinition));
        }
        if (this.configuration.remoteInputAddress() != null) {
            RemoteFrameInput remoteFrameInput = new RemoteFrameInput(this, this.configuration.remoteInputAddress());
            Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("remote-input-%d").build()).submit(remoteFrameInput.run());
        }
        try {
            this.schedulingService.initialize();
        }
        catch (SchedulerException schedulerException) {
            throw new RuntimeException("Could not start scheduling service.", schedulerException);
        }
        PeriodicalManager periodicalManager = new PeriodicalManager();
        periodicalManager.scheduleAtFixedRate(new OUIUpdater(this), 12L, 12L, TimeUnit.HOURS);
        periodicalManager.scheduleAtFixedRate(new MeasurementsWriter(this), 1L, 1L, TimeUnit.MINUTES);
        periodicalManager.scheduleAtFixedRate(new MeasurementsCleaner(this), 0L, 10L, TimeUnit.MINUTES);
        periodicalManager.scheduleAtFixedRate(new BeaconRateWriter(this), 60L, 60L, TimeUnit.SECONDS);
        periodicalManager.scheduleAtFixedRate(new BeaconRateCleaner(this), 0L, 10L, TimeUnit.MINUTES);
        periodicalManager.scheduleAtFixedRate(new SignalIndexHistogramWriter(this), 60L, 60L, TimeUnit.SECONDS);
        periodicalManager.scheduleAtFixedRate(new SignalIndexHistogramCleaner(this), 0L, 10L, TimeUnit.MINUTES);
        periodicalManager.scheduleAtFixedRate(new ProbeStatusMonitor(this), 1L, 1L, TimeUnit.MINUTES);
        if (this.configuration.versionchecksEnabled()) {
            periodicalManager.scheduleAtFixedRate(new VersioncheckThread(this.version, this), 0L, 60L, TimeUnit.MINUTES);
        } else {
            LOG.info("Versionchecks are disabled.");
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.BEACON_RATE_ANOMALY)) {
            periodicalManager.scheduleAtFixedRate(new BeaconRateAnomalyAlertMonitor(this), 60L, 60L, TimeUnit.SECONDS);
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.MULTIPLE_SIGNAL_TRACKS)) {
            periodicalManager.scheduleAtFixedRate(new SignalTrackMonitor(this), 60L, 60L, TimeUnit.SECONDS);
        }
        Logger.getLogger("org.glassfish.grizzly").setLevel(Level.SEVERE);
        ResourceConfig resourceConfig = new ResourceConfig();
        resourceConfig.register(new AuthenticationFilter(this));
        resourceConfig.register(new CORSFilter());
        resourceConfig.register(new NzymeLeaderInjectionBinder(this));
        resourceConfig.register(new ObjectMapperProvider());
        resourceConfig.register(new JacksonJaxbJsonProvider());
        resourceConfig.register(new NzymeExceptionMapper());
        resourceConfig.register((Class)AuthenticationResource.class);
        resourceConfig.register((Class)PingResource.class);
        resourceConfig.register((Class)AlertsResource.class);
        resourceConfig.register((Class)BanditsResource.class);
        resourceConfig.register((Class)ProbesResource.class);
        resourceConfig.register((Class)TrackersResource.class);
        resourceConfig.register((Class)MetricsResource.class);
        resourceConfig.register((Class)NetworksResource.class);
        resourceConfig.register((Class)SystemResource.class);
        resourceConfig.register((Class)DashboardResource.class);
        resourceConfig.register((Class)AssetInventoryResource.class);
        resourceConfig.register((Class)ReportsResource.class);
        resourceConfig.registerClasses(EncodingFilter.class, GZipEncoder.class, DeflateEncoder.class);
        resourceConfig.register((Class)WebInterfaceAssetsResource.class);
        try {
            this.httpServer = this.configuration.useTls() ? GrizzlyHttpServerFactory.createHttpServer(this.configuration.restListenUri(), resourceConfig, true, SSLEngineConfiguratorBuilder.build(this.configuration.tlsCertificatePath(), this.configuration.tlsKeyPath())) : GrizzlyHttpServerFactory.createHttpServer(this.configuration.restListenUri(), resourceConfig);
        }
        catch (Exception e4) {
            throw new RuntimeException("Could not start web server.", e4);
        }
        LOG.info("Started web interface and REST API at [{}]. Access it at: [{}]", (Object)this.configuration.restListenUri(), (Object)this.configuration.httpExternalUri());
        try {
            this.httpServer.start();
        }
        catch (IOException e5) {
            throw new RuntimeException("Could not start REST API.", e5);
        }
        if (this.configuration.groundstationDevice() != null) {
            try {
                this.groundStation = new GroundStation(Role.LEADER, this.getNodeID(), this.version.getVersion().toString(), this.metrics, this.contactManager, this.trackerManager, this.configuration.groundstationDevice());
                this.groundStation.onPingReceived(this.trackerManager::registerTrackerPing);
                this.groundStation.onContactStatusReceived(this.contactManager::registerTrackerContactStatus);
            }
            catch (Exception e6) {
                throw new RuntimeException("Tracker Device configuration failed.", e6);
            }
            Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ground-station-%d").build()).submit(() -> this.groundStation.run());
        }
        this.initializeProbes();
    }

    @Override
    public void shutdown() {
        LOG.info("Shutting down.");
        this.systemStatus.unsetStatus(SystemStatus.TYPE.RUNNING);
        this.systemStatus.setStatus(SystemStatus.TYPE.SHUTTING_DOWN);
        this.eventService.recordEvent(new ShutdownEvent());
        if (this.httpServer != null) {
            LOG.info("Stopping REST API.");
            this.httpServer.shutdownNow();
        }
        if (this.groundStation != null) {
            LOG.info("Stopping Ground Station.");
            this.groundStation.stop();
        }
        LOG.info("Shutdown complete.");
    }

    private void initializeProbes() {
        for (Dot11MonitorDefinition m3 : this.configuration.dot11Monitors()) {
            Dot11MonitorProbe probe = new Dot11MonitorProbe(Dot11ProbeConfiguration.create("broad-monitor-" + m3.device(), this.getUplinks(), this.getNodeID(), m3.device(), m3.channels(), m3.channelHopInterval(), m3.channelHopCommand(), m3.skipEnableMonitor(), m3.maxIdleTimeSeconds(), this.configuration.dot11Networks(), this.configuration.dot11TrapDevices()), this.frameProcessor, this.metrics, this.anonymizer, this, false);
            this.probeExecutor.submit(probe.loop());
            this.probes.add(probe);
        }
        this.frameProcessor.registerDot11Interceptors(new BroadMonitorInterceptorSet(this).getInterceptors());
        this.frameProcessor.registerDot11Interceptors(new BanditIdentifierInterceptorSet(this.getContactManager()).getInterceptors());
        this.frameProcessor.registerDot11Interceptors(new SentryInterceptorSet(this.sentry, this.alerts, this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.UNKNOWN_SSID)).getInterceptors());
        this.frameProcessor.registerDot11Interceptors(new DeauthFrameCounterInterceptorSet(this.deauthenticationMonitor).getInterceptors());
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.UNEXPECTED_BSSID)) {
            this.frameProcessor.registerDot11Interceptors(new UnexpectedBSSIDInterceptorSet(this.getAlertsService(), this.configuration.dot11Networks()).getInterceptors());
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.UNEXPECTED_SSID)) {
            this.frameProcessor.registerDot11Interceptors(new UnexpectedSSIDInterceptorSet(this.getAlertsService(), this.configuration.dot11Networks()).getInterceptors());
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.CRYPTO_CHANGE)) {
            this.frameProcessor.registerDot11Interceptors(new CryptoChangeInterceptorSet(this.getAlertsService(), this.configuration.dot11Networks()).getInterceptors());
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.UNEXPECTED_CHANNEL)) {
            this.frameProcessor.registerDot11Interceptors(new UnexpectedChannelInterceptorSet(this.getAlertsService(), this.configuration.dot11Networks()).getInterceptors());
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.UNEXPECTED_FINGERPRINT)) {
            this.frameProcessor.registerDot11Interceptors(new UnexpectedFingerprintInterceptorSet(this.getAlertsService(), this.configuration.dot11Networks()).getInterceptors());
        }
        if (this.configuration.dot11Alerts().contains((Object)Alert.TYPE_WIDE.PWNAGOTCHI_ADVERTISEMENT)) {
            this.frameProcessor.registerDot11Interceptor(new PwnagotchiAdvertisementInterceptor(this.getAlertsService()));
        }
        block8: for (Dot11TrapDeviceDefinition td : this.configuration.dot11TrapDevices()) {
            Trap trap;
            Dot11TrapConfiguration tc = td.trap();
            try {
                switch (tc.type()) {
                    case PROBE_REQUEST_1: {
                        trap = new ProbeRequestTrap(this, td.device(), tc.configuration().getStringList("ssids"), tc.configuration().getString("transmitter"), tc.configuration().getInt("delay_seconds"));
                        break;
                    }
                    case BEACON_1: {
                        trap = new BeaconTrap(this, td.device(), tc.configuration().getStringList("ssids"), tc.configuration().getString("transmitter"), tc.configuration().getInt("delay_milliseconds"), tc.configuration().getString("fingerprint"));
                        break;
                    }
                    default: {
                        LOG.error("Cannot construct trap of type [{}]. Unknown type. Skipping.", (Object)tc.type());
                        continue block8;
                    }
                }
                trap.checkConfiguration();
            }
            catch (ConfigException e2) {
                LOG.error("Invalid configuration for trap of type [{}]. Skipping.", (Object)tc.type(), (Object)e2);
                continue;
            }
            catch (Exception e3) {
                LOG.error("Failed to construct trap of type [{}]. Skipping.", (Object)tc.type(), (Object)e3);
                continue;
            }
            LOG.info("Registering frame interceptors of [{}].", (Object)trap.getClass().getCanonicalName());
            this.frameProcessor.registerDot11Interceptors(trap.requestedInterceptors());
            Dot11SenderProbe probe = new Dot11SenderProbe(Dot11ProbeConfiguration.create("trap-sender-" + td.device() + "-" + tc.type(), this.getUplinks(), this.getNodeID(), td.device(), ImmutableList.copyOf(td.channels()), td.channelHopInterval(), td.channelHopCommand(), td.skipEnableMonitor(), 60, this.configuration.dot11Networks(), this.configuration.dot11TrapDevices()), trap, this.metrics);
            trap.setProbe(probe);
            this.probeExecutor.submit(probe.loop());
            this.probes.add(probe);
        }
    }

    @Override
    public String getNodeID() {
        return this.nodeId;
    }

    @Override
    public FrameProcessor getFrameProcessor() {
        return this.frameProcessor;
    }

    @Override
    public AlertsService getAlertsService() {
        return this.alerts;
    }

    @Override
    public ContactManager getContactManager() {
        return this.contactManager;
    }

    @Override
    public List<String> getIgnoredFingerprints() {
        return this.ignoredFingerprints.get();
    }

    @Override
    public synchronized void registerIgnoredFingerprint(String fingerprint) {
        this.ignoredFingerprints.set((ImmutableList<String>)((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().addAll(this.ignoredFingerprints.get())).add(fingerprint)).build());
    }

    @Override
    public TrackerManager getTrackerManager() {
        return this.trackerManager;
    }

    @Override
    public GroundStation getGroundStation() {
        return this.groundStation;
    }

    @Override
    public SystemStatus getSystemStatus() {
        return this.systemStatus;
    }

    @Override
    public EventService getEventService() {
        return this.eventService;
    }

    @Override
    public SchedulingService getSchedulingService() {
        return this.schedulingService;
    }

    @Override
    public OUIManager getOUIManager() {
        return this.ouiManager;
    }

    @Override
    public Anonymizer getAnonymizer() {
        return this.anonymizer;
    }

    @Override
    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    @Override
    public LeaderConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public MetricRegistry getMetrics() {
        return this.metrics;
    }

    @Override
    public Registry getRegistry() {
        return this.registry;
    }

    @Override
    public Database getDatabase() {
        return this.database;
    }

    @Override
    public List<Dot11Probe> getProbes() {
        return this.probes;
    }

    @Override
    public Networks getNetworks() {
        return this.networks;
    }

    @Override
    public Sentry getSentry() {
        return this.sentry;
    }

    @Override
    public Clients getClients() {
        return this.clients;
    }

    public ImmutableList<Uplink> getUplinks() {
        return ImmutableList.copyOf(this.uplinks);
    }

    @Override
    public void registerUplink(Uplink uplink) {
        LOG.info("Registering uplink of type [{}].", (Object)uplink.getClass().getCanonicalName());
        this.uplinks.add(uplink);
    }

    @Override
    public void notifyUplinks(Notification notification, Dot11MetaInformation meta) {
        for (Uplink uplink : this.uplinks) {
            uplink.notify(notification, meta);
        }
    }

    @Override
    public void notifyUplinksOfAlert(Alert alert) {
        for (Uplink uplink : this.uplinks) {
            uplink.notifyOfAlert(alert);
        }
    }

    @Override
    public void forwardFrame(Dot11Frame frame) {
        for (Forwarder forwarder : this.forwarders) {
            forwarder.forward(frame);
        }
    }

    @Override
    public Key getSigningKey() {
        return this.signingKey;
    }

    @Override
    public Version getVersion() {
        return this.version;
    }
}

