/*
 * Decompiled with CFR 0.152.
 */
package freemarker.ext.beans;

import freemarker.core.BugException;
import freemarker.ext.beans.BeansWrapper;
import freemarker.ext.beans.CallableMemberDescriptor;
import freemarker.ext.beans.EmptyCallableMemberDescriptor;
import freemarker.ext.beans.EmptyMemberAndArguments;
import freemarker.ext.beans.MaybeEmptyCallableMemberDescriptor;
import freemarker.ext.beans.MaybeEmptyMemberAndArguments;
import freemarker.ext.beans.MemberAndArguments;
import freemarker.ext.beans.OverloadedMethodsSubset;
import freemarker.template.ObjectWrapperAndUnwrapper;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class OverloadedVarArgsMethods
extends OverloadedMethodsSubset {
    OverloadedVarArgsMethods(boolean bugfixed) {
        super(bugfixed);
    }

    @Override
    Class[] preprocessParameterTypes(CallableMemberDescriptor memberDesc) {
        int ln2;
        Class[] preprocessedParamTypes = (Class[])memberDesc.getParamTypes().clone();
        Class<?> varArgsCompType = preprocessedParamTypes[(ln2 = preprocessedParamTypes.length) - 1].getComponentType();
        if (varArgsCompType == null) {
            throw new BugException("Only varargs methods should be handled here");
        }
        preprocessedParamTypes[ln2 - 1] = varArgsCompType;
        return preprocessedParamTypes;
    }

    @Override
    void afterWideningUnwrappingHints(Class[] paramTypes, int[] paramNumericalTypes) {
        Class[] oneLongerHints;
        int i2;
        int paramCount = paramTypes.length;
        Class[][] unwrappingHintsByParamCount = this.getUnwrappingHintsByParamCount();
        for (i2 = paramCount - 1; i2 >= 0; --i2) {
            Class[] previousHints = unwrappingHintsByParamCount[i2];
            if (previousHints == null) continue;
            this.widenHintsToCommonSupertypes(paramCount, previousHints, this.getTypeFlags(i2));
            break;
        }
        if (paramCount + 1 < unwrappingHintsByParamCount.length && (oneLongerHints = unwrappingHintsByParamCount[paramCount + 1]) != null) {
            this.widenHintsToCommonSupertypes(paramCount, oneLongerHints, this.getTypeFlags(paramCount + 1));
        }
        for (i2 = paramCount + 1; i2 < unwrappingHintsByParamCount.length; ++i2) {
            this.widenHintsToCommonSupertypes(i2, paramTypes, paramNumericalTypes);
        }
        if (paramCount > 0) {
            this.widenHintsToCommonSupertypes(paramCount - 1, paramTypes, paramNumericalTypes);
        }
    }

    private void widenHintsToCommonSupertypes(int paramCountOfWidened, Class[] wideningTypes, int[] wideningTypeFlags) {
        Class[] typesToWiden = this.getUnwrappingHintsByParamCount()[paramCountOfWidened];
        if (typesToWiden == null) {
            return;
        }
        int typesToWidenLen = typesToWiden.length;
        int wideningTypesLen = wideningTypes.length;
        int min2 = Math.min(wideningTypesLen, typesToWidenLen);
        for (int i2 = 0; i2 < min2; ++i2) {
            typesToWiden[i2] = this.getCommonSupertypeForUnwrappingHint(typesToWiden[i2], wideningTypes[i2]);
        }
        if (typesToWidenLen > wideningTypesLen) {
            Class varargsComponentType = wideningTypes[wideningTypesLen - 1];
            for (int i3 = wideningTypesLen; i3 < typesToWidenLen; ++i3) {
                typesToWiden[i3] = this.getCommonSupertypeForUnwrappingHint(typesToWiden[i3], varargsComponentType);
            }
        }
        if (this.bugfixed) {
            this.mergeInTypesFlags(paramCountOfWidened, wideningTypeFlags);
        }
    }

    @Override
    MaybeEmptyMemberAndArguments getMemberAndArguments(List tmArgs, BeansWrapper unwrapper) throws TemplateModelException {
        MaybeEmptyCallableMemberDescriptor maybeEmtpyMemberDesc;
        if (tmArgs == null) {
            tmArgs = Collections.EMPTY_LIST;
        }
        int argsLen = tmArgs.size();
        Class[][] unwrappingHintsByParamCount = this.getUnwrappingHintsByParamCount();
        Object[] pojoArgs = new Object[argsLen];
        int[] typesFlags = null;
        block0: for (int paramCount = Math.min(argsLen + 1, unwrappingHintsByParamCount.length - 1); paramCount >= 0; --paramCount) {
            Class[] unwarappingHints = unwrappingHintsByParamCount[paramCount];
            if (unwarappingHints == null) {
                if (paramCount != 0) continue;
                return EmptyMemberAndArguments.WRONG_NUMBER_OF_ARGUMENTS;
            }
            typesFlags = this.getTypeFlags(paramCount);
            if (typesFlags == ALL_ZEROS_ARRAY) {
                typesFlags = null;
            }
            Iterator it2 = tmArgs.iterator();
            for (int i2 = 0; i2 < argsLen; ++i2) {
                int paramIdx = i2 < paramCount ? i2 : paramCount - 1;
                Object pojo = unwrapper.tryUnwrapTo((TemplateModel)it2.next(), unwarappingHints[paramIdx], typesFlags != null ? typesFlags[paramIdx] : 0);
                if (pojo == ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) continue block0;
                pojoArgs[i2] = pojo;
            }
        }
        if ((maybeEmtpyMemberDesc = this.getMemberDescriptorForArgs(pojoArgs, true)) instanceof CallableMemberDescriptor) {
            CallableMemberDescriptor memberDesc = (CallableMemberDescriptor)maybeEmtpyMemberDesc;
            Object argsOrErrorIdx = this.replaceVarargsSectionWithArray(pojoArgs, tmArgs, memberDesc, unwrapper);
            if (!(argsOrErrorIdx instanceof Object[])) {
                return EmptyMemberAndArguments.noCompatibleOverload((Integer)argsOrErrorIdx);
            }
            Object[] pojoArgsWithArray = (Object[])argsOrErrorIdx;
            if (this.bugfixed) {
                if (typesFlags != null) {
                    this.forceNumberArgumentsToParameterTypes(pojoArgsWithArray, memberDesc.getParamTypes(), typesFlags);
                }
            } else {
                BeansWrapper.coerceBigDecimals(memberDesc.getParamTypes(), pojoArgsWithArray);
            }
            return new MemberAndArguments(memberDesc, pojoArgsWithArray);
        }
        return EmptyMemberAndArguments.from((EmptyCallableMemberDescriptor)maybeEmtpyMemberDesc, pojoArgs);
    }

    private Object replaceVarargsSectionWithArray(Object[] args2, List modelArgs, CallableMemberDescriptor memberDesc, BeansWrapper unwrapper) throws TemplateModelException {
        Class[] paramTypes = memberDesc.getParamTypes();
        int paramCount = paramTypes.length;
        Class<?> varArgsCompType = paramTypes[paramCount - 1].getComponentType();
        int totalArgCount = args2.length;
        int fixArgCount = paramCount - 1;
        if (args2.length != paramCount) {
            Object[] packedArgs = new Object[paramCount];
            System.arraycopy(args2, 0, packedArgs, 0, fixArgCount);
            Object varargs = Array.newInstance(varArgsCompType, totalArgCount - fixArgCount);
            for (int i2 = fixArgCount; i2 < totalArgCount; ++i2) {
                Object val = unwrapper.tryUnwrapTo((TemplateModel)modelArgs.get(i2), varArgsCompType);
                if (val == ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) {
                    return i2 + 1;
                }
                Array.set(varargs, i2 - fixArgCount, val);
            }
            packedArgs[fixArgCount] = varargs;
            return packedArgs;
        }
        Object val = unwrapper.tryUnwrapTo((TemplateModel)modelArgs.get(fixArgCount), varArgsCompType);
        if (val == ObjectWrapperAndUnwrapper.CANT_UNWRAP_TO_TARGET_CLASS) {
            return fixArgCount + 1;
        }
        Object array = Array.newInstance(varArgsCompType, 1);
        Array.set(array, 0, val);
        args2[fixArgCount] = array;
        return args2;
    }
}

