/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.fastinfoset.algorithm;

import com.sun.xml.fastinfoset.CommonResourceBundle;
import com.sun.xml.fastinfoset.algorithm.BuiltInEncodingAlgorithm;
import com.sun.xml.fastinfoset.algorithm.IntegerEncodingAlgorithm;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.jvnet.fastinfoset.EncodingAlgorithmException;

public class ShortEncodingAlgorithm
extends IntegerEncodingAlgorithm {
    @Override
    public final int getPrimtiveLengthFromOctetLength(int octetLength) throws EncodingAlgorithmException {
        if (octetLength % 2 != 0) {
            throw new EncodingAlgorithmException(CommonResourceBundle.getInstance().getString("message.lengthNotMultipleOfShort", new Object[]{2}));
        }
        return octetLength / 2;
    }

    @Override
    public int getOctetLengthFromPrimitiveLength(int primitiveLength) {
        return primitiveLength * 2;
    }

    @Override
    public final Object decodeFromBytes(byte[] b2, int start, int length) throws EncodingAlgorithmException {
        short[] data = new short[this.getPrimtiveLengthFromOctetLength(length)];
        this.decodeFromBytesToShortArray(data, 0, b2, start, length);
        return data;
    }

    @Override
    public final Object decodeFromInputStream(InputStream s2) throws IOException {
        return this.decodeFromInputStreamToShortArray(s2);
    }

    @Override
    public void encodeToOutputStream(Object data, OutputStream s2) throws IOException {
        if (!(data instanceof short[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotShortArray"));
        }
        short[] idata = (short[])data;
        this.encodeToOutputStreamFromShortArray(idata, s2);
    }

    @Override
    public final Object convertFromCharacters(char[] ch2, int start, int length) {
        final CharBuffer cb2 = CharBuffer.wrap(ch2, start, length);
        final ArrayList shortList = new ArrayList();
        this.matchWhiteSpaceDelimnatedWords(cb2, new BuiltInEncodingAlgorithm.WordListener(){

            @Override
            public void word(int start, int end) {
                String iStringValue = cb2.subSequence(start, end).toString();
                shortList.add(Short.valueOf(iStringValue));
            }
        });
        return this.generateArrayFromList(shortList);
    }

    @Override
    public final void convertToCharacters(Object data, StringBuffer s2) {
        if (!(data instanceof short[])) {
            throw new IllegalArgumentException(CommonResourceBundle.getInstance().getString("message.dataNotShortArray"));
        }
        short[] idata = (short[])data;
        this.convertToCharactersFromShortArray(idata, s2);
    }

    public final void decodeFromBytesToShortArray(short[] sdata, int istart, byte[] b2, int start, int length) {
        int size = length / 2;
        for (int i2 = 0; i2 < size; ++i2) {
            sdata[istart++] = (short)((b2[start++] & 0xFF) << 8 | b2[start++] & 0xFF);
        }
    }

    public final short[] decodeFromInputStreamToShortArray(InputStream s2) throws IOException {
        ArrayList<Short> shortList = new ArrayList<Short>();
        byte[] b2 = new byte[2];
        while (true) {
            int n2;
            if ((n2 = s2.read(b2)) != 2) {
                if (n2 == -1) break;
                while (n2 != 2) {
                    int m3 = s2.read(b2, n2, 2 - n2);
                    if (m3 == -1) {
                        throw new EOFException();
                    }
                    n2 += m3;
                }
            }
            int i2 = (b2[0] & 0xFF) << 8 | b2[1] & 0xFF;
            shortList.add((short)i2);
        }
        return this.generateArrayFromList(shortList);
    }

    public final void encodeToOutputStreamFromShortArray(short[] idata, OutputStream s2) throws IOException {
        for (int i2 = 0; i2 < idata.length; ++i2) {
            short bits = idata[i2];
            s2.write(bits >>> 8 & 0xFF);
            s2.write(bits & 0xFF);
        }
    }

    @Override
    public final void encodeToBytes(Object array, int astart, int alength, byte[] b2, int start) {
        this.encodeToBytesFromShortArray((short[])array, astart, alength, b2, start);
    }

    public final void encodeToBytesFromShortArray(short[] sdata, int istart, int ilength, byte[] b2, int start) {
        int iend = istart + ilength;
        for (int i2 = istart; i2 < iend; ++i2) {
            short bits = sdata[i2];
            b2[start++] = (byte)(bits >>> 8 & 0xFF);
            b2[start++] = (byte)(bits & 0xFF);
        }
    }

    public final void convertToCharactersFromShortArray(short[] sdata, StringBuffer s2) {
        int end = sdata.length - 1;
        for (int i2 = 0; i2 <= end; ++i2) {
            s2.append(Short.toString(sdata[i2]));
            if (i2 == end) continue;
            s2.append(' ');
        }
    }

    public final short[] generateArrayFromList(List array) {
        short[] sdata = new short[array.size()];
        for (int i2 = 0; i2 < sdata.length; ++i2) {
            sdata[i2] = (Short)array.get(i2);
        }
        return sdata;
    }
}

