/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util.logging;

import com.sun.mail.util.logging.LogManagerProperties;
import com.sun.mail.util.logging.SeverityComparator;
import java.util.Collections;
import java.util.Date;
import java.util.Formattable;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class CompactFormatter
extends Formatter {
    private final String fmt;

    private static Class<?>[] loadDeclaredClasses() {
        return new Class[]{Alternate.class};
    }

    public CompactFormatter() {
        String p2 = this.getClass().getName();
        this.fmt = this.initFormat(p2);
    }

    public CompactFormatter(String format) {
        String p2 = this.getClass().getName();
        this.fmt = format == null ? this.initFormat(p2) : format;
    }

    @Override
    public String format(LogRecord record) {
        ResourceBundle rb = record.getResourceBundle();
        Locale l2 = rb == null ? null : rb.getLocale();
        String msg = this.formatMessage(record);
        String thrown = this.formatThrown(record);
        String err = this.formatError(record);
        Object[] params = new Object[]{this.formatZonedDateTime(record), this.formatSource(record), this.formatLoggerName(record), this.formatLevel(record), msg, thrown, new Alternate(msg, thrown), new Alternate(thrown, msg), record.getSequenceNumber(), this.formatThreadID(record), err, new Alternate(msg, err), new Alternate(err, msg), this.formatBackTrace(record), record.getResourceBundleName(), record.getMessage()};
        if (l2 == null) {
            return String.format(this.fmt, params);
        }
        return String.format(l2, this.fmt, params);
    }

    @Override
    public String formatMessage(LogRecord record) {
        String msg = super.formatMessage(record);
        msg = CompactFormatter.replaceClassName(msg, record.getThrown());
        msg = CompactFormatter.replaceClassName(msg, record.getParameters());
        return msg;
    }

    public String formatMessage(Throwable t2) {
        String r2;
        if (t2 != null) {
            Throwable apply2 = this.apply(t2);
            String m3 = apply2.getLocalizedMessage();
            String s2 = apply2.toString();
            String sn = CompactFormatter.simpleClassName(apply2.getClass());
            r2 = !CompactFormatter.isNullOrSpaces(m3) ? (s2.contains(m3) ? (s2.startsWith(apply2.getClass().getName()) || s2.startsWith(sn) ? CompactFormatter.replaceClassName(m3, t2) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2), t2)) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2) + ": " + m3, t2)) : CompactFormatter.replaceClassName(CompactFormatter.simpleClassName(s2), t2);
            if (!r2.contains(sn)) {
                r2 = sn + ": " + r2;
            }
        } else {
            r2 = "";
        }
        return r2;
    }

    public String formatLevel(LogRecord record) {
        return record.getLevel().getLocalizedName();
    }

    public String formatSource(LogRecord record) {
        String source2 = record.getSourceClassName();
        source2 = source2 != null ? (record.getSourceMethodName() != null ? CompactFormatter.simpleClassName(source2) + " " + record.getSourceMethodName() : CompactFormatter.simpleClassName(source2)) : CompactFormatter.simpleClassName(record.getLoggerName());
        return source2;
    }

    public String formatLoggerName(LogRecord record) {
        return CompactFormatter.simpleClassName(record.getLoggerName());
    }

    public Number formatThreadID(LogRecord record) {
        return (long)record.getThreadID() & 0xFFFFFFFFL;
    }

    public String formatThrown(LogRecord record) {
        String msg;
        Throwable t2 = record.getThrown();
        if (t2 != null) {
            String site = this.formatBackTrace(record);
            msg = this.formatMessage(t2) + (CompactFormatter.isNullOrSpaces(site) ? "" : ' ' + site);
        } else {
            msg = "";
        }
        return msg;
    }

    public String formatError(LogRecord record) {
        return this.formatMessage(record.getThrown());
    }

    public String formatBackTrace(LogRecord record) {
        Throwable root;
        StackTraceElement[] trace;
        String site = "";
        Throwable t2 = record.getThrown();
        if (t2 != null && CompactFormatter.isNullOrSpaces(site = this.findAndFormat(trace = (root = this.apply(t2)).getStackTrace()))) {
            StackTraceElement[] ste;
            int limit = 0;
            for (Throwable c2 = t2; c2 != null && CompactFormatter.isNullOrSpaces(site = this.findAndFormat(ste = c2.getStackTrace())); c2 = c2.getCause()) {
                if (trace.length == 0) {
                    trace = ste;
                }
                if (++limit == 65536) break;
            }
            if (CompactFormatter.isNullOrSpaces(site) && trace.length != 0) {
                site = this.formatStackTraceElement(trace[0]);
            }
        }
        return site;
    }

    private String findAndFormat(StackTraceElement[] trace) {
        String site = "";
        for (StackTraceElement s2 : trace) {
            if (this.ignore(s2)) continue;
            site = this.formatStackTraceElement(s2);
            break;
        }
        if (CompactFormatter.isNullOrSpaces(site)) {
            for (StackTraceElement s2 : trace) {
                if (this.defaultIgnore(s2)) continue;
                site = this.formatStackTraceElement(s2);
                break;
            }
        }
        return site;
    }

    private String formatStackTraceElement(StackTraceElement s2) {
        String v2 = CompactFormatter.simpleClassName(s2.getClassName());
        String result = v2 != null ? s2.toString().replace(s2.getClassName(), v2) : s2.toString();
        v2 = CompactFormatter.simpleFileName(s2.getFileName());
        if (v2 != null && result.startsWith(v2)) {
            result = result.replace(s2.getFileName(), "");
        }
        return result;
    }

    protected Throwable apply(Throwable t2) {
        return SeverityComparator.getInstance().apply(t2);
    }

    protected boolean ignore(StackTraceElement s2) {
        return this.isUnknown(s2) || this.defaultIgnore(s2);
    }

    protected String toAlternate(String s2) {
        return s2 != null ? s2.replaceAll("[\\x00-\\x1F\\x7F]+", "") : null;
    }

    private Comparable<?> formatZonedDateTime(LogRecord record) {
        Date zdt = LogManagerProperties.getZonedDateTime(record);
        if (zdt == null) {
            zdt = new Date(record.getMillis());
        }
        return zdt;
    }

    private boolean defaultIgnore(StackTraceElement s2) {
        return this.isSynthetic(s2) || this.isStaticUtility(s2) || this.isReflection(s2);
    }

    private boolean isStaticUtility(StackTraceElement s2) {
        try {
            return LogManagerProperties.isStaticUtilityClass(s2.getClassName());
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        String cn2 = s2.getClassName();
        return cn2.endsWith("s") && !cn2.endsWith("es") || cn2.contains("Util") || cn2.endsWith("Throwables");
    }

    private boolean isSynthetic(StackTraceElement s2) {
        return s2.getMethodName().indexOf(36) > -1;
    }

    private boolean isUnknown(StackTraceElement s2) {
        return s2.getLineNumber() < 0;
    }

    private boolean isReflection(StackTraceElement s2) {
        try {
            return LogManagerProperties.isReflectionClass(s2.getClassName());
        }
        catch (RuntimeException runtimeException) {
        }
        catch (Exception | LinkageError throwable) {
            // empty catch block
        }
        return s2.getClassName().startsWith("java.lang.reflect.") || s2.getClassName().startsWith("sun.reflect.");
    }

    private String initFormat(String p2) {
        String v2 = LogManagerProperties.fromLogManager(p2.concat(".format"));
        if (CompactFormatter.isNullOrSpaces(v2)) {
            v2 = "%7$#.160s%n";
        }
        return v2;
    }

    private static String replaceClassName(String msg, Throwable t2) {
        if (!CompactFormatter.isNullOrSpaces(msg)) {
            int limit = 0;
            for (Throwable c2 = t2; c2 != null; c2 = c2.getCause()) {
                Class<?> k2 = c2.getClass();
                msg = msg.replace(k2.getName(), CompactFormatter.simpleClassName(k2));
                if (++limit == 65536) break;
            }
        }
        return msg;
    }

    private static String replaceClassName(String msg, Object[] p2) {
        if (!CompactFormatter.isNullOrSpaces(msg) && p2 != null) {
            for (Object o2 : p2) {
                if (o2 == null) continue;
                Class<?> k2 = o2.getClass();
                msg = msg.replace(k2.getName(), CompactFormatter.simpleClassName(k2));
            }
        }
        return msg;
    }

    private static String simpleClassName(Class<?> k2) {
        try {
            return k2.getSimpleName();
        }
        catch (InternalError internalError) {
            return CompactFormatter.simpleClassName(k2.getName());
        }
    }

    private static String simpleClassName(String name) {
        if (name != null) {
            int cursor;
            int c2;
            int dot;
            int sign = -1;
            int prev = dot = -1;
            for (cursor = 0; cursor < name.length(); cursor += Character.charCount(c2)) {
                c2 = name.codePointAt(cursor);
                if (!Character.isJavaIdentifierPart(c2)) {
                    if (c2 == 46) {
                        if (dot + 1 != cursor && dot + 1 != sign) {
                            prev = dot;
                            dot = cursor;
                            continue;
                        }
                        return name;
                    }
                    if (dot + 1 != cursor) break;
                    dot = prev;
                    break;
                }
                if (c2 != 36) continue;
                sign = cursor;
            }
            if (dot > -1 && ++dot < cursor && ++sign < cursor) {
                name = name.substring(sign > dot ? sign : dot);
            }
        }
        return name;
    }

    private static String simpleFileName(String name) {
        if (name != null) {
            int index = name.lastIndexOf(46);
            name = index > -1 ? name.substring(0, index) : name;
        }
        return name;
    }

    private static boolean isNullOrSpaces(String s2) {
        return s2 == null || s2.trim().length() == 0;
    }

    static {
        CompactFormatter.loadDeclaredClasses();
    }

    private class Alternate
    implements Formattable {
        private final String left;
        private final String right;

        Alternate(String left, String right) {
            this.left = String.valueOf(left);
            this.right = String.valueOf(right);
        }

        @Override
        public void formatTo(java.util.Formatter formatter, int flags, int width, int precision) {
            int fence;
            String l2 = this.left;
            String r2 = this.right;
            if ((flags & 2) == 2) {
                l2 = l2.toUpperCase(formatter.locale());
                r2 = r2.toUpperCase(formatter.locale());
            }
            if ((flags & 4) == 4) {
                l2 = CompactFormatter.this.toAlternate(l2);
                r2 = CompactFormatter.this.toAlternate(r2);
            }
            if (precision <= 0) {
                precision = Integer.MAX_VALUE;
            }
            if ((fence = Math.min(l2.length(), precision)) > precision >> 1) {
                fence = Math.max(fence - r2.length(), fence >> 1);
            }
            if (fence > 0) {
                if (fence > l2.length() && Character.isHighSurrogate(l2.charAt(fence - 1))) {
                    --fence;
                }
                l2 = l2.substring(0, fence);
            }
            r2 = r2.substring(0, Math.min(precision - fence, r2.length()));
            if (width > 0) {
                int half = width >> 1;
                if (l2.length() < half) {
                    l2 = this.pad(flags, l2, half);
                }
                if (r2.length() < half) {
                    r2 = this.pad(flags, r2, half);
                }
            }
            Object[] empty = Collections.emptySet().toArray();
            formatter.format(l2, empty);
            if (l2.length() != 0 && r2.length() != 0) {
                formatter.format("|", empty);
            }
            formatter.format(r2, empty);
        }

        private String pad(int flags, String s2, int length) {
            int padding = length - s2.length();
            StringBuilder b2 = new StringBuilder(length);
            if ((flags & 1) == 1) {
                for (int i2 = 0; i2 < padding; ++i2) {
                    b2.append(' ');
                }
                b2.append(s2);
            } else {
                b2.append(s2);
                for (int i3 = 0; i3 < padding; ++i3) {
                    b2.append(' ');
                }
            }
            return b2.toString();
        }
    }
}

