/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FLAGS;
import com.sun.mail.imap.protocol.IMAPResponse;
import java.util.ArrayList;
import java.util.List;
import javax.mail.Flags;

public class MailboxInfo {
    public Flags availableFlags = null;
    public Flags permanentFlags = null;
    public int total = -1;
    public int recent = -1;
    public int first = -1;
    public long uidvalidity = -1L;
    public long uidnext = -1L;
    public boolean uidNotSticky = false;
    public long highestmodseq = -1L;
    public int mode;
    public List<IMAPResponse> responses;

    public MailboxInfo(Response[] r2) throws ParsingException {
        for (int i2 = 0; i2 < r2.length; ++i2) {
            String s2;
            boolean handled;
            if (r2[i2] == null || !(r2[i2] instanceof IMAPResponse)) continue;
            IMAPResponse ir2 = (IMAPResponse)r2[i2];
            if (ir2.keyEquals("EXISTS")) {
                this.total = ir2.getNumber();
                r2[i2] = null;
                continue;
            }
            if (ir2.keyEquals("RECENT")) {
                this.recent = ir2.getNumber();
                r2[i2] = null;
                continue;
            }
            if (ir2.keyEquals("FLAGS")) {
                this.availableFlags = new FLAGS(ir2);
                r2[i2] = null;
                continue;
            }
            if (ir2.keyEquals("VANISHED")) {
                if (this.responses == null) {
                    this.responses = new ArrayList<IMAPResponse>();
                }
                this.responses.add(ir2);
                r2[i2] = null;
                continue;
            }
            if (ir2.keyEquals("FETCH")) {
                if (this.responses == null) {
                    this.responses = new ArrayList<IMAPResponse>();
                }
                this.responses.add(ir2);
                r2[i2] = null;
                continue;
            }
            if (ir2.isUnTagged() && ir2.isOK()) {
                ir2.skipSpaces();
                if (ir2.readByte() != 91) {
                    ir2.reset();
                    continue;
                }
                handled = true;
                s2 = ir2.readAtom();
                if (s2.equalsIgnoreCase("UNSEEN")) {
                    this.first = ir2.readNumber();
                } else if (s2.equalsIgnoreCase("UIDVALIDITY")) {
                    this.uidvalidity = ir2.readLong();
                } else if (s2.equalsIgnoreCase("PERMANENTFLAGS")) {
                    this.permanentFlags = new FLAGS(ir2);
                } else if (s2.equalsIgnoreCase("UIDNEXT")) {
                    this.uidnext = ir2.readLong();
                } else if (s2.equalsIgnoreCase("HIGHESTMODSEQ")) {
                    this.highestmodseq = ir2.readLong();
                } else {
                    handled = false;
                }
                if (handled) {
                    r2[i2] = null;
                    continue;
                }
                ir2.reset();
                continue;
            }
            if (!ir2.isUnTagged() || !ir2.isNO()) continue;
            ir2.skipSpaces();
            if (ir2.readByte() != 91) {
                ir2.reset();
                continue;
            }
            handled = true;
            s2 = ir2.readAtom();
            if (s2.equalsIgnoreCase("UIDNOTSTICKY")) {
                this.uidNotSticky = true;
            } else {
                handled = false;
            }
            if (handled) {
                r2[i2] = null;
                continue;
            }
            ir2.reset();
        }
        if (this.permanentFlags == null) {
            this.permanentFlags = this.availableFlags != null ? new Flags(this.availableFlags) : new Flags();
        }
    }
}

