/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.Argument;
import com.sun.mail.iap.ProtocolException;
import com.sun.mail.iap.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ID {
    private Map<String, String> serverParams = null;

    public ID(Response r2) throws ProtocolException {
        r2.skipSpaces();
        byte c2 = r2.peekByte();
        if (c2 == 78 || c2 == 110) {
            return;
        }
        if (c2 != 40) {
            throw new ProtocolException("Missing '(' at start of ID");
        }
        this.serverParams = new HashMap<String, String>();
        String[] v2 = r2.readStringList();
        if (v2 != null) {
            for (int i2 = 0; i2 < v2.length; i2 += 2) {
                String name = v2[i2];
                if (name == null) {
                    throw new ProtocolException("ID field name null");
                }
                if (i2 + 1 >= v2.length) {
                    throw new ProtocolException("ID field without value: " + name);
                }
                String value = v2[i2 + 1];
                this.serverParams.put(name, value);
            }
        }
        this.serverParams = Collections.unmodifiableMap(this.serverParams);
    }

    Map<String, String> getServerParams() {
        return this.serverParams;
    }

    static Argument getArgumentList(Map<String, String> clientParams) {
        Argument arg = new Argument();
        if (clientParams == null) {
            arg.writeAtom("NIL");
            return arg;
        }
        Argument list = new Argument();
        for (Map.Entry<String, String> e2 : clientParams.entrySet()) {
            list.writeNString(e2.getKey());
            list.writeNString(e2.getValue());
        }
        arg.writeArgument(list);
        return arg;
    }
}

