/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.ENVELOPE;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.Item;
import com.sun.mail.util.PropUtil;
import java.util.ArrayList;
import javax.mail.internet.ParameterList;

public class BODYSTRUCTURE
implements Item {
    static final char[] name = new char[]{'B', 'O', 'D', 'Y', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E'};
    public int msgno;
    public String type;
    public String subtype;
    public String encoding;
    public int lines = -1;
    public int size = -1;
    public String disposition;
    public String id;
    public String description;
    public String md5;
    public String attachment;
    public ParameterList cParams;
    public ParameterList dParams;
    public String[] language;
    public BODYSTRUCTURE[] bodies;
    public ENVELOPE envelope;
    private static int SINGLE = 1;
    private static int MULTI = 2;
    private static int NESTED = 3;
    private int processedType;
    private static final boolean parseDebug = PropUtil.getBooleanSystemProperty("mail.imap.parse.debug", false);

    public BODYSTRUCTURE(FetchResponse r2) throws ParsingException {
        if (parseDebug) {
            System.out.println("DEBUG IMAP: parsing BODYSTRUCTURE");
        }
        this.msgno = r2.getNumber();
        if (parseDebug) {
            System.out.println("DEBUG IMAP: msgno " + this.msgno);
        }
        r2.skipSpaces();
        if (r2.readByte() != 40) {
            throw new ParsingException("BODYSTRUCTURE parse error: missing ``('' at start");
        }
        if (r2.peekByte() == 40) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing multipart");
            }
            this.type = "multipart";
            this.processedType = MULTI;
            ArrayList<BODYSTRUCTURE> v2 = new ArrayList<BODYSTRUCTURE>(1);
            boolean i2 = true;
            do {
                v2.add(new BODYSTRUCTURE(r2));
                r2.skipSpaces();
            } while (r2.peekByte() == 40);
            this.bodies = v2.toArray(new BODYSTRUCTURE[v2.size()]);
            this.subtype = r2.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: subtype " + this.subtype);
            }
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parsing extension data");
            }
            this.cParams = this.parseParameters(r2);
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: body parameters DONE");
                }
                return;
            }
            byte b2 = r2.peekByte();
            if (b2 == 40) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse disposition");
                }
                r2.readByte();
                this.disposition = r2.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition " + this.disposition);
                }
                this.dParams = this.parseParameters(r2);
                if (!r2.isNextNonSpace(')')) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition in multipart");
                }
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
            } else if (b2 == 78 || b2 == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                r2.skip(3);
            } else {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: bad multipart disposition, applying Exchange bug workaround");
                }
                this.description = r2.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: multipart description " + this.description);
                }
                while (r2.readByte() == 32) {
                    this.parseBodyExtension(r2);
                }
                return;
            }
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no body-fld-lang");
                }
                return;
            }
            if (r2.peekByte() == 40) {
                this.language = r2.readStringList();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: language len " + this.language.length);
                }
            } else {
                String l2 = r2.readString();
                if (l2 != null) {
                    String[] la2 = new String[]{l2};
                    this.language = la2;
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: language " + l2);
                    }
                }
            }
            while (r2.readByte() == 32) {
                this.parseBodyExtension(r2);
            }
        } else {
            if (r2.peekByte() == 41) {
                throw new ParsingException("BODYSTRUCTURE parse error: missing body content");
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: single part");
            }
            this.type = r2.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: type " + this.type);
            }
            this.processedType = SINGLE;
            this.subtype = r2.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: subtype " + this.subtype);
            }
            if (this.type == null) {
                this.type = "application";
                this.subtype = "octet-stream";
            }
            this.cParams = this.parseParameters(r2);
            if (parseDebug) {
                System.out.println("DEBUG IMAP: cParams " + this.cParams);
            }
            this.id = r2.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: id " + this.id);
            }
            this.description = r2.readString();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: description " + this.description);
            }
            this.encoding = r2.readAtomString();
            if (this.encoding != null && this.encoding.equalsIgnoreCase("NIL")) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: NIL encoding, applying Exchange bug workaround");
                }
                this.encoding = null;
            }
            if (this.encoding != null) {
                this.encoding = this.encoding.trim();
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: encoding " + this.encoding);
            }
            this.size = r2.readNumber();
            if (parseDebug) {
                System.out.println("DEBUG IMAP: size " + this.size);
            }
            if (this.size < 0) {
                throw new ParsingException("BODYSTRUCTURE parse error: bad ``size'' element");
            }
            if (this.type.equalsIgnoreCase("text")) {
                this.lines = r2.readNumber();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: lines " + this.lines);
                }
                if (this.lines < 0) {
                    throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                }
            } else if (this.type.equalsIgnoreCase("message") && this.subtype.equalsIgnoreCase("rfc822")) {
                this.processedType = NESTED;
                r2.skipSpaces();
                if (r2.peekByte() == 40) {
                    this.envelope = new ENVELOPE(r2);
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: got envelope of nested message");
                    }
                    BODYSTRUCTURE[] bs2 = new BODYSTRUCTURE[]{new BODYSTRUCTURE(r2)};
                    this.bodies = bs2;
                    this.lines = r2.readNumber();
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: lines " + this.lines);
                    }
                    if (this.lines < 0) {
                        throw new ParsingException("BODYSTRUCTURE parse error: bad ``lines'' element");
                    }
                } else if (parseDebug) {
                    System.out.println("DEBUG IMAP: missing envelope and body of nested message");
                }
            } else {
                r2.skipSpaces();
                byte bn2 = r2.peekByte();
                if (Character.isDigit((char)bn2)) {
                    throw new ParsingException("BODYSTRUCTURE parse error: server erroneously included ``lines'' element with type " + this.type + "/" + this.subtype);
                }
            }
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parse DONE");
                }
                return;
            }
            this.md5 = r2.readString();
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: no MD5 DONE");
                }
                return;
            }
            byte b3 = r2.readByte();
            if (b3 == 40) {
                this.disposition = r2.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition " + this.disposition);
                }
                this.dParams = this.parseParameters(r2);
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: dParams " + this.dParams);
                }
                if (!r2.isNextNonSpace(')')) {
                    throw new ParsingException("BODYSTRUCTURE parse error: missing ``)'' at end of disposition");
                }
            } else if (b3 == 78 || b3 == 110) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition NIL");
                }
                r2.skip(2);
            } else {
                throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": bad single part disposition, b " + b3);
            }
            if (r2.isNextNonSpace(')')) {
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: disposition DONE");
                }
                return;
            }
            if (r2.peekByte() == 40) {
                this.language = r2.readStringList();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: language len " + this.language.length);
                }
            } else {
                String l3 = r2.readString();
                if (l3 != null) {
                    String[] la3 = new String[]{l3};
                    this.language = la3;
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: language " + l3);
                    }
                }
            }
            while (r2.readByte() == 32) {
                this.parseBodyExtension(r2);
            }
            if (parseDebug) {
                System.out.println("DEBUG IMAP: all DONE");
            }
        }
    }

    public boolean isMulti() {
        return this.processedType == MULTI;
    }

    public boolean isSingle() {
        return this.processedType == SINGLE;
    }

    public boolean isNested() {
        return this.processedType == NESTED;
    }

    private ParameterList parseParameters(Response r2) throws ParsingException {
        r2.skipSpaces();
        ParameterList list = null;
        byte b2 = r2.readByte();
        if (b2 == 40) {
            list = new ParameterList();
            do {
                String name = r2.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parameter name " + name);
                }
                if (name == null) {
                    throw new ParsingException("BODYSTRUCTURE parse error: " + this.type + "/" + this.subtype + ": null name in parameter list");
                }
                String value = r2.readString();
                if (parseDebug) {
                    System.out.println("DEBUG IMAP: parameter value " + value);
                }
                if (value == null) {
                    if (parseDebug) {
                        System.out.println("DEBUG IMAP: NIL parameter value, applying Exchange bug workaround");
                    }
                    value = "";
                }
                list.set(name, value);
            } while (!r2.isNextNonSpace(')'));
            list.combineSegments();
        } else if (b2 == 78 || b2 == 110) {
            if (parseDebug) {
                System.out.println("DEBUG IMAP: parameter list NIL");
            }
            r2.skip(2);
        } else {
            throw new ParsingException("Parameter list parse error");
        }
        return list;
    }

    private void parseBodyExtension(Response r2) throws ParsingException {
        r2.skipSpaces();
        byte b2 = r2.peekByte();
        if (b2 == 40) {
            r2.skip(1);
            do {
                this.parseBodyExtension(r2);
            } while (!r2.isNextNonSpace(')'));
        } else if (Character.isDigit((char)b2)) {
            r2.readNumber();
        } else {
            r2.readString();
        }
    }
}

