/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.lang;

import com.mchange.v1.util.StringTokenizerUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;

public final class VersionUtils {
    private static final MLogger logger;
    private static final int[] DFLT_VERSION_ARRAY;
    private static final int[] JDK_VERSION_ARRAY;
    private static final int JDK_VERSION;
    private static final Integer NUM_BITS;

    public static Integer jvmNumberOfBits() {
        return NUM_BITS;
    }

    public static boolean isJavaVersion10() {
        return JDK_VERSION == 10;
    }

    public static boolean isJavaVersion11() {
        return JDK_VERSION == 11;
    }

    public static boolean isJavaVersion12() {
        return JDK_VERSION == 12;
    }

    public static boolean isJavaVersion13() {
        return JDK_VERSION == 13;
    }

    public static boolean isJavaVersion14() {
        return JDK_VERSION == 14;
    }

    public static boolean isJavaVersion15() {
        return JDK_VERSION == 15;
    }

    public static boolean isAtLeastJavaVersion10() {
        return JDK_VERSION >= 10;
    }

    public static boolean isAtLeastJavaVersion11() {
        return JDK_VERSION >= 11;
    }

    public static boolean isAtLeastJavaVersion12() {
        return JDK_VERSION >= 12;
    }

    public static boolean isAtLeastJavaVersion13() {
        return JDK_VERSION >= 13;
    }

    public static boolean isAtLeastJavaVersion14() {
        return JDK_VERSION >= 14;
    }

    public static boolean isAtLeastJavaVersion15() {
        return JDK_VERSION >= 15;
    }

    public static boolean isAtLeastJavaVersion16() {
        return JDK_VERSION >= 16;
    }

    public static boolean isAtLeastJavaVersion17() {
        return JDK_VERSION >= 17;
    }

    public static int[] extractVersionNumberArray(String string) throws NumberFormatException {
        return VersionUtils.extractVersionNumberArray(string, string.split("\\D+"));
    }

    public static int[] extractVersionNumberArray(String string, String string2) throws NumberFormatException {
        String[] stringArray = StringTokenizerUtils.tokenizeToArray(string, string2, false);
        return VersionUtils.extractVersionNumberArray(string, stringArray);
    }

    private static int[] extractVersionNumberArray(String string, String[] stringArray) throws NumberFormatException {
        int n2 = stringArray.length;
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            try {
                nArray[i2] = Integer.parseInt(stringArray[i2]);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (i2 <= 1) {
                    throw numberFormatException;
                }
                if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, "JVM version string (" + string + ") contains non-integral component (" + stringArray[i2] + "). Using precending components only to resolve JVM version.");
                }
                int[] nArray2 = new int[i2];
                System.arraycopy(nArray, 0, nArray2, 0, i2);
                nArray = nArray2;
                break;
            }
        }
        return nArray;
    }

    public boolean prefixMatches(int[] nArray, int[] nArray2) {
        if (nArray.length > nArray2.length) {
            return false;
        }
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (nArray[i2] == nArray2[i2]) continue;
            return false;
        }
        return true;
    }

    public static int lexicalCompareVersionNumberArrays(int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        int n3 = nArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 == n3) {
                return 1;
            }
            if (nArray[i2] > nArray2[i2]) {
                return 1;
            }
            if (nArray[i2] >= nArray2[i2]) continue;
            return -1;
        }
        if (n3 > n2) {
            return -1;
        }
        return 0;
    }

    static {
        Integer n2;
        int[] nArray;
        logger = MLog.getLogger(VersionUtils.class);
        DFLT_VERSION_ARRAY = new int[]{1, 1};
        String string = System.getProperty("java.version");
        if (string == null) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Could not find java.version System property. Defaulting to JDK 1.1");
            }
            nArray = DFLT_VERSION_ARRAY;
        } else {
            try {
                nArray = VersionUtils.extractVersionNumberArray(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.warning("java.version ''" + string + "'' could not be parsed. Defaulting to JDK 1.1.");
                }
                nArray = DFLT_VERSION_ARRAY;
            }
        }
        int n3 = 0;
        if (nArray.length > 0) {
            n3 += nArray[0] * 10;
        }
        if (nArray.length > 1) {
            n3 += nArray[1];
        }
        JDK_VERSION_ARRAY = nArray;
        JDK_VERSION = n3;
        try {
            String string2 = System.getProperty("sun.arch.data.model");
            n2 = string2 == null ? null : new Integer(string2);
        }
        catch (Exception exception) {
            n2 = null;
        }
        if (n2 == null || n2 == 32 || n2 == 64) {
            NUM_BITS = n2;
        } else {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.warning("Determined a surprising jvmNumerOfBits: " + n2 + ". Setting jvmNumberOfBits to unknown (null).");
            }
            NUM_BITS = null;
        }
    }
}

