/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.csv;

import com.mchange.v2.csv.MalformedCsvException;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class FastCsvUtils {
    private static final int ESCAPE_BIT = 0x1000000;
    private static final int SHIFT_BIT = 0x2000000;
    private static final int SHIFT_OFFSET = 8;
    private static final int CR = 13;
    private static final int LF = 10;
    private static final int EOF = -1;
    private static final int CRLF_TOKEN = 999;
    private static final String CRLF = "\r\n";
    private static final int GUESSED_LINE_LEN = 512;

    public static String csvReadLine(BufferedReader bufferedReader) throws IOException, MalformedCsvException {
        String string;
        int[] nArray = new int[1];
        String string2 = FastCsvUtils.readLine(bufferedReader, nArray);
        if (string2 != null) {
            int n2 = FastCsvUtils.countQuotes(string2);
            if (n2 % 2 != 0) {
                StringBuilder stringBuilder = new StringBuilder(string2);
                do {
                    FastCsvUtils.appendForToken(nArray[0], stringBuilder);
                    string2 = FastCsvUtils.readLine(bufferedReader, nArray);
                    if (string2 == null) {
                        throw new MalformedCsvException("Unterminated quote at EOF: '" + stringBuilder.toString() + "'");
                    }
                    stringBuilder.append(string2);
                } while ((n2 += FastCsvUtils.countQuotes(string2)) % 2 != 0);
                string = stringBuilder.toString();
            } else {
                string = string2;
            }
        } else {
            string = null;
        }
        return string;
    }

    private static void appendForToken(int n2, StringBuilder stringBuilder) {
        switch (n2) {
            case 10: 
            case 13: {
                stringBuilder.append((char)n2);
                break;
            }
            case 999: {
                stringBuilder.append(CRLF);
                break;
            }
            case -1: {
                break;
            }
            default: {
                throw new InternalError("Unexpected token (should never happen): " + n2);
            }
        }
    }

    private static String readLine(BufferedReader bufferedReader, int[] nArray) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(512);
        int n2 = bufferedReader.read();
        if (n2 < 0) {
            nArray[0] = -1;
            return null;
        }
        while (FastCsvUtils.notSepOrEOF(n2)) {
            stringBuilder.append((char)n2);
            n2 = bufferedReader.read();
        }
        if (n2 == 13) {
            bufferedReader.mark(1);
            int n3 = bufferedReader.read();
            if (n3 == 10) {
                nArray[0] = 999;
            } else {
                bufferedReader.reset();
                nArray[0] = 13;
            }
        } else {
            nArray[0] = n2;
        }
        return stringBuilder.toString();
    }

    private static boolean notSepOrEOF(int n2) {
        return n2 >= 0 && n2 != 10 && n2 != 13;
    }

    private static int countQuotes(String string) {
        char[] cArray = string.toCharArray();
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (cArray[i2] != '\"') continue;
            ++n2;
        }
        return n2;
    }

    public static String[] splitRecord(String string) throws MalformedCsvException {
        int[] nArray = FastCsvUtils.upshiftQuoteString(string);
        List list = FastCsvUtils.splitShifted(nArray);
        int n2 = list.size();
        String[] stringArray = new String[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            stringArray[i2] = FastCsvUtils.downshift((int[])list.get(i2));
        }
        return stringArray;
    }

    private static void debugPrint(int[] nArray) {
        int n2 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            cArray[i2] = (char)(FastCsvUtils.isShifted(nArray[i2]) ? 95 : (char)nArray[i2]);
        }
        System.err.println(new String(cArray));
    }

    private static List splitShifted(int[] nArray) {
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        int n2 = 0;
        int n3 = nArray.length;
        for (int i2 = 0; i2 <= n3; ++i2) {
            int n4;
            if (i2 != n3 && nArray[i2] != 44) continue;
            int n5 = i2 - n2;
            int n6 = -1;
            for (n4 = n2; n4 <= i2; ++n4) {
                if (n4 == i2) {
                    n6 = 0;
                    break;
                }
                if (nArray[n4] != 32 && nArray[n4] != 9) break;
            }
            if (n6 < 0) {
                if (n4 == i2 - 1) {
                    n6 = 1;
                } else {
                    int n7;
                    for (n6 = i2 - n4; n6 > 0 && (nArray[n7 = n4 + n6 - 1] == 32 || nArray[n7] == 9); --n6) {
                    }
                }
            }
            int[] nArray2 = new int[n6];
            if (n6 > 0) {
                System.arraycopy(nArray, n4, nArray2, 0, n6);
            }
            arrayList.add(nArray2);
            n2 = i2 + 1;
        }
        return arrayList;
    }

    private static String downshift(int[] nArray) {
        int n2 = nArray.length;
        char[] cArray = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = nArray[i2];
            cArray[i2] = (char)(FastCsvUtils.isShifted(n3) ? n3 >>> 8 : n3);
        }
        return new String(cArray);
    }

    private static boolean isShifted(int n2) {
        return (n2 & 0x2000000) != 0;
    }

    private static int[] upshiftQuoteString(String string) throws MalformedCsvException {
        char[] cArray = string.toCharArray();
        int[] nArray = new int[cArray.length];
        EscapedCharReader escapedCharReader = new EscapedCharReader(cArray);
        int n2 = 0;
        boolean bl2 = false;
        int n3 = escapedCharReader.read(bl2);
        while (n3 >= 0) {
            if (n3 == 34) {
                bl2 = !bl2;
            } else {
                nArray[n2++] = FastCsvUtils.findShiftyChar(n3, bl2);
            }
            n3 = escapedCharReader.read(bl2);
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private static int findShiftyChar(int n2, boolean bl2) {
        return bl2 ? n2 << 8 | 0x2000000 : n2;
    }

    private static int escape(int n2) {
        return n2 | 0x1000000;
    }

    private static boolean isEscaped(int n2) {
        return (n2 & 0x1000000) != 0;
    }

    private FastCsvUtils() {
    }

    private static class EscapedCharReader {
        char[] chars;
        int finger;

        EscapedCharReader(char[] cArray) {
            this.chars = cArray;
            this.finger = 0;
        }

        int read(boolean bl2) throws MalformedCsvException {
            if (this.finger < this.chars.length) {
                char c2;
                if ((c2 = this.chars[this.finger++]) == '\"' && bl2) {
                    if (this.finger < this.chars.length) {
                        char c3 = this.chars[this.finger];
                        if (c3 == '\"') {
                            ++this.finger;
                            return FastCsvUtils.escape(c3);
                        }
                        return c2;
                    }
                    return c2;
                }
                return c2;
            }
            return -1;
        }
    }
}

