/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.codegen;

import com.mchange.v1.lang.ClassUtils;
import com.mchange.v2.codegen.IndentedWriter;
import java.io.File;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public final class CodegenUtils {
    public static String getModifierString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(32);
        if (Modifier.isPublic(n2)) {
            stringBuffer.append("public ");
        }
        if (Modifier.isProtected(n2)) {
            stringBuffer.append("protected ");
        }
        if (Modifier.isPrivate(n2)) {
            stringBuffer.append("private ");
        }
        if (Modifier.isAbstract(n2)) {
            stringBuffer.append("abstract ");
        }
        if (Modifier.isStatic(n2)) {
            stringBuffer.append("static ");
        }
        if (Modifier.isFinal(n2)) {
            stringBuffer.append("final ");
        }
        if (Modifier.isSynchronized(n2)) {
            stringBuffer.append("synchronized ");
        }
        if (Modifier.isTransient(n2)) {
            stringBuffer.append("transient ");
        }
        if (Modifier.isVolatile(n2)) {
            stringBuffer.append("volatile ");
        }
        if (Modifier.isStrict(n2)) {
            stringBuffer.append("strictfp ");
        }
        if (Modifier.isNative(n2)) {
            stringBuffer.append("native ");
        }
        if (Modifier.isInterface(n2)) {
            stringBuffer.append("interface ");
        }
        return stringBuffer.toString().trim();
    }

    public static Class unarrayClass(Class clazz) {
        Class<?> clazz2 = clazz;
        while (clazz2.isArray()) {
            clazz2 = clazz2.getComponentType();
        }
        return clazz2;
    }

    public static boolean inSamePackage(String string, String string2) {
        int n2 = string.lastIndexOf(46);
        int n3 = string2.lastIndexOf(46);
        if (n2 < 0 || n3 < 0) {
            return true;
        }
        if (string.substring(0, n2).equals(string.substring(0, n2))) {
            return string2.indexOf(46) < 0;
        }
        return false;
    }

    public static String fqcnLastElement(String string) {
        return ClassUtils.fqcnLastElement(string);
    }

    public static String methodSignature(Method method) {
        return CodegenUtils.methodSignature(method, null);
    }

    public static String methodSignature(Method method, String[] stringArray) {
        return CodegenUtils.methodSignature(1, method, stringArray);
    }

    public static String methodSignature(int n2, Method method, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(CodegenUtils.getModifierString(n2));
        stringBuffer.append(' ');
        stringBuffer.append(ClassUtils.simpleClassName(method.getReturnType()));
        stringBuffer.append(' ');
        stringBuffer.append(method.getName());
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n3 = classArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ClassUtils.simpleClassName(classArray[i2]));
            stringBuffer.append(' ');
            stringBuffer.append(stringArray == null ? String.valueOf((char)(97 + i2)) : stringArray[i2]);
        }
        stringBuffer.append(')');
        Class<?>[] classArray2 = method.getExceptionTypes();
        if (classArray2.length > 0) {
            stringBuffer.append(" throws ");
            int n4 = classArray2.length;
            for (n3 = 0; n3 < n4; ++n3) {
                if (n3 != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(ClassUtils.simpleClassName(classArray2[n3]));
            }
        }
        return stringBuffer.toString();
    }

    public static String methodCall(Method method) {
        return CodegenUtils.methodCall(method, null);
    }

    public static String methodCall(Method method, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append(method.getName());
        stringBuffer.append('(');
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray == null ? CodegenUtils.generatedArgumentName(i2) : stringArray[i2]);
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    public static String reflectiveMethodObjectArray(Method method) {
        return CodegenUtils.reflectiveMethodObjectArray(method, null);
    }

    public static String reflectiveMethodObjectArray(Method method, String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("new Object[] ");
        stringBuffer.append('{');
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray == null ? CodegenUtils.generatedArgumentName(i2) : stringArray[i2]);
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static String reflectiveMethodParameterTypeArray(Method method) {
        StringBuffer stringBuffer = new StringBuffer(256);
        stringBuffer.append("new Class[] ");
        stringBuffer.append('{');
        Class<?>[] classArray = method.getParameterTypes();
        int n2 = classArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (i2 != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(ClassUtils.simpleClassName(classArray[i2]));
            stringBuffer.append(".class");
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public static String generatedArgumentName(int n2) {
        return String.valueOf((char)(97 + n2));
    }

    public static String simpleClassName(Class clazz) {
        return ClassUtils.simpleClassName(clazz);
    }

    public static IndentedWriter toIndentedWriter(Writer writer) {
        return writer instanceof IndentedWriter ? (IndentedWriter)writer : new IndentedWriter(writer);
    }

    public static String packageNameToFileSystemDirPath(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n2 = stringBuffer.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (stringBuffer.charAt(i2) != '.') continue;
            stringBuffer.setCharAt(i2, File.separatorChar);
        }
        stringBuffer.append(File.separatorChar);
        return stringBuffer.toString();
    }

    private CodegenUtils() {
    }
}

