/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v1.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IteratorUtils {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    };

    public static Iterator oneElementUnmodifiableIterator(final Object object) {
        return new Iterator(){
            boolean shot = false;

            @Override
            public boolean hasNext() {
                return !this.shot;
            }

            public Object next() {
                if (this.shot) {
                    throw new NoSuchElementException();
                }
                this.shot = true;
                return object;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove() not supported.");
            }
        };
    }

    public static boolean equivalent(Iterator iterator2, Iterator iterator3) {
        block3: {
            while (true) {
                Object e2;
                boolean bl2;
                boolean bl3;
                if ((bl3 = iterator2.hasNext()) ^ (bl2 = iterator3.hasNext())) {
                    return false;
                }
                if (!bl3) break block3;
                Object e3 = iterator2.next();
                if (e3 == (e2 = iterator3.next())) continue;
                if (e3 == null) {
                    return false;
                }
                if (!e3.equals(e2)) break;
            }
            return false;
        }
        return true;
    }

    public static ArrayList toArrayList(Iterator iterator2, int n2) {
        ArrayList arrayList = new ArrayList(n2);
        while (iterator2.hasNext()) {
            arrayList.add(iterator2.next());
        }
        return arrayList;
    }

    public static void fillArray(Iterator iterator2, Object[] objectArray, boolean bl2) {
        int n2 = 0;
        int n3 = objectArray.length;
        while (n2 < n3 && iterator2.hasNext()) {
            objectArray[n2++] = iterator2.next();
        }
        if (bl2 && n2 < n3) {
            objectArray[n2] = null;
        }
    }

    public static void fillArray(Iterator iterator2, Object[] objectArray) {
        IteratorUtils.fillArray(iterator2, objectArray, false);
    }

    public static Object[] toArray(Iterator iterator2, int n2, Class clazz, boolean bl2) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, n2);
        IteratorUtils.fillArray(iterator2, objectArray, bl2);
        return objectArray;
    }

    public static Object[] toArray(Iterator iterator2, int n2, Class clazz) {
        return IteratorUtils.toArray(iterator2, n2, clazz, false);
    }

    public static Object[] toArray(Iterator iterator2, int n2, Object[] objectArray) {
        if (objectArray.length >= n2) {
            IteratorUtils.fillArray(iterator2, objectArray, true);
            return objectArray;
        }
        Class<?> clazz = objectArray.getClass().getComponentType();
        return IteratorUtils.toArray(iterator2, n2, clazz);
    }

    private IteratorUtils() {
    }
}

