/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.util.impl;

import com.mchange.util.LongObjectMap;
import com.mchange.util.impl.LOHRecord;

public class LongObjectHash
implements LongObjectMap {
    LOHRecord[] records;
    float load_factor;
    long threshold;
    long size;

    public LongObjectHash(int n2, float f2) {
        this.records = new LOHRecord[n2];
        this.load_factor = f2;
        this.threshold = (long)(f2 * (float)n2);
    }

    public LongObjectHash() {
        this(101, 0.75f);
    }

    @Override
    public synchronized Object get(long l2) {
        int n2 = (int)(l2 % (long)this.records.length);
        Object object = null;
        if (this.records[n2] != null) {
            object = this.records[n2].get(l2);
        }
        return object;
    }

    @Override
    public synchronized void put(long l2, Object object) {
        boolean bl2;
        int n2 = (int)(l2 % (long)this.records.length);
        if (this.records[n2] == null) {
            this.records[n2] = new LOHRecord(n2);
        }
        if (!(bl2 = this.records[n2].add(l2, object, true))) {
            ++this.size;
        }
        if (this.size > this.threshold) {
            this.rehash();
        }
    }

    @Override
    public synchronized boolean putNoReplace(long l2, Object object) {
        boolean bl2;
        int n2 = (int)(l2 % (long)this.records.length);
        if (this.records[n2] == null) {
            this.records[n2] = new LOHRecord(n2);
        }
        if (bl2 = this.records[n2].add(l2, object, false)) {
            return false;
        }
        ++this.size;
        if (this.size > this.threshold) {
            this.rehash();
        }
        return true;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public synchronized boolean containsLong(long l2) {
        int n2 = (int)(l2 % (long)this.records.length);
        return this.records[n2] != null && this.records[n2].findLong(l2) != null;
    }

    @Override
    public synchronized Object remove(long l2) {
        Object object;
        LOHRecord lOHRecord = this.records[(int)(l2 % (long)this.records.length)];
        Object object2 = object = lOHRecord == null ? null : lOHRecord.remove(l2);
        if (object != null) {
            --this.size;
        }
        return object;
    }

    protected void rehash() {
        if ((long)this.records.length * 2L > Integer.MAX_VALUE) {
            throw new Error("Implementation of LongObjectHash allows a capacity of only 2147483647");
        }
        LOHRecord[] lOHRecordArray = new LOHRecord[this.records.length * 2];
        for (int i2 = 0; i2 < this.records.length; ++i2) {
            if (this.records[i2] == null) continue;
            lOHRecordArray[i2] = this.records[i2];
            lOHRecordArray[i2 * 2] = this.records[i2].split(lOHRecordArray.length);
        }
        this.records = lOHRecordArray;
        this.threshold = (long)(this.load_factor * (float)this.records.length);
    }
}

