/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.ByteUtils;

public final class IntegerUtils {
    public static final long UNSIGNED_MAX_VALUE = -1L;

    public static int parseInt(String string, int n2) {
        if (string == null) {
            return n2;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return n2;
        }
    }

    public static int parseInt(String string, int n2, int n3) {
        if (string == null) {
            return n3;
        }
        try {
            return Integer.parseInt(string, n2);
        }
        catch (NumberFormatException numberFormatException) {
            return n3;
        }
    }

    public static int intFromByteArray(byte[] byArray, int n2) {
        int n3 = 0;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 0]) << 24;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 1]) << 16;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 2]) << 8;
        return n3 |= ByteUtils.unsignedPromote(byArray[n2 + 3]) << 0;
    }

    public static byte[] byteArrayFromInt(int n2) {
        byte[] byArray = new byte[4];
        IntegerUtils.intIntoByteArray(n2, 0, byArray);
        return byArray;
    }

    public static void intIntoByteArray(int n2, int n3, byte[] byArray) {
        byArray[n3 + 0] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3 + 3] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static int intFromByteArrayLittleEndian(byte[] byArray, int n2) {
        int n3 = 0;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 3]) << 24;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 2]) << 16;
        n3 |= ByteUtils.unsignedPromote(byArray[n2 + 1]) << 8;
        return n3 |= ByteUtils.unsignedPromote(byArray[n2 + 0]) << 0;
    }

    public static void intIntoByteArrayLittleEndian(int n2, int n3, byte[] byArray) {
        byArray[n3 + 3] = (byte)(n2 >>> 24 & 0xFF);
        byArray[n3 + 2] = (byte)(n2 >>> 16 & 0xFF);
        byArray[n3 + 1] = (byte)(n2 >>> 8 & 0xFF);
        byArray[n3 + 0] = (byte)(n2 >>> 0 & 0xFF);
    }

    public static long toUnsigned(int n2) {
        return 0xFFFFFFFFL & (long)n2;
    }

    private IntegerUtils() {
    }
}

