/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.lang;

import com.mchange.lang.IntegerUtils;

public final class FloatUtils {
    static final boolean DEBUG = true;
    private static FParser fParser;

    public static byte[] byteArrayFromFloat(float f2) {
        int n2 = Float.floatToIntBits(f2);
        return IntegerUtils.byteArrayFromInt(n2);
    }

    public static float floatFromByteArray(byte[] byArray, int n2) {
        int n3 = IntegerUtils.intFromByteArray(byArray, n2);
        return Float.intBitsToFloat(n3);
    }

    public static float parseFloat(String string, float f2) {
        if (string == null) {
            return f2;
        }
        try {
            return fParser.parseFloat(string);
        }
        catch (NumberFormatException numberFormatException) {
            return f2;
        }
    }

    public static float parseFloat(String string) throws NumberFormatException {
        return fParser.parseFloat(string);
    }

    public static String floatToString(float f2, int n2) {
        boolean bl2 = f2 < 0.0f;
        f2 = bl2 ? -f2 : f2;
        long l2 = Math.round((double)f2 * Math.pow(10.0, -n2));
        String string = String.valueOf(l2);
        if (l2 == 0L) {
            return string;
        }
        int n3 = string.length();
        int n4 = n3 + n2;
        StringBuffer stringBuffer = new StringBuffer(32);
        if (bl2) {
            stringBuffer.append('-');
        }
        if (n4 <= 0) {
            stringBuffer.append("0.");
            for (int i2 = 0; i2 < -n4; ++i2) {
                stringBuffer.append('0');
            }
            stringBuffer.append(string);
        } else {
            stringBuffer.append(string.substring(0, Math.min(n4, n3)));
            if (n4 < n3) {
                stringBuffer.append('.');
                stringBuffer.append(string.substring(n4));
            } else if (n4 > n3) {
                int n5 = n4 - n3;
                for (int i3 = 0; i3 < n5; ++i3) {
                    stringBuffer.append('0');
                }
            }
        }
        return stringBuffer.toString();
    }

    static {
        try {
            fParser = new J12FParser();
            fParser.parseFloat("0.1");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            System.err.println("com.mchange.lang.FloatUtils: reconfiguring for Java 1.1 environment");
            fParser = new J11FParser();
        }
    }

    static class J11FParser
    implements FParser {
        J11FParser() {
        }

        @Override
        public float parseFloat(String string) throws NumberFormatException {
            return new Float(string).floatValue();
        }
    }

    static class J12FParser
    implements FParser {
        J12FParser() {
        }

        @Override
        public float parseFloat(String string) throws NumberFormatException {
            return Float.parseFloat(string);
        }
    }

    static interface FParser {
        public float parseFloat(String var1) throws NumberFormatException;
    }
}

