/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.swing;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.terminal.IOSafeTerminal;
import com.googlecode.lanterna.terminal.TerminalResizeListener;
import com.googlecode.lanterna.terminal.swing.AWTTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.AWTTerminalImplementation;
import com.googlecode.lanterna.terminal.swing.SwingTerminalFontConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorColorConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalEmulatorDeviceConfiguration;
import com.googlecode.lanterna.terminal.swing.TerminalInputMethodRequests;
import com.googlecode.lanterna.terminal.swing.TerminalScrollController;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.im.InputMethodRequests;
import java.text.AttributedCharacterIterator;
import java.util.concurrent.TimeUnit;

public class AWTTerminal
extends Panel
implements IOSafeTerminal {
    private final AWTTerminalImplementation terminalImplementation;
    private final TerminalInputMethodRequests inputMethodRequests;

    public AWTTerminal() {
        this(new TerminalScrollController.Null());
    }

    public AWTTerminal(TerminalScrollController scrollController) {
        this(TerminalEmulatorDeviceConfiguration.getDefault(), AWTTerminalFontConfiguration.getDefault(), TerminalEmulatorColorConfiguration.getDefault(), scrollController);
    }

    public AWTTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this(null, deviceConfiguration, fontConfiguration, colorConfiguration);
    }

    public AWTTerminal(TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration) {
        this(initialTerminalSize, deviceConfiguration, fontConfiguration, colorConfiguration, new TerminalScrollController.Null());
    }

    public AWTTerminal(TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        this(null, deviceConfiguration, fontConfiguration, colorConfiguration, scrollController);
    }

    public AWTTerminal(TerminalSize initialTerminalSize, TerminalEmulatorDeviceConfiguration deviceConfiguration, AWTTerminalFontConfiguration fontConfiguration, TerminalEmulatorColorConfiguration colorConfiguration, TerminalScrollController scrollController) {
        if (deviceConfiguration == null) {
            deviceConfiguration = TerminalEmulatorDeviceConfiguration.getDefault();
        }
        if (fontConfiguration == null) {
            fontConfiguration = SwingTerminalFontConfiguration.getDefault();
        }
        if (colorConfiguration == null) {
            colorConfiguration = TerminalEmulatorColorConfiguration.getDefault();
        }
        this.enableInputMethods(true);
        this.addInputMethodListener(new InputMethodListener(){

            @Override
            public void inputMethodTextChanged(InputMethodEvent event) {
            }

            @Override
            public void caretPositionChanged(InputMethodEvent event) {
            }
        });
        this.terminalImplementation = new AWTTerminalImplementation(this, fontConfiguration, initialTerminalSize, deviceConfiguration, colorConfiguration, scrollController);
        this.inputMethodRequests = new TerminalInputMethodRequests(this, this.terminalImplementation);
    }

    public AWTTerminalFontConfiguration getFontConfiguration() {
        return this.terminalImplementation.getFontConfiguration();
    }

    public TerminalEmulatorColorConfiguration getColorConfiguration() {
        return this.terminalImplementation.getColorConfiguration();
    }

    public TerminalEmulatorDeviceConfiguration getDeviceConfiguration() {
        return this.terminalImplementation.getDeviceConfiguration();
    }

    @Override
    public synchronized Dimension getPreferredSize() {
        return this.terminalImplementation.getPreferredSize();
    }

    @Override
    public synchronized void paint(Graphics componentGraphics) {
        this.terminalImplementation.paintComponent(componentGraphics);
    }

    @Override
    public synchronized void update(Graphics componentGraphics) {
        this.terminalImplementation.paintComponent(componentGraphics);
    }

    public void addInput(KeyStroke keyStroke) {
        this.terminalImplementation.addInput(keyStroke);
    }

    @Override
    public InputMethodRequests getInputMethodRequests() {
        return this.inputMethodRequests;
    }

    @Override
    protected void processInputMethodEvent(InputMethodEvent e2) {
        AttributedCharacterIterator iterator2 = e2.getText();
        for (int i2 = 0; i2 < e2.getCommittedCharacterCount(); ++i2) {
            this.terminalImplementation.addInput(new KeyStroke(Character.valueOf(iterator2.current()), false, false));
            iterator2.next();
        }
    }

    @Override
    public void enterPrivateMode() {
        this.terminalImplementation.enterPrivateMode();
    }

    @Override
    public void exitPrivateMode() {
        this.terminalImplementation.exitPrivateMode();
    }

    @Override
    public void clearScreen() {
        this.terminalImplementation.clearScreen();
    }

    @Override
    public void setCursorPosition(int x2, int y2) {
        this.terminalImplementation.setCursorPosition(x2, y2);
    }

    @Override
    public void setCursorPosition(TerminalPosition position) {
        this.terminalImplementation.setCursorPosition(position);
    }

    @Override
    public TerminalPosition getCursorPosition() {
        return this.terminalImplementation.getCursorPosition();
    }

    @Override
    public void setCursorVisible(boolean visible) {
        this.terminalImplementation.setCursorVisible(visible);
    }

    @Override
    public void putCharacter(char c2) {
        this.terminalImplementation.putCharacter(c2);
    }

    @Override
    public void putString(String string) {
        this.terminalImplementation.putString(string);
    }

    @Override
    public void enableSGR(SGR sgr) {
        this.terminalImplementation.enableSGR(sgr);
    }

    @Override
    public void disableSGR(SGR sgr) {
        this.terminalImplementation.disableSGR(sgr);
    }

    @Override
    public void resetColorAndSGR() {
        this.terminalImplementation.resetColorAndSGR();
    }

    @Override
    public void setForegroundColor(TextColor color) {
        this.terminalImplementation.setForegroundColor(color);
    }

    @Override
    public void setBackgroundColor(TextColor color) {
        this.terminalImplementation.setBackgroundColor(color);
    }

    @Override
    public TerminalSize getTerminalSize() {
        return this.terminalImplementation.getTerminalSize();
    }

    @Override
    public byte[] enquireTerminal(int timeout2, TimeUnit timeoutUnit) {
        return this.terminalImplementation.enquireTerminal(timeout2, timeoutUnit);
    }

    @Override
    public void bell() {
        this.terminalImplementation.bell();
    }

    @Override
    public void flush() {
        this.terminalImplementation.flush();
    }

    @Override
    public void close() {
        this.terminalImplementation.close();
    }

    @Override
    public KeyStroke pollInput() {
        return this.terminalImplementation.pollInput();
    }

    @Override
    public KeyStroke readInput() {
        return this.terminalImplementation.readInput();
    }

    @Override
    public TextGraphics newTextGraphics() {
        return this.terminalImplementation.newTextGraphics();
    }

    @Override
    public void addResizeListener(TerminalResizeListener listener) {
        this.terminalImplementation.addResizeListener(listener);
    }

    @Override
    public void removeResizeListener(TerminalResizeListener listener) {
        this.terminalImplementation.removeResizeListener(listener);
    }
}

