/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.terminal.ansi.UnixLikeTerminal;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public abstract class UnixLikeTTYTerminal
extends UnixLikeTerminal {
    private final File ttyDev;
    private String sttyStatusToRestore;

    protected UnixLikeTTYTerminal(File ttyDev, InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset, UnixLikeTerminal.CtrlCBehaviour terminalCtrlCBehaviour) throws IOException {
        super(terminalInput, terminalOutput, terminalCharset, terminalCtrlCBehaviour);
        this.ttyDev = ttyDev;
        this.realAcquire();
    }

    @Override
    protected void acquire() throws IOException {
    }

    private void realAcquire() throws IOException {
        super.acquire();
    }

    @Override
    protected void registerTerminalResizeListener(Runnable onResize) throws IOException {
        try {
            Class<?> signalClass = Class.forName("sun.misc.Signal");
            for (Method m3 : signalClass.getDeclaredMethods()) {
                if (!"handle".equals(m3.getName())) continue;
                Object windowResizeHandler = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Class.forName("sun.misc.SignalHandler")}, (proxy, method, args2) -> {
                    if ("handle".equals(method.getName())) {
                        onResize.run();
                    }
                    return null;
                });
                m3.invoke(null, signalClass.getConstructor(String.class).newInstance("WINCH"), windowResizeHandler);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    protected void saveTerminalSettings() throws IOException {
        this.sttyStatusToRestore = this.runSTTYCommand("-g").trim();
    }

    @Override
    protected void restoreTerminalSettings() throws IOException {
        if (this.sttyStatusToRestore != null) {
            this.runSTTYCommand(this.sttyStatusToRestore);
        }
    }

    @Override
    protected void keyEchoEnabled(boolean enabled) throws IOException {
        this.runSTTYCommand(enabled ? "echo" : "-echo");
    }

    @Override
    protected void canonicalMode(boolean enabled) throws IOException {
        this.runSTTYCommand(enabled ? "icanon" : "-icanon");
        if (!enabled) {
            this.runSTTYCommand("min", "1");
        }
    }

    @Override
    protected void keyStrokeSignalsEnabled(boolean enabled) throws IOException {
        if (enabled) {
            this.runSTTYCommand("intr", "^C");
        } else {
            this.runSTTYCommand("intr", "undef");
        }
    }

    protected String runSTTYCommand(String ... parameters) throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>(Collections.singletonList(this.getSTTYCommand()));
        commandLine.addAll(Arrays.asList(parameters));
        return this.exec(commandLine.toArray(new String[0]));
    }

    protected String exec(String ... cmd) throws IOException {
        String line;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        if (this.ttyDev != null) {
            pb.redirectInput(ProcessBuilder.Redirect.from(this.ttyDev));
        }
        Process process = pb.start();
        ByteArrayOutputStream stdoutBuffer = new ByteArrayOutputStream();
        InputStream stdout = process.getInputStream();
        int readByte = stdout.read();
        while (readByte >= 0) {
            stdoutBuffer.write(readByte);
            readByte = stdout.read();
        }
        ByteArrayInputStream stdoutBufferInputStream = new ByteArrayInputStream(stdoutBuffer.toByteArray());
        BufferedReader reader = new BufferedReader(new InputStreamReader(stdoutBufferInputStream));
        StringBuilder builder = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            builder.append(line);
        }
        reader.close();
        return builder.toString();
    }

    private String getSTTYCommand() {
        return System.getProperty("com.googlecode.lanterna.terminal.UnixTerminal.sttyCommand", "/bin/stty");
    }
}

