/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

class TelnetProtocol {
    public static final byte COMMAND_SUBNEGOTIATION_END = -16;
    public static final byte COMMAND_NO_OPERATION = -15;
    public static final byte COMMAND_DATA_MARK = -14;
    public static final byte COMMAND_BREAK = -13;
    public static final byte COMMAND_INTERRUPT_PROCESS = -12;
    public static final byte COMMAND_ABORT_OUTPUT = -11;
    public static final byte COMMAND_ARE_YOU_THERE = -10;
    public static final byte COMMAND_ERASE_CHARACTER = -9;
    public static final byte COMMAND_ERASE_LINE = -8;
    public static final byte COMMAND_GO_AHEAD = -7;
    public static final byte COMMAND_SUBNEGOTIATION = -6;
    public static final byte COMMAND_WILL = -5;
    public static final byte COMMAND_WONT = -4;
    public static final byte COMMAND_DO = -3;
    public static final byte COMMAND_DONT = -2;
    public static final byte COMMAND_IAC = -1;
    public static final byte OPTION_TRANSMIT_BINARY = 0;
    public static final byte OPTION_ECHO = 1;
    public static final byte OPTION_SUPPRESS_GO_AHEAD = 3;
    public static final byte OPTION_STATUS = 5;
    public static final byte OPTION_TIMING_MARK = 6;
    public static final byte OPTION_NAOCRD = 10;
    public static final byte OPTION_NAOHTS = 11;
    public static final byte OPTION_NAOHTD = 12;
    public static final byte OPTION_NAOFFD = 13;
    public static final byte OPTION_NAOVTS = 14;
    public static final byte OPTION_NAOVTD = 15;
    public static final byte OPTION_NAOLFD = 16;
    public static final byte OPTION_EXTEND_ASCII = 1;
    public static final byte OPTION_TERMINAL_TYPE = 24;
    public static final byte OPTION_NAWS = 31;
    public static final byte OPTION_TERMINAL_SPEED = 32;
    public static final byte OPTION_TOGGLE_FLOW_CONTROL = 33;
    public static final byte OPTION_LINEMODE = 34;
    public static final byte OPTION_AUTHENTICATION = 37;
    public static final Map<String, Byte> NAME_TO_CODE = TelnetProtocol.createName2CodeMap();
    public static final Map<Byte, String> CODE_TO_NAME = TelnetProtocol.reverseMap(NAME_TO_CODE);

    private static Map<String, Byte> createName2CodeMap() {
        HashMap<String, Byte> result = new HashMap<String, Byte>();
        for (Field field : TelnetProtocol.class.getDeclaredFields()) {
            if (field.getType() != Byte.TYPE || !field.getName().startsWith("COMMAND_") && !field.getName().startsWith("OPTION_")) continue;
            try {
                String namePart = field.getName().substring(field.getName().indexOf("_") + 1);
                result.put(namePart, (Byte)field.get(null));
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        return Collections.unmodifiableMap(result);
    }

    private static <V, K> Map<V, K> reverseMap(Map<K, V> n2c) {
        HashMap<V, K> result = new HashMap<V, K>();
        for (Map.Entry<K, V> e2 : n2c.entrySet()) {
            result.put(e2.getValue(), e2.getKey());
        }
        return Collections.unmodifiableMap(result);
    }

    private TelnetProtocol() {
    }
}

