/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal.ansi;

import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTTYTerminal;
import com.googlecode.lanterna.terminal.ansi.UnixLikeTerminal;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CygwinTerminal
extends UnixLikeTTYTerminal {
    private static final String STTY_LOCATION = CygwinTerminal.findProgram("stty.exe");
    private static final Pattern STTY_SIZE_PATTERN = Pattern.compile(".*rows ([0-9]+);.*columns ([0-9]+);.*");
    private static final String JAVA_LIBRARY_PATH_PROPERTY = "java.library.path";
    private static final String CYGWIN_HOME_ENV = "CYGWIN_HOME";

    public CygwinTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) throws IOException {
        super(null, terminalInput, terminalOutput, terminalCharset, UnixLikeTerminal.CtrlCBehaviour.TRAP);
    }

    @Override
    protected TerminalSize findTerminalSize() {
        try {
            String stty = this.runSTTYCommand("-a");
            Matcher matcher = STTY_SIZE_PATTERN.matcher(stty);
            if (matcher.matches()) {
                return new TerminalSize(Integer.parseInt(matcher.group(2)), Integer.parseInt(matcher.group(1)));
            }
            return new TerminalSize(80, 24);
        }
        catch (Throwable e2) {
            return new TerminalSize(80, 24);
        }
    }

    @Override
    protected String runSTTYCommand(String ... parameters) throws IOException {
        ArrayList<String> commandLine = new ArrayList<String>(Arrays.asList(this.findSTTY(), "-F", this.getPseudoTerminalDevice()));
        commandLine.addAll(Arrays.asList(parameters));
        return this.exec(commandLine.toArray(new String[0]));
    }

    @Override
    protected void acquire() throws IOException {
        super.acquire();
    }

    private String findSTTY() {
        return STTY_LOCATION;
    }

    private String getPseudoTerminalDevice() {
        return "/dev/pty0";
    }

    private static String findProgram(String programName) {
        String[] paths;
        File cygwinHomeBinFile;
        if (System.getenv(CYGWIN_HOME_ENV) != null && (cygwinHomeBinFile = new File(System.getenv(CYGWIN_HOME_ENV) + "/bin", programName)).exists()) {
            return cygwinHomeBinFile.getAbsolutePath();
        }
        for (String path : paths = System.getProperty(JAVA_LIBRARY_PATH_PROPERTY).split(";")) {
            File shBin = new File(path, programName);
            if (!shBin.exists()) continue;
            return shBin.getAbsolutePath();
        }
        return programName;
    }
}

