/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.input.EscapeSequenceCharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.ScreenInfoAction;

public class ScreenInfoCharacterPattern
extends EscapeSequenceCharacterPattern {
    public ScreenInfoCharacterPattern() {
        this.useEscEsc = false;
    }

    @Override
    protected KeyStroke getKeyStrokeRaw(char first, int num1, int num2, char last, boolean bEsc) {
        if (first != '[' || last != 'R' || num1 == 0 || num2 == 0 || bEsc) {
            return null;
        }
        if (num1 == 1 && num2 <= 8) {
            return null;
        }
        TerminalPosition pos = new TerminalPosition(num2, num1);
        return new ScreenInfoAction(pos);
    }

    public static ScreenInfoAction tryToAdopt(KeyStroke ks2) {
        if (ks2 == null) {
            return null;
        }
        switch (ks2.getKeyType()) {
            case CursorLocation: {
                return (ScreenInfoAction)ks2;
            }
            case F3: {
                if (ks2 instanceof KeyStroke.RealF3) {
                    return null;
                }
                int col = 1 + (ks2.isAltDown() ? 2 : 0) + (ks2.isCtrlDown() ? 4 : 0) + (ks2.isShiftDown() ? 1 : 0);
                TerminalPosition pos = new TerminalPosition(col, 1);
                return new ScreenInfoAction(pos);
            }
        }
        return null;
    }
}

