/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.input;

import com.googlecode.lanterna.input.CharacterPattern;
import com.googlecode.lanterna.input.KeyStroke;
import java.util.Arrays;
import java.util.List;

public class BasicCharacterPattern
implements CharacterPattern {
    private final KeyStroke result;
    private final char[] pattern;

    public BasicCharacterPattern(KeyStroke result, char ... pattern) {
        this.result = result;
        this.pattern = pattern;
    }

    public char[] getPattern() {
        return Arrays.copyOf(this.pattern, this.pattern.length);
    }

    public KeyStroke getResult() {
        return this.result;
    }

    @Override
    public CharacterPattern.Matching match(List<Character> seq) {
        int size = seq.size();
        if (size > this.pattern.length) {
            return null;
        }
        for (int i2 = 0; i2 < size; ++i2) {
            if (this.pattern[i2] == seq.get(i2).charValue()) continue;
            return null;
        }
        if (size == this.pattern.length) {
            return new CharacterPattern.Matching(this.getResult());
        }
        return CharacterPattern.Matching.NOT_YET;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BasicCharacterPattern)) {
            return false;
        }
        BasicCharacterPattern other = (BasicCharacterPattern)obj;
        return Arrays.equals(this.pattern, other.pattern);
    }

    public int hashCode() {
        int hash = 3;
        hash = 53 * hash + Arrays.hashCode(this.pattern);
        return hash;
    }
}

