/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalRectangle;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.BasicTextImage;
import com.googlecode.lanterna.graphics.TextImage;
import com.googlecode.lanterna.gui2.AbstractBasePane;
import com.googlecode.lanterna.gui2.AbstractTextGUI;
import com.googlecode.lanterna.gui2.BasePane;
import com.googlecode.lanterna.gui2.Borders;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.DefaultTextGUIGraphics;
import com.googlecode.lanterna.gui2.DefaultWindowManager;
import com.googlecode.lanterna.gui2.EmptySpace;
import com.googlecode.lanterna.gui2.GUIBackdrop;
import com.googlecode.lanterna.gui2.Interactable;
import com.googlecode.lanterna.gui2.SameTextGUIThread;
import com.googlecode.lanterna.gui2.TextGUI;
import com.googlecode.lanterna.gui2.TextGUIGraphics;
import com.googlecode.lanterna.gui2.TextGUIThread;
import com.googlecode.lanterna.gui2.TextGUIThreadFactory;
import com.googlecode.lanterna.gui2.Window;
import com.googlecode.lanterna.gui2.WindowBasedTextGUI;
import com.googlecode.lanterna.gui2.WindowDecorationRenderer;
import com.googlecode.lanterna.gui2.WindowList;
import com.googlecode.lanterna.gui2.WindowManager;
import com.googlecode.lanterna.gui2.WindowPostRenderer;
import com.googlecode.lanterna.input.KeyStroke;
import com.googlecode.lanterna.input.KeyType;
import com.googlecode.lanterna.input.MouseAction;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.VirtualScreen;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

public class MultiWindowTextGUI
extends AbstractTextGUI
implements WindowBasedTextGUI {
    private final WindowManager windowManager;
    private final BasePane backgroundPane;
    private final WindowList windowList = new WindowList();
    private final IdentityHashMap<Window, TextImage> windowRenderBufferCache;
    private final WindowPostRenderer postRenderer;
    private boolean eofWhenNoWindows;
    private Window titleBarDragWindow;
    private TerminalPosition originWindowPosition;
    private TerminalPosition dragStart;

    public MultiWindowTextGUI(Screen screen) {
        this(new SameTextGUIThread.Factory(), screen);
    }

    public MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, Screen screen) {
        this(guiThreadFactory, screen, new DefaultWindowManager(), null, new GUIBackdrop());
    }

    public MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, Screen screen, WindowManager windowManager) {
        this(guiThreadFactory, screen, windowManager, null, new GUIBackdrop());
    }

    @Deprecated
    public MultiWindowTextGUI(Screen screen, TextColor backgroundColor) {
        this(screen, new DefaultWindowManager(), new EmptySpace(backgroundColor));
    }

    public MultiWindowTextGUI(Screen screen, WindowManager windowManager, Component background) {
        this(screen, windowManager, null, background);
    }

    public MultiWindowTextGUI(Screen screen, WindowManager windowManager, WindowPostRenderer postRenderer, Component background) {
        this(new SameTextGUIThread.Factory(), screen, windowManager, postRenderer, background);
    }

    public MultiWindowTextGUI(TextGUIThreadFactory guiThreadFactory, Screen screen, WindowManager windowManager, WindowPostRenderer postRenderer, Component background) {
        super(guiThreadFactory, screen);
        if (windowManager == null) {
            throw new IllegalArgumentException("Creating a window-based TextGUI requires a WindowManager");
        }
        if (background == null) {
            background = new GUIBackdrop();
        }
        this.windowManager = windowManager;
        this.backgroundPane = new AbstractBasePane<BasePane>(){

            @Override
            public TextGUI getTextGUI() {
                return MultiWindowTextGUI.this;
            }

            @Override
            public TerminalPosition toGlobal(TerminalPosition localPosition) {
                return localPosition;
            }

            @Override
            public TerminalPosition fromGlobal(TerminalPosition globalPosition) {
                return globalPosition;
            }

            @Override
            BasePane self() {
                return this;
            }
        };
        this.backgroundPane.setComponent(background);
        this.windowRenderBufferCache = new IdentityHashMap();
        this.postRenderer = postRenderer;
        this.eofWhenNoWindows = false;
    }

    @Override
    public synchronized boolean isPendingUpdate() {
        for (Window window : this.getWindows()) {
            if (!window.isVisible() || !window.isInvalid()) continue;
            return true;
        }
        return super.isPendingUpdate() || this.backgroundPane.isInvalid() || this.windowManager.isInvalid();
    }

    @Override
    public synchronized void updateScreen() throws IOException {
        if (this.getScreen() instanceof VirtualScreen) {
            TerminalSize minimumTerminalSize = TerminalSize.ZERO;
            for (Window window : this.getWindows()) {
                if (!window.isVisible() || window.getHints().contains(Window.Hint.FULL_SCREEN) || window.getHints().contains(Window.Hint.FIT_TERMINAL_WINDOW) || window.getHints().contains(Window.Hint.EXPANDED)) continue;
                TerminalPosition lastPosition = window.getPosition();
                minimumTerminalSize = minimumTerminalSize.max(window.getDecoratedSize().withRelative(Math.max(lastPosition.getColumn(), 0), Math.max(lastPosition.getRow(), 0)));
            }
            ((VirtualScreen)this.getScreen()).setMinimumSize(minimumTerminalSize);
        }
        super.updateScreen();
    }

    @Override
    protected synchronized KeyStroke readKeyStroke() throws IOException {
        KeyStroke keyStroke = super.pollInput();
        if (this.windowList.isHadWindowAtSomePoint() && this.eofWhenNoWindows && keyStroke == null && this.getWindows().isEmpty()) {
            return new KeyStroke(KeyType.EOF);
        }
        if (keyStroke != null) {
            return keyStroke;
        }
        return super.readKeyStroke();
    }

    @Override
    protected synchronized void drawGUI(TextGUIGraphics graphics) {
        this.drawBackgroundPane(graphics);
        this.windowManager.prepareWindows(this, this.windowList.getWindowsInStableOrder(), graphics.getSize());
        for (Window window : this.getWindows()) {
            DefaultTextGUIGraphics windowGraphics;
            if (!window.isVisible()) continue;
            TextImage textImage = this.windowRenderBufferCache.get(window);
            if (textImage == null || !textImage.getSize().equals(window.getDecoratedSize())) {
                textImage = new BasicTextImage(window.getDecoratedSize());
                this.windowRenderBufferCache.put(window, textImage);
            }
            TextGUIGraphics insideWindowDecorationsGraphics = windowGraphics = new DefaultTextGUIGraphics(this, textImage.newTextGraphics());
            TerminalPosition contentOffset = TerminalPosition.TOP_LEFT_CORNER;
            if (!window.getHints().contains(Window.Hint.NO_DECORATIONS)) {
                WindowDecorationRenderer decorationRenderer = this.windowManager.getWindowDecorationRenderer(window);
                insideWindowDecorationsGraphics = decorationRenderer.draw(this, windowGraphics, window);
                contentOffset = decorationRenderer.getOffset(window);
            }
            window.draw(insideWindowDecorationsGraphics);
            window.setContentOffset(contentOffset);
            if (windowGraphics != insideWindowDecorationsGraphics) {
                Borders.joinLinesWithFrame(windowGraphics);
            }
            graphics.drawImage(window.getPosition(), textImage);
            if (window.getHints().contains(Window.Hint.NO_POST_RENDERING)) continue;
            if (window.getPostRenderer() != null) {
                window.getPostRenderer().postRender(graphics, this, window);
                continue;
            }
            if (this.postRenderer != null) {
                this.postRenderer.postRender(graphics, this, window);
                continue;
            }
            if (this.getTheme().getWindowPostRenderer() == null) continue;
            this.getTheme().getWindowPostRenderer().postRender(graphics, this, window);
        }
        this.windowRenderBufferCache.keySet().retainAll(this.getWindows());
    }

    private void drawBackgroundPane(TextGUIGraphics graphics) {
        this.backgroundPane.draw(new DefaultTextGUIGraphics(this, graphics));
    }

    @Override
    public synchronized TerminalPosition getCursorPosition() {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.toGlobal(activeWindow.getCursorPosition());
        }
        return this.backgroundPane.getCursorPosition();
    }

    public void setEOFWhenNoWindows(boolean eofWhenNoWindows) {
        this.eofWhenNoWindows = eofWhenNoWindows;
    }

    public boolean isEOFWhenNoWindows() {
        return this.eofWhenNoWindows;
    }

    @Override
    @Deprecated
    public void setVirtualScreenEnabled(boolean virtualScreenEnabled) {
    }

    @Override
    public synchronized Interactable getFocusedInteractable() {
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.getFocusedInteractable();
        }
        return this.backgroundPane.getFocusedInteractable();
    }

    @Override
    public synchronized boolean handleInput(KeyStroke keyStroke) {
        this.ifMouseDownPossiblyChangeActiveWindow(keyStroke);
        this.ifMouseDownPossiblyStartTitleDrag(keyStroke);
        this.ifMouseDragPossiblyMoveWindow(keyStroke);
        Window activeWindow = this.getActiveWindow();
        if (activeWindow != null) {
            return activeWindow.handleInput(keyStroke);
        }
        return this.backgroundPane.handleInput(keyStroke);
    }

    protected synchronized void ifMouseDownPossiblyChangeActiveWindow(KeyStroke keyStroke) {
        if (!(keyStroke instanceof MouseAction)) {
            return;
        }
        MouseAction mouse = (MouseAction)keyStroke;
        if (mouse.isMouseDown()) {
            Window priorActiveWindow = this.getActiveWindow();
            AtomicBoolean anyHit = new AtomicBoolean(false);
            ArrayList<Window> snapshot = new ArrayList<Window>(this.getWindows());
            for (Window w2 : snapshot) {
                w2.getBounds().whenContains(mouse.getPosition(), () -> {
                    this.setActiveWindow(w2);
                    anyHit.set(true);
                });
            }
            if ((priorActiveWindow != this.getActiveWindow() || !anyHit.get()) && priorActiveWindow.getHints().contains(Window.Hint.MENU_POPUP)) {
                priorActiveWindow.close();
            }
        }
    }

    protected void ifMouseDownPossiblyStartTitleDrag(KeyStroke keyStroke) {
        if (!(keyStroke instanceof MouseAction)) {
            return;
        }
        MouseAction mouse = (MouseAction)keyStroke;
        if (mouse.isMouseDown()) {
            this.titleBarDragWindow = null;
            this.dragStart = null;
            Window window = this.getActiveWindow();
            if (window == null) {
                return;
            }
            if (window.getHints().contains(Window.Hint.MENU_POPUP)) {
                return;
            }
            WindowDecorationRenderer decorator = this.windowManager.getWindowDecorationRenderer(window);
            TerminalRectangle titleBarRectangle = decorator.getTitleBarRectangle(window);
            TerminalPosition local = window.fromGlobalToDecoratedRelative(mouse.getPosition());
            titleBarRectangle.whenContains(local, () -> {
                this.titleBarDragWindow = window;
                this.originWindowPosition = this.titleBarDragWindow.getPosition();
                this.dragStart = mouse.getPosition();
            });
        }
    }

    protected void ifMouseDragPossiblyMoveWindow(KeyStroke keyStroke) {
        if (this.titleBarDragWindow == null) {
            return;
        }
        if (!(keyStroke instanceof MouseAction)) {
            return;
        }
        MouseAction mouse = (MouseAction)keyStroke;
        if (mouse.isMouseDrag()) {
            TerminalPosition mp = mouse.getPosition();
            TerminalPosition wp = this.originWindowPosition;
            int dx2 = mp.getColumn() - this.dragStart.getColumn();
            int dy2 = mp.getRow() - this.dragStart.getRow();
            this.changeWindowHintsForDragged(this.titleBarDragWindow);
            this.titleBarDragWindow.setPosition(new TerminalPosition(wp.getColumn() + dx2, wp.getRow() + dy2));
        }
    }

    protected void changeWindowHintsForDragged(Window window) {
        HashSet<Window.Hint> hints = new HashSet<Window.Hint>(this.titleBarDragWindow.getHints());
        hints.remove(Window.Hint.CENTERED);
        hints.add(Window.Hint.FIXED_POSITION);
        this.titleBarDragWindow.setHints(hints);
    }

    @Override
    public WindowManager getWindowManager() {
        return this.windowManager;
    }

    @Override
    public synchronized WindowBasedTextGUI addWindow(Window window) {
        if (window.getComponent() == null) {
            window.setComponent(new EmptySpace(TerminalSize.ONE));
        }
        if (window.getTextGUI() != null) {
            window.getTextGUI().removeWindow(window);
        }
        window.setTextGUI(this);
        this.windowManager.onAdded(this, window, this.windowList.getWindowsInStableOrder());
        this.windowList.addWindow(window);
        this.invalidate();
        return this;
    }

    @Override
    public WindowBasedTextGUI addWindowAndWait(Window window) {
        this.addWindow(window);
        window.waitUntilClosed();
        return this;
    }

    @Override
    public synchronized WindowBasedTextGUI removeWindow(Window window) {
        boolean contained = this.windowList.removeWindow(window);
        if (!contained) {
            return this;
        }
        window.setTextGUI(null);
        this.windowManager.onRemoved(this, window, this.windowList.getWindowsInStableOrder());
        this.invalidate();
        return this;
    }

    @Override
    public void waitForWindowToClose(Window window) {
        while (window.getTextGUI() != null) {
            boolean sleep = true;
            TextGUIThread guiThread = this.getGUIThread();
            if (Thread.currentThread() == guiThread.getThread()) {
                try {
                    sleep = !guiThread.processEventsAndUpdate();
                }
                catch (EOFException ignore) {
                    break;
                }
                catch (IOException e2) {
                    throw new RuntimeException("Unexpected IOException while waiting for window to close", e2);
                }
            }
            if (!sleep) continue;
            try {
                Thread.sleep(1L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    @Override
    public synchronized Collection<Window> getWindows() {
        return this.windowList.getWindowsInZOrder();
    }

    @Override
    public synchronized MultiWindowTextGUI setActiveWindow(Window activeWindow) {
        this.windowList.setActiveWindow(activeWindow);
        return this;
    }

    @Override
    public synchronized Window getActiveWindow() {
        return this.windowList.getActiveWindow();
    }

    @Override
    public BasePane getBackgroundPane() {
        return this.backgroundPane;
    }

    @Override
    public WindowPostRenderer getWindowPostRenderer() {
        return this.postRenderer;
    }

    @Override
    public synchronized WindowBasedTextGUI moveToTop(Window window) {
        this.windowList.moveToTop(window);
        this.invalidate();
        return this;
    }

    public synchronized WindowBasedTextGUI moveToBottom(Window window) {
        this.windowList.moveToBottom(window);
        this.invalidate();
        return this;
    }

    @Override
    public synchronized WindowBasedTextGUI cycleActiveWindow(boolean reverse) {
        this.windowList.cycleActiveWindow(reverse);
        return this;
    }
}

