/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui2;

import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.gui2.Component;
import com.googlecode.lanterna.gui2.LayoutData;
import com.googlecode.lanterna.gui2.LayoutManager;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class GridLayout
implements LayoutManager {
    private static final GridLayoutData DEFAULT = new GridLayoutData(Alignment.BEGINNING, Alignment.BEGINNING, false, false, 1, 1);
    private final int numberOfColumns;
    private int horizontalSpacing;
    private int verticalSpacing;
    private int topMarginSize;
    private int bottomMarginSize;
    private int leftMarginSize;
    private int rightMarginSize;
    private boolean changed;

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment) {
        return GridLayout.createLayoutData(horizontalAlignment, verticalAlignment, false, false);
    }

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace) {
        return GridLayout.createLayoutData(horizontalAlignment, verticalAlignment, grabExtraHorizontalSpace, grabExtraVerticalSpace, 1, 1);
    }

    public static LayoutData createLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace, int horizontalSpan, int verticalSpan) {
        return new GridLayoutData(horizontalAlignment, verticalAlignment, grabExtraHorizontalSpace, grabExtraVerticalSpace, horizontalSpan, verticalSpan);
    }

    public static LayoutData createHorizontallyFilledLayoutData() {
        return GridLayout.createLayoutData(Alignment.FILL, Alignment.CENTER, true, false, 1, 1);
    }

    public static LayoutData createHorizontallyFilledLayoutData(int horizontalSpan) {
        return GridLayout.createLayoutData(Alignment.FILL, Alignment.CENTER, true, false, horizontalSpan, 1);
    }

    public static LayoutData createHorizontallyEndAlignedLayoutData(int horizontalSpan) {
        return GridLayout.createLayoutData(Alignment.END, Alignment.CENTER, true, false, horizontalSpan, 1);
    }

    public GridLayout(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
        this.horizontalSpacing = 1;
        this.verticalSpacing = 0;
        this.topMarginSize = 0;
        this.bottomMarginSize = 0;
        this.leftMarginSize = 1;
        this.rightMarginSize = 1;
        this.changed = true;
    }

    public int getHorizontalSpacing() {
        return this.horizontalSpacing;
    }

    public GridLayout setHorizontalSpacing(int horizontalSpacing) {
        if (horizontalSpacing < 0) {
            throw new IllegalArgumentException("Horizontal spacing cannot be less than 0");
        }
        this.horizontalSpacing = horizontalSpacing;
        this.changed = true;
        return this;
    }

    public int getVerticalSpacing() {
        return this.verticalSpacing;
    }

    public GridLayout setVerticalSpacing(int verticalSpacing) {
        if (verticalSpacing < 0) {
            throw new IllegalArgumentException("Vertical spacing cannot be less than 0");
        }
        this.verticalSpacing = verticalSpacing;
        this.changed = true;
        return this;
    }

    public int getTopMarginSize() {
        return this.topMarginSize;
    }

    public GridLayout setTopMarginSize(int topMarginSize) {
        if (topMarginSize < 0) {
            throw new IllegalArgumentException("Top margin size cannot be less than 0");
        }
        this.topMarginSize = topMarginSize;
        this.changed = true;
        return this;
    }

    public int getBottomMarginSize() {
        return this.bottomMarginSize;
    }

    public GridLayout setBottomMarginSize(int bottomMarginSize) {
        if (bottomMarginSize < 0) {
            throw new IllegalArgumentException("Bottom margin size cannot be less than 0");
        }
        this.bottomMarginSize = bottomMarginSize;
        this.changed = true;
        return this;
    }

    public int getLeftMarginSize() {
        return this.leftMarginSize;
    }

    public GridLayout setLeftMarginSize(int leftMarginSize) {
        if (leftMarginSize < 0) {
            throw new IllegalArgumentException("Left margin size cannot be less than 0");
        }
        this.leftMarginSize = leftMarginSize;
        this.changed = true;
        return this;
    }

    public int getRightMarginSize() {
        return this.rightMarginSize;
    }

    public GridLayout setRightMarginSize(int rightMarginSize) {
        if (rightMarginSize < 0) {
            throw new IllegalArgumentException("Right margin size cannot be less than 0");
        }
        this.rightMarginSize = rightMarginSize;
        this.changed = true;
        return this;
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public TerminalSize getPreferredSize(List<Component> components) {
        TerminalSize preferredSize = TerminalSize.ZERO;
        if (components.isEmpty()) {
            return preferredSize.withRelative(this.leftMarginSize + this.rightMarginSize, this.topMarginSize + this.bottomMarginSize);
        }
        Component[][] table = this.buildTable(components);
        table = this.eliminateUnusedRowsAndColumns(table);
        int preferredWidth = 0;
        int preferredHeight = 0;
        for (int width : this.getPreferredColumnWidths(table)) {
            preferredWidth += width;
        }
        for (int height : this.getPreferredRowHeights(table)) {
            preferredHeight += height;
        }
        preferredSize = preferredSize.withRelative(preferredWidth, preferredHeight);
        preferredSize = preferredSize.withRelativeColumns(this.leftMarginSize + this.rightMarginSize + (table[0].length - 1) * this.horizontalSpacing);
        preferredSize = preferredSize.withRelativeRows(this.topMarginSize + this.bottomMarginSize + (table.length - 1) * this.verticalSpacing);
        return preferredSize;
    }

    @Override
    public void doLayout(TerminalSize area, List<Component> components) {
        Component[][] table = this.buildTable(components);
        table = this.eliminateUnusedRowsAndColumns(table);
        if (area.equals(TerminalSize.ZERO) || table.length == 0 || area.getColumns() <= this.leftMarginSize + this.rightMarginSize + (table[0].length - 1) * this.horizontalSpacing || area.getRows() <= this.bottomMarginSize + this.topMarginSize + (table.length - 1) * this.verticalSpacing) {
            this.changed = false;
            return;
        }
        area = area.withRelative(-this.leftMarginSize - this.rightMarginSize, -this.topMarginSize - this.bottomMarginSize);
        IdentityHashMap<Component, TerminalSize> sizeMap = new IdentityHashMap<Component, TerminalSize>();
        IdentityHashMap<Component, TerminalPosition> positionMap = new IdentityHashMap<Component, TerminalPosition>();
        int[] columnWidths = this.getPreferredColumnWidths(table);
        Set<Integer> expandableColumns = this.getExpandableColumns(table);
        TerminalSize areaWithoutHorizontalSpacing = area.withRelativeColumns(-this.horizontalSpacing * (table[0].length - 1));
        int totalWidth = this.shrinkWidthToFitArea(areaWithoutHorizontalSpacing, columnWidths);
        while (areaWithoutHorizontalSpacing.getColumns() > totalWidth && !expandableColumns.isEmpty()) {
            totalWidth = this.grabExtraHorizontalSpace(areaWithoutHorizontalSpacing, columnWidths, expandableColumns, totalWidth);
        }
        int[] rowHeights = this.getPreferredRowHeights(table);
        Set<Integer> expandableRows = this.getExpandableRows(table);
        TerminalSize areaWithoutVerticalSpacing = area.withRelativeRows(-this.verticalSpacing * (table.length - 1));
        int totalHeight = this.shrinkHeightToFitArea(areaWithoutVerticalSpacing, rowHeights);
        while (areaWithoutVerticalSpacing.getRows() > totalHeight && !expandableRows.isEmpty()) {
            totalHeight = this.grabExtraVerticalSpace(areaWithoutVerticalSpacing, rowHeights, expandableRows, totalHeight);
        }
        TerminalPosition tableCellTopLeft = TerminalPosition.TOP_LEFT_CORNER;
        for (int y2 = 0; y2 < table.length; ++y2) {
            tableCellTopLeft = tableCellTopLeft.withColumn(0);
            for (int x2 = 0; x2 < table[y2].length; ++x2) {
                Component component = table[y2][x2];
                if (component != null && !positionMap.containsKey(component)) {
                    int i2;
                    GridLayoutData layoutData = this.getLayoutData(component);
                    TerminalSize size = component.getPreferredSize();
                    TerminalPosition position = tableCellTopLeft;
                    int availableHorizontalSpace = 0;
                    int availableVerticalSpace = 0;
                    for (i2 = 0; i2 < layoutData.horizontalSpan && x2 + i2 < columnWidths.length; ++i2) {
                        availableHorizontalSpace += columnWidths[x2 + i2] + (i2 > 0 ? this.horizontalSpacing : 0);
                    }
                    for (i2 = 0; i2 < layoutData.verticalSpan; ++i2) {
                        availableVerticalSpace += rowHeights[y2 + i2] + (i2 > 0 ? this.verticalSpacing : 0);
                    }
                    size = size.withColumns(Math.min(size.getColumns(), availableHorizontalSpace));
                    size = size.withRows(Math.min(size.getRows(), availableVerticalSpace));
                    switch (layoutData.horizontalAlignment) {
                        case CENTER: {
                            position = position.withRelativeColumn((availableHorizontalSpace - size.getColumns()) / 2);
                            break;
                        }
                        case END: {
                            position = position.withRelativeColumn(availableHorizontalSpace - size.getColumns());
                            break;
                        }
                        case FILL: {
                            size = size.withColumns(availableHorizontalSpace);
                            break;
                        }
                    }
                    switch (layoutData.verticalAlignment) {
                        case CENTER: {
                            position = position.withRelativeRow((availableVerticalSpace - size.getRows()) / 2);
                            break;
                        }
                        case END: {
                            position = position.withRelativeRow(availableVerticalSpace - size.getRows());
                            break;
                        }
                        case FILL: {
                            size = size.withRows(availableVerticalSpace);
                            break;
                        }
                    }
                    sizeMap.put(component, size);
                    positionMap.put(component, position);
                }
                tableCellTopLeft = tableCellTopLeft.withRelativeColumn(columnWidths[x2] + this.horizontalSpacing);
            }
            tableCellTopLeft = tableCellTopLeft.withRelativeRow(rowHeights[y2] + this.verticalSpacing);
        }
        for (Component component : components) {
            component.setPosition(((TerminalPosition)positionMap.get(component)).withRelative(this.leftMarginSize, this.topMarginSize));
            component.setSize((TerminalSize)sizeMap.get(component));
        }
        this.changed = false;
    }

    private int[] getPreferredColumnWidths(Component[][] table) {
        GridLayoutData layoutData;
        Component component;
        int i2;
        int actualNumberOfColumns = table[0].length;
        int[] columnWidths = new int[actualNumberOfColumns];
        for (Component[] row : table) {
            for (i2 = 0; i2 < actualNumberOfColumns; ++i2) {
                component = row[i2];
                if (component == null) continue;
                layoutData = this.getLayoutData(component);
                if (layoutData.horizontalSpan != 1) continue;
                columnWidths[i2] = Math.max(columnWidths[i2], component.getPreferredSize().getColumns());
            }
        }
        for (Component[] row : table) {
            i2 = 0;
            while (i2 < actualNumberOfColumns) {
                component = row[i2];
                if (component == null) {
                    ++i2;
                    continue;
                }
                layoutData = this.getLayoutData(component);
                int horizontalSpan = Math.min(layoutData.horizontalSpan, actualNumberOfColumns - i2);
                if (horizontalSpan > 1) {
                    int accumWidth = 0;
                    for (int j2 = i2; j2 < i2 + horizontalSpan; ++j2) {
                        accumWidth += columnWidths[j2];
                    }
                    int preferredWidth = component.getPreferredSize().getColumns();
                    if (preferredWidth > accumWidth) {
                        int columnOffset = 0;
                        do {
                            int n2 = i2 + columnOffset++;
                            columnWidths[n2] = columnWidths[n2] + 1;
                            ++accumWidth;
                            if (columnOffset != horizontalSpan) continue;
                            columnOffset = 0;
                        } while (preferredWidth > accumWidth);
                    }
                }
                i2 += horizontalSpan;
            }
        }
        return columnWidths;
    }

    private int[] getPreferredRowHeights(Component[][] table) {
        int numberOfRows = table.length;
        int[] rowHeights = new int[numberOfRows];
        int rowIndex = 0;
        Component[][] componentArray = table;
        int n2 = componentArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component[] row;
            for (Component component : row = componentArray[i2]) {
                if (component == null) continue;
                GridLayoutData layoutData = this.getLayoutData(component);
                if (layoutData.verticalSpan != 1) continue;
                rowHeights[rowIndex] = Math.max(rowHeights[rowIndex], component.getPreferredSize().getRows());
            }
            ++rowIndex;
        }
        for (int x2 = 0; x2 < this.numberOfColumns; ++x2) {
            int y2 = 0;
            while (y2 < numberOfRows) {
                if (x2 >= table[y2].length) {
                    ++y2;
                    continue;
                }
                Component component = table[y2][x2];
                if (component == null) {
                    ++y2;
                    continue;
                }
                GridLayoutData layoutData = this.getLayoutData(component);
                if (layoutData.verticalSpan > 1) {
                    int accumulatedHeight = 0;
                    for (int i3 = y2; i3 < y2 + layoutData.verticalSpan; ++i3) {
                        accumulatedHeight += rowHeights[i3];
                    }
                    int preferredHeight = component.getPreferredSize().getRows();
                    if (preferredHeight > accumulatedHeight) {
                        int rowOffset = 0;
                        do {
                            int n3 = y2 + rowOffset++;
                            rowHeights[n3] = rowHeights[n3] + 1;
                            ++accumulatedHeight;
                            if (rowOffset != layoutData.verticalSpan) continue;
                            rowOffset = 0;
                        } while (preferredHeight > accumulatedHeight);
                    }
                }
                y2 += layoutData.verticalSpan;
            }
        }
        return rowHeights;
    }

    private Set<Integer> getExpandableColumns(Component[][] table) {
        TreeSet<Integer> expandableColumns = new TreeSet<Integer>();
        Component previousComponent = null;
        for (Component[] row : table) {
            for (int i2 = 0; i2 < row.length; ++i2) {
                if (row[i2] == null || row[i2] == previousComponent) continue;
                GridLayoutData layoutData = this.getLayoutData(row[i2]);
                if (layoutData.grabExtraHorizontalSpace) {
                    expandableColumns.add(i2);
                }
                previousComponent = row[i2];
            }
        }
        return expandableColumns;
    }

    private Set<Integer> getExpandableRows(Component[][] table) {
        TreeSet<Integer> expandableRows = new TreeSet<Integer>();
        Component previousComponent = null;
        if (table.length > 0) {
            for (int columnIndex = 0; columnIndex < table[0].length; ++columnIndex) {
                for (int rowIndex = 0; rowIndex < table.length; ++rowIndex) {
                    Component cell = table[rowIndex][columnIndex];
                    if (cell == null || cell == previousComponent) continue;
                    GridLayoutData layoutData = this.getLayoutData(cell);
                    if (layoutData.grabExtraVerticalSpace) {
                        expandableRows.add(rowIndex);
                    }
                    previousComponent = cell;
                }
            }
        }
        return expandableRows;
    }

    private int shrinkWidthToFitArea(TerminalSize area, int[] columnWidths) {
        int totalWidth = 0;
        for (int width : columnWidths) {
            totalWidth += width;
        }
        if (totalWidth > area.getColumns()) {
            int columnOffset = 0;
            do {
                if (columnWidths[columnOffset] > 0) {
                    int n2 = columnOffset;
                    columnWidths[n2] = columnWidths[n2] - 1;
                    --totalWidth;
                }
                if (++columnOffset != columnWidths.length) continue;
                columnOffset = 0;
            } while (totalWidth > area.getColumns());
        }
        return totalWidth;
    }

    private int shrinkHeightToFitArea(TerminalSize area, int[] rowHeights) {
        int totalHeight = 0;
        for (int height : rowHeights) {
            totalHeight += height;
        }
        if (totalHeight > area.getRows()) {
            int rowOffset = 0;
            do {
                if (rowHeights[rowOffset] > 0) {
                    int n2 = rowOffset;
                    rowHeights[n2] = rowHeights[n2] - 1;
                    --totalHeight;
                }
                if (++rowOffset != rowHeights.length) continue;
                rowOffset = 0;
            } while (totalHeight > area.getRows());
        }
        return totalHeight;
    }

    private int grabExtraHorizontalSpace(TerminalSize area, int[] columnWidths, Set<Integer> expandableColumns, int totalWidth) {
        Iterator<Integer> iterator2 = expandableColumns.iterator();
        while (iterator2.hasNext()) {
            int columnIndex;
            int n2 = columnIndex = iterator2.next().intValue();
            columnWidths[n2] = columnWidths[n2] + 1;
            if (area.getColumns() != ++totalWidth) continue;
            break;
        }
        return totalWidth;
    }

    private int grabExtraVerticalSpace(TerminalSize area, int[] rowHeights, Set<Integer> expandableRows, int totalHeight) {
        Iterator<Integer> iterator2 = expandableRows.iterator();
        while (iterator2.hasNext()) {
            int rowIndex;
            int n2 = rowIndex = iterator2.next().intValue();
            rowHeights[n2] = rowHeights[n2] + 1;
            if (area.getColumns() != ++totalHeight) continue;
            break;
        }
        return totalHeight;
    }

    private Component[][] buildTable(List<Component> components) {
        ArrayList<Component[]> rows = new ArrayList<Component[]>();
        ArrayList<int[]> hspans = new ArrayList<int[]>();
        ArrayList<int[]> vspans = new ArrayList<int[]>();
        int rowsExtent = 1;
        LinkedList<Component> toBePlaced = new LinkedList<Component>(components);
        for (int rowCount = 0; !toBePlaced.isEmpty() || rowCount < rowsExtent; ++rowCount) {
            Component[] row = new Component[this.numberOfColumns];
            int[] hspan = new int[this.numberOfColumns];
            int[] vspan = new int[this.numberOfColumns];
            for (int i2 = 0; i2 < this.numberOfColumns; ++i2) {
                if (i2 > 0 && hspan[i2 - 1] > 1) {
                    row[i2] = row[i2 - 1];
                    hspan[i2] = hspan[i2 - 1] - 1;
                    vspan[i2] = vspan[i2 - 1];
                    continue;
                }
                if (rowCount > 0 && ((int[])vspans.get(rowCount - 1))[i2] > 1) {
                    row[i2] = ((Component[])rows.get(rowCount - 1))[i2];
                    hspan[i2] = ((int[])hspans.get(rowCount - 1))[i2];
                    vspan[i2] = ((int[])vspans.get(rowCount - 1))[i2] - 1;
                    continue;
                }
                if (!toBePlaced.isEmpty()) {
                    Component component = (Component)toBePlaced.poll();
                    GridLayoutData gridLayoutData = this.getLayoutData(component);
                    row[i2] = component;
                    hspan[i2] = gridLayoutData.horizontalSpan;
                    vspan[i2] = gridLayoutData.verticalSpan;
                    rowsExtent = Math.max(rowsExtent, rowCount + gridLayoutData.verticalSpan);
                    continue;
                }
                row[i2] = null;
                hspan[i2] = 1;
                vspan[i2] = 1;
            }
            rows.add(row);
            hspans.add(hspan);
            vspans.add(vspan);
        }
        return (Component[][])rows.toArray((T[])new Component[rows.size()][]);
    }

    private Component[][] eliminateUnusedRowsAndColumns(Component[][] table) {
        if (table.length == 0) {
            return table;
        }
        ArrayList<Integer> rowsToRemove = new ArrayList<Integer>();
        ArrayList<Integer> columnsToRemove = new ArrayList<Integer>();
        int tableRows = table.length;
        int tableColumns = table[0].length;
        block0: for (int column = tableColumns - 1; column > 0; --column) {
            for (Component[] row : table) {
                if (row[column] != null) continue block0;
            }
            columnsToRemove.add(column);
        }
        block2: for (int row = tableRows - 1; row > 0; --row) {
            for (int column = 0; column < tableColumns; ++column) {
                if (table[row][column] != null) continue block2;
            }
            rowsToRemove.add(row);
        }
        if (rowsToRemove.isEmpty() && columnsToRemove.isEmpty()) {
            return table;
        }
        Component[][] newTable = new Component[tableRows - rowsToRemove.size()][];
        int insertedRowCounter = 0;
        for (Component[] row : table) {
            Component[] newColumn = new Component[tableColumns - columnsToRemove.size()];
            int insertedColumnCounter = 0;
            for (int column = 0; column < tableColumns; ++column) {
                if (columnsToRemove.contains(column)) continue;
                newColumn[insertedColumnCounter++] = row[column];
            }
            newTable[insertedRowCounter++] = newColumn;
        }
        return newTable;
    }

    private GridLayoutData getLayoutData(Component component) {
        LayoutData layoutData = component.getLayoutData();
        if (layoutData instanceof GridLayoutData) {
            return (GridLayoutData)layoutData;
        }
        return DEFAULT;
    }

    static class GridLayoutData
    implements LayoutData {
        final Alignment horizontalAlignment;
        final Alignment verticalAlignment;
        final boolean grabExtraHorizontalSpace;
        final boolean grabExtraVerticalSpace;
        final int horizontalSpan;
        final int verticalSpan;

        private GridLayoutData(Alignment horizontalAlignment, Alignment verticalAlignment, boolean grabExtraHorizontalSpace, boolean grabExtraVerticalSpace, int horizontalSpan, int verticalSpan) {
            if (horizontalSpan < 1 || verticalSpan < 1) {
                throw new IllegalArgumentException("Horizontal/Vertical span must be 1 or greater");
            }
            this.horizontalAlignment = horizontalAlignment;
            this.verticalAlignment = verticalAlignment;
            this.grabExtraHorizontalSpace = grabExtraHorizontalSpace;
            this.grabExtraVerticalSpace = grabExtraVerticalSpace;
            this.horizontalSpan = horizontalSpan;
            this.verticalSpan = verticalSpan;
        }
    }

    public static enum Alignment {
        BEGINNING,
        CENTER,
        END,
        FILL;

    }
}

