/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.graphics;

import com.googlecode.lanterna.SGR;
import com.googlecode.lanterna.TerminalPosition;
import com.googlecode.lanterna.TerminalSize;
import com.googlecode.lanterna.TextCharacter;
import com.googlecode.lanterna.TextColor;
import com.googlecode.lanterna.graphics.AbstractTextGraphics;
import com.googlecode.lanterna.graphics.TextGraphics;
import com.googlecode.lanterna.graphics.TextImage;
import java.util.Arrays;

public class BasicTextImage
implements TextImage {
    private final TerminalSize size;
    private final TextCharacter[][] buffer;

    public BasicTextImage(int columns, int rows) {
        this(new TerminalSize(columns, rows));
    }

    public BasicTextImage(TerminalSize size) {
        this(size, new TextCharacter(' ', (TextColor)TextColor.ANSI.DEFAULT, (TextColor)TextColor.ANSI.DEFAULT, new SGR[0]));
    }

    public BasicTextImage(TerminalSize size, TextCharacter initialContent) {
        this(size, new TextCharacter[0][], initialContent);
    }

    private BasicTextImage(TerminalSize size, TextCharacter[][] toCopy, TextCharacter initialContent) {
        if (size == null || toCopy == null || initialContent == null) {
            throw new IllegalArgumentException("Cannot create BasicTextImage with null " + (size == null ? "size" : (toCopy == null ? "toCopy" : "filler")));
        }
        this.size = size;
        int rows = size.getRows();
        int columns = size.getColumns();
        this.buffer = new TextCharacter[rows][];
        for (int y2 = 0; y2 < rows; ++y2) {
            this.buffer[y2] = new TextCharacter[columns];
            for (int x2 = 0; x2 < columns; ++x2) {
                this.buffer[y2][x2] = y2 < toCopy.length && x2 < toCopy[y2].length ? toCopy[y2][x2] : initialContent;
            }
        }
    }

    @Override
    public TerminalSize getSize() {
        return this.size;
    }

    @Override
    public void setAll(TextCharacter character) {
        if (character == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setAll(..) with null character");
        }
        for (Object[] objectArray : this.buffer) {
            Arrays.fill(objectArray, character);
        }
    }

    @Override
    public BasicTextImage resize(TerminalSize newSize, TextCharacter filler) {
        if (newSize == null || filler == null) {
            throw new IllegalArgumentException("Cannot resize BasicTextImage with null " + (newSize == null ? "newSize" : "filler"));
        }
        if (newSize.getRows() == this.buffer.length && (this.buffer.length == 0 || newSize.getColumns() == this.buffer[0].length)) {
            return this;
        }
        return new BasicTextImage(newSize, this.buffer, filler);
    }

    @Override
    public void setCharacterAt(TerminalPosition position, TextCharacter character) {
        if (position == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setCharacterAt(..) with null position");
        }
        this.setCharacterAt(position.getColumn(), position.getRow(), character);
    }

    @Override
    public void setCharacterAt(int column, int row, TextCharacter character) {
        if (character == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.setCharacterAt(..) with null character");
        }
        if (column < 0 || row < 0 || row >= this.buffer.length || column >= this.buffer[0].length) {
            return;
        }
        if (column > 0 && this.buffer[row][column - 1].isDoubleWidth()) {
            this.buffer[row][column - 1] = this.buffer[row][column - 1].withCharacter(' ');
        }
        this.buffer[row][column] = character;
        if (character.isDoubleWidth() && column + 1 < this.buffer[0].length) {
            this.buffer[row][column + 1] = character.withCharacter(' ');
        }
    }

    @Override
    public TextCharacter getCharacterAt(TerminalPosition position) {
        if (position == null) {
            throw new IllegalArgumentException("Cannot call BasicTextImage.getCharacterAt(..) with null position");
        }
        return this.getCharacterAt(position.getColumn(), position.getRow());
    }

    @Override
    public TextCharacter getCharacterAt(int column, int row) {
        if (column < 0 || row < 0 || row >= this.buffer.length || column >= this.buffer[0].length) {
            return null;
        }
        return this.buffer[row][column];
    }

    @Override
    public void copyTo(TextImage destination) {
        if (this.buffer.length > 0) {
            this.copyTo(destination, 0, this.buffer.length, 0, this.buffer[0].length, 0, 0);
        }
    }

    @Override
    public void copyTo(TextImage destination, int startRowIndex, int rows, int startColumnIndex, int columns, int destinationRowOffset, int destinationColumnOffset) {
        int y2;
        if (startColumnIndex < 0) {
            destinationColumnOffset += -startColumnIndex;
            columns += startColumnIndex;
            startColumnIndex = 0;
        }
        if (startRowIndex < 0) {
            destinationRowOffset += -startRowIndex;
            rows += startRowIndex;
            startRowIndex = 0;
        }
        if (destinationColumnOffset < 0) {
            startColumnIndex -= destinationColumnOffset;
            columns += destinationColumnOffset;
            destinationColumnOffset = 0;
        }
        if (destinationRowOffset < 0) {
            startRowIndex -= destinationRowOffset;
            rows += destinationRowOffset;
            destinationRowOffset = 0;
        }
        columns = (rows = Math.min(this.buffer.length - startRowIndex, rows)) > 0 ? Math.min(this.buffer[0].length - startColumnIndex, columns) : 0;
        columns = Math.min(destination.getSize().getColumns() - destinationColumnOffset, columns);
        rows = Math.min(destination.getSize().getRows() - destinationRowOffset, rows);
        if (columns <= 0 || rows <= 0) {
            return;
        }
        TerminalSize destinationSize = destination.getSize();
        if (destination instanceof BasicTextImage) {
            int targetRow = destinationRowOffset;
            for (y2 = startRowIndex; y2 < startRowIndex + rows && targetRow < destinationSize.getRows(); ++y2) {
                System.arraycopy(this.buffer[y2], startColumnIndex, ((BasicTextImage)destination).buffer[targetRow++], destinationColumnOffset, columns);
            }
        } else {
            for (int y3 = startRowIndex; y3 < startRowIndex + rows; ++y3) {
                for (int x2 = startColumnIndex; x2 < startColumnIndex + columns; ++x2) {
                    TextCharacter character = this.buffer[y3][x2];
                    if (character.isDoubleWidth()) {
                        if (x2 + 1 < startColumnIndex + columns) {
                            destination.setCharacterAt(x2 - startColumnIndex + destinationColumnOffset, y3 - startRowIndex + destinationRowOffset, character.withCharacter(' '));
                        } else if (x2 + 1 == startColumnIndex + columns) {
                            character = character.withCharacter(' ');
                        }
                    }
                    destination.setCharacterAt(x2 - startColumnIndex + destinationColumnOffset, y3 - startRowIndex + destinationRowOffset, character);
                    if (!character.isDoubleWidth()) continue;
                    ++x2;
                }
            }
        }
        if (destinationColumnOffset > 0) {
            int destinationX = destinationColumnOffset - 1;
            for (y2 = startRowIndex; y2 < startRowIndex + rows; ++y2) {
                int destinationY = y2 - startRowIndex + destinationRowOffset;
                TextCharacter neighbour = destination.getCharacterAt(destinationX, destinationY);
                if (!neighbour.isDoubleWidth()) continue;
                destination.setCharacterAt(destinationX, destinationY, neighbour.withCharacter(' '));
            }
        }
    }

    @Override
    public TextGraphics newTextGraphics() {
        return new AbstractTextGraphics(){

            @Override
            public TextGraphics setCharacter(int columnIndex, int rowIndex, TextCharacter textCharacter) {
                BasicTextImage.this.setCharacterAt(columnIndex, rowIndex, textCharacter);
                return this;
            }

            @Override
            public TextCharacter getCharacter(int column, int row) {
                return BasicTextImage.this.getCharacterAt(column, row);
            }

            @Override
            public TerminalSize getSize() {
                return BasicTextImage.this.size;
            }
        };
    }

    private TextCharacter[] newBlankLine() {
        Object[] line = new TextCharacter[this.size.getColumns()];
        Arrays.fill(line, TextCharacter.DEFAULT_CHARACTER);
        return line;
    }

    @Override
    public void scrollLines(int firstLine, int lastLine, int distance) {
        block6: {
            int curLine;
            block7: {
                int curLine2;
                if (firstLine < 0) {
                    firstLine = 0;
                }
                if (lastLine >= this.size.getRows()) {
                    lastLine = this.size.getRows() - 1;
                }
                if (firstLine >= lastLine) break block6;
                if (distance <= 0) break block7;
                for (curLine2 = firstLine; curLine2 <= lastLine - distance; ++curLine2) {
                    this.buffer[curLine2] = this.buffer[curLine2 + distance];
                }
                while (curLine2 <= lastLine) {
                    this.buffer[curLine2] = this.newBlankLine();
                    ++curLine2;
                }
                break block6;
            }
            if (distance >= 0) break block6;
            distance = -distance;
            for (curLine = lastLine; curLine >= firstLine + distance; --curLine) {
                this.buffer[curLine] = this.buffer[curLine - distance];
            }
            while (curLine >= firstLine) {
                this.buffer[curLine] = this.newBlankLine();
                --curLine;
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size.getRows() * (this.size.getColumns() + 1) + 50);
        sb.append('{').append(this.size.getColumns()).append('x').append(this.size.getRows()).append('}').append('\n');
        TextCharacter[][] textCharacterArray = this.buffer;
        int n2 = textCharacterArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            TextCharacter[] line;
            for (TextCharacter tc : line = textCharacterArray[i2]) {
                sb.append(tc.getCharacterString());
            }
            sb.append('\n');
        }
        return sb.toString();
    }
}

