/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.PublicKeyVerify;
import com.google.crypto.tink.subtle.Bytes;
import com.google.crypto.tink.subtle.EngineFactory;
import com.google.crypto.tink.subtle.Enums;
import com.google.crypto.tink.subtle.Hex;
import com.google.crypto.tink.subtle.SubtleUtil;
import com.google.crypto.tink.subtle.Validators;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.interfaces.RSAPublicKey;

public final class RsaSsaPkcs1VerifyJce
implements PublicKeyVerify {
    private static final String ASN_PREFIX_SHA256 = "3031300d060960864801650304020105000420";
    private static final String ASN_PREFIX_SHA512 = "3051300d060960864801650304020305000440";
    private final RSAPublicKey publicKey;
    private final Enums.HashType hash;

    public RsaSsaPkcs1VerifyJce(RSAPublicKey pubKey, Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        Validators.validateRsaModulusSize(pubKey.getModulus().bitLength());
        Validators.validateRsaPublicExponent(pubKey.getPublicExponent());
        this.publicKey = pubKey;
        this.hash = hash;
    }

    @Override
    public void verify(byte[] signature, byte[] data) throws GeneralSecurityException {
        byte[] expectedEm;
        BigInteger e2 = this.publicKey.getPublicExponent();
        BigInteger n2 = this.publicKey.getModulus();
        int nLengthInBytes = (n2.bitLength() + 7) / 8;
        if (nLengthInBytes != signature.length) {
            throw new GeneralSecurityException("invalid signature's length");
        }
        BigInteger s2 = SubtleUtil.bytes2Integer(signature);
        if (s2.compareTo(n2) >= 0) {
            throw new GeneralSecurityException("signature out of range");
        }
        BigInteger m3 = s2.modPow(e2, n2);
        byte[] em2 = SubtleUtil.integer2Bytes(m3, nLengthInBytes);
        if (!Bytes.equal(em2, expectedEm = this.emsaPkcs1(data, nLengthInBytes, this.hash))) {
            throw new GeneralSecurityException("invalid signature");
        }
    }

    private byte[] emsaPkcs1(byte[] m3, int emLen, Enums.HashType hash) throws GeneralSecurityException {
        Validators.validateSignatureHash(hash);
        MessageDigest digest = EngineFactory.MESSAGE_DIGEST.getInstance(SubtleUtil.toDigestAlgo(this.hash));
        digest.update(m3);
        byte[] h2 = digest.digest();
        byte[] asnPrefix = this.toAsnPrefix(hash);
        int tLen = asnPrefix.length + h2.length;
        if (emLen < tLen + 11) {
            throw new GeneralSecurityException("intended encoded message length too short");
        }
        byte[] em2 = new byte[emLen];
        int offset = 0;
        em2[offset++] = 0;
        em2[offset++] = 1;
        for (int i2 = 0; i2 < emLen - tLen - 3; ++i2) {
            em2[offset++] = -1;
        }
        em2[offset++] = 0;
        System.arraycopy(asnPrefix, 0, em2, offset, asnPrefix.length);
        System.arraycopy(h2, 0, em2, offset + asnPrefix.length, h2.length);
        return em2;
    }

    private byte[] toAsnPrefix(Enums.HashType hash) throws GeneralSecurityException {
        switch (hash) {
            case SHA256: {
                return Hex.decode(ASN_PREFIX_SHA256);
            }
            case SHA512: {
                return Hex.decode(ASN_PREFIX_SHA512);
            }
        }
        throw new GeneralSecurityException("Unsupported hash " + (Object)((Object)hash));
    }
}

