/*
 * Decompiled with CFR 0.152.
 */
package com.google.crypto.tink.subtle;

import com.google.crypto.tink.annotations.Alpha;
import java.util.Arrays;

@Alpha
final class Field25519 {
    static final int FIELD_LEN = 32;
    static final int LIMB_CNT = 10;
    private static final long TWO_TO_25 = 0x2000000L;
    private static final long TWO_TO_26 = 0x4000000L;
    private static final int[] EXPAND_START = new int[]{0, 3, 6, 9, 12, 16, 19, 22, 25, 28};
    private static final int[] EXPAND_SHIFT = new int[]{0, 2, 3, 5, 6, 0, 1, 3, 4, 6};
    private static final int[] MASK = new int[]{0x3FFFFFF, 0x1FFFFFF};
    private static final int[] SHIFT = new int[]{26, 25};

    Field25519() {
    }

    static void sum(long[] output, long[] in1, long[] in2) {
        for (int i2 = 0; i2 < 10; ++i2) {
            output[i2] = in1[i2] + in2[i2];
        }
    }

    static void sum(long[] output, long[] in2) {
        Field25519.sum(output, output, in2);
    }

    static void sub(long[] output, long[] in1, long[] in2) {
        for (int i2 = 0; i2 < 10; ++i2) {
            output[i2] = in1[i2] - in2[i2];
        }
    }

    static void sub(long[] output, long[] in2) {
        Field25519.sub(output, in2, output);
    }

    static void scalarProduct(long[] output, long[] in2, long scalar) {
        for (int i2 = 0; i2 < 10; ++i2) {
            output[i2] = in2[i2] * scalar;
        }
    }

    static void product(long[] out, long[] in2, long[] in3) {
        out[0] = in2[0] * in3[0];
        out[1] = in2[0] * in3[1] + in2[1] * in3[0];
        out[2] = 2L * in2[1] * in3[1] + in2[0] * in3[2] + in2[2] * in3[0];
        out[3] = in2[1] * in3[2] + in2[2] * in3[1] + in2[0] * in3[3] + in2[3] * in3[0];
        out[4] = in2[2] * in3[2] + 2L * (in2[1] * in3[3] + in2[3] * in3[1]) + in2[0] * in3[4] + in2[4] * in3[0];
        out[5] = in2[2] * in3[3] + in2[3] * in3[2] + in2[1] * in3[4] + in2[4] * in3[1] + in2[0] * in3[5] + in2[5] * in3[0];
        out[6] = 2L * (in2[3] * in3[3] + in2[1] * in3[5] + in2[5] * in3[1]) + in2[2] * in3[4] + in2[4] * in3[2] + in2[0] * in3[6] + in2[6] * in3[0];
        out[7] = in2[3] * in3[4] + in2[4] * in3[3] + in2[2] * in3[5] + in2[5] * in3[2] + in2[1] * in3[6] + in2[6] * in3[1] + in2[0] * in3[7] + in2[7] * in3[0];
        out[8] = in2[4] * in3[4] + 2L * (in2[3] * in3[5] + in2[5] * in3[3] + in2[1] * in3[7] + in2[7] * in3[1]) + in2[2] * in3[6] + in2[6] * in3[2] + in2[0] * in3[8] + in2[8] * in3[0];
        out[9] = in2[4] * in3[5] + in2[5] * in3[4] + in2[3] * in3[6] + in2[6] * in3[3] + in2[2] * in3[7] + in2[7] * in3[2] + in2[1] * in3[8] + in2[8] * in3[1] + in2[0] * in3[9] + in2[9] * in3[0];
        out[10] = 2L * (in2[5] * in3[5] + in2[3] * in3[7] + in2[7] * in3[3] + in2[1] * in3[9] + in2[9] * in3[1]) + in2[4] * in3[6] + in2[6] * in3[4] + in2[2] * in3[8] + in2[8] * in3[2];
        out[11] = in2[5] * in3[6] + in2[6] * in3[5] + in2[4] * in3[7] + in2[7] * in3[4] + in2[3] * in3[8] + in2[8] * in3[3] + in2[2] * in3[9] + in2[9] * in3[2];
        out[12] = in2[6] * in3[6] + 2L * (in2[5] * in3[7] + in2[7] * in3[5] + in2[3] * in3[9] + in2[9] * in3[3]) + in2[4] * in3[8] + in2[8] * in3[4];
        out[13] = in2[6] * in3[7] + in2[7] * in3[6] + in2[5] * in3[8] + in2[8] * in3[5] + in2[4] * in3[9] + in2[9] * in3[4];
        out[14] = 2L * (in2[7] * in3[7] + in2[5] * in3[9] + in2[9] * in3[5]) + in2[6] * in3[8] + in2[8] * in3[6];
        out[15] = in2[7] * in3[8] + in2[8] * in3[7] + in2[6] * in3[9] + in2[9] * in3[6];
        out[16] = in2[8] * in3[8] + 2L * (in2[7] * in3[9] + in2[9] * in3[7]);
        out[17] = in2[8] * in3[9] + in2[9] * in3[8];
        out[18] = 2L * in2[9] * in3[9];
    }

    static void reduce(long[] input, long[] output) {
        long[] tmp;
        if (input.length == 19) {
            tmp = input;
        } else {
            tmp = new long[19];
            System.arraycopy(input, 0, tmp, 0, input.length);
        }
        Field25519.reduceSizeByModularReduction(tmp);
        Field25519.reduceCoefficients(tmp);
        System.arraycopy(tmp, 0, output, 0, 10);
    }

    static void reduceSizeByModularReduction(long[] output) {
        output[8] = output[8] + (output[18] << 4);
        output[8] = output[8] + (output[18] << 1);
        output[8] = output[8] + output[18];
        output[7] = output[7] + (output[17] << 4);
        output[7] = output[7] + (output[17] << 1);
        output[7] = output[7] + output[17];
        output[6] = output[6] + (output[16] << 4);
        output[6] = output[6] + (output[16] << 1);
        output[6] = output[6] + output[16];
        output[5] = output[5] + (output[15] << 4);
        output[5] = output[5] + (output[15] << 1);
        output[5] = output[5] + output[15];
        output[4] = output[4] + (output[14] << 4);
        output[4] = output[4] + (output[14] << 1);
        output[4] = output[4] + output[14];
        output[3] = output[3] + (output[13] << 4);
        output[3] = output[3] + (output[13] << 1);
        output[3] = output[3] + output[13];
        output[2] = output[2] + (output[12] << 4);
        output[2] = output[2] + (output[12] << 1);
        output[2] = output[2] + output[12];
        output[1] = output[1] + (output[11] << 4);
        output[1] = output[1] + (output[11] << 1);
        output[1] = output[1] + output[11];
        output[0] = output[0] + (output[10] << 4);
        output[0] = output[0] + (output[10] << 1);
        output[0] = output[0] + output[10];
    }

    static void reduceCoefficients(long[] output) {
        output[10] = 0L;
        for (int i2 = 0; i2 < 10; i2 += 2) {
            long over = output[i2] / 0x4000000L;
            int n2 = i2;
            output[n2] = output[n2] - (over << 26);
            int n3 = i2 + 1;
            output[n3] = output[n3] + over;
            over = output[i2 + 1] / 0x2000000L;
            int n4 = i2 + 1;
            output[n4] = output[n4] - (over << 25);
            int n5 = i2 + 2;
            output[n5] = output[n5] + over;
        }
        output[0] = output[0] + (output[10] << 4);
        output[0] = output[0] + (output[10] << 1);
        output[0] = output[0] + output[10];
        output[10] = 0L;
        long over = output[0] / 0x4000000L;
        output[0] = output[0] - (over << 26);
        output[1] = output[1] + over;
    }

    static void mult(long[] output, long[] in2, long[] in22) {
        long[] t2 = new long[19];
        Field25519.product(t2, in2, in22);
        Field25519.reduce(t2, output);
    }

    private static void squareInner(long[] out, long[] in2) {
        out[0] = in2[0] * in2[0];
        out[1] = 2L * in2[0] * in2[1];
        out[2] = 2L * (in2[1] * in2[1] + in2[0] * in2[2]);
        out[3] = 2L * (in2[1] * in2[2] + in2[0] * in2[3]);
        out[4] = in2[2] * in2[2] + 4L * in2[1] * in2[3] + 2L * in2[0] * in2[4];
        out[5] = 2L * (in2[2] * in2[3] + in2[1] * in2[4] + in2[0] * in2[5]);
        out[6] = 2L * (in2[3] * in2[3] + in2[2] * in2[4] + in2[0] * in2[6] + 2L * in2[1] * in2[5]);
        out[7] = 2L * (in2[3] * in2[4] + in2[2] * in2[5] + in2[1] * in2[6] + in2[0] * in2[7]);
        out[8] = in2[4] * in2[4] + 2L * (in2[2] * in2[6] + in2[0] * in2[8] + 2L * (in2[1] * in2[7] + in2[3] * in2[5]));
        out[9] = 2L * (in2[4] * in2[5] + in2[3] * in2[6] + in2[2] * in2[7] + in2[1] * in2[8] + in2[0] * in2[9]);
        out[10] = 2L * (in2[5] * in2[5] + in2[4] * in2[6] + in2[2] * in2[8] + 2L * (in2[3] * in2[7] + in2[1] * in2[9]));
        out[11] = 2L * (in2[5] * in2[6] + in2[4] * in2[7] + in2[3] * in2[8] + in2[2] * in2[9]);
        out[12] = in2[6] * in2[6] + 2L * (in2[4] * in2[8] + 2L * (in2[5] * in2[7] + in2[3] * in2[9]));
        out[13] = 2L * (in2[6] * in2[7] + in2[5] * in2[8] + in2[4] * in2[9]);
        out[14] = 2L * (in2[7] * in2[7] + in2[6] * in2[8] + 2L * in2[5] * in2[9]);
        out[15] = 2L * (in2[7] * in2[8] + in2[6] * in2[9]);
        out[16] = in2[8] * in2[8] + 4L * in2[7] * in2[9];
        out[17] = 2L * in2[8] * in2[9];
        out[18] = 2L * in2[9] * in2[9];
    }

    static void square(long[] output, long[] in2) {
        long[] t2 = new long[19];
        Field25519.squareInner(t2, in2);
        Field25519.reduce(t2, output);
    }

    static long[] expand(byte[] input) {
        long[] output = new long[10];
        for (int i2 = 0; i2 < 10; ++i2) {
            output[i2] = ((long)(input[EXPAND_START[i2]] & 0xFF) | (long)(input[EXPAND_START[i2] + 1] & 0xFF) << 8 | (long)(input[EXPAND_START[i2] + 2] & 0xFF) << 16 | (long)(input[EXPAND_START[i2] + 3] & 0xFF) << 24) >> EXPAND_SHIFT[i2] & (long)MASK[i2 & 1];
        }
        return output;
    }

    static byte[] contract(long[] inputLimbs) {
        int carry;
        int i2;
        int j2;
        long[] input = Arrays.copyOf(inputLimbs, 10);
        for (j2 = 0; j2 < 2; ++j2) {
            for (i2 = 0; i2 < 9; ++i2) {
                carry = -((int)((input[i2] & input[i2] >> 31) >> SHIFT[i2 & 1]));
                input[i2] = input[i2] + (long)(carry << SHIFT[i2 & 1]);
                int n2 = i2 + 1;
                input[n2] = input[n2] - (long)carry;
            }
            int carry2 = -((int)((input[9] & input[9] >> 31) >> 25));
            input[9] = input[9] + (long)(carry2 << 25);
            input[0] = input[0] - (long)(carry2 * 19);
        }
        int carry3 = -((int)((input[0] & input[0] >> 31) >> 26));
        input[0] = input[0] + (long)(carry3 << 26);
        input[1] = input[1] - (long)carry3;
        for (j2 = 0; j2 < 2; ++j2) {
            for (i2 = 0; i2 < 9; ++i2) {
                carry = (int)(input[i2] >> SHIFT[i2 & 1]);
                int n3 = i2;
                input[n3] = input[n3] & (long)MASK[i2 & 1];
                int n4 = i2 + 1;
                input[n4] = input[n4] + (long)carry;
            }
        }
        carry3 = (int)(input[9] >> 25);
        input[9] = input[9] & 0x1FFFFFFL;
        input[0] = input[0] + (long)(19 * carry3);
        int mask = Field25519.gte((int)input[0], 67108845);
        for (i2 = 1; i2 < 10; ++i2) {
            mask &= Field25519.eq((int)input[i2], MASK[i2 & 1]);
        }
        input[0] = input[0] - (long)(mask & 0x3FFFFED);
        input[1] = input[1] - (long)(mask & 0x1FFFFFF);
        for (i2 = 2; i2 < 10; i2 += 2) {
            int n5 = i2;
            input[n5] = input[n5] - (long)(mask & 0x3FFFFFF);
            int n6 = i2 + 1;
            input[n6] = input[n6] - (long)(mask & 0x1FFFFFF);
        }
        for (i2 = 0; i2 < 10; ++i2) {
            int n7 = i2;
            input[n7] = input[n7] << EXPAND_SHIFT[i2];
        }
        byte[] output = new byte[32];
        for (int i3 = 0; i3 < 10; ++i3) {
            int n8 = EXPAND_START[i3];
            output[n8] = (byte)((long)output[n8] | input[i3] & 0xFFL);
            int n9 = EXPAND_START[i3] + 1;
            output[n9] = (byte)((long)output[n9] | input[i3] >> 8 & 0xFFL);
            int n10 = EXPAND_START[i3] + 2;
            output[n10] = (byte)((long)output[n10] | input[i3] >> 16 & 0xFFL);
            int n11 = EXPAND_START[i3] + 3;
            output[n11] = (byte)((long)output[n11] | input[i3] >> 24 & 0xFFL);
        }
        return output;
    }

    static void inverse(long[] out, long[] z2) {
        int i2;
        long[] z22 = new long[10];
        long[] z9 = new long[10];
        long[] z11 = new long[10];
        long[] z2To5Minus1 = new long[10];
        long[] z2To10Minus1 = new long[10];
        long[] z2To20Minus1 = new long[10];
        long[] z2To50Minus1 = new long[10];
        long[] z2To100Minus1 = new long[10];
        long[] t0 = new long[10];
        long[] t1 = new long[10];
        Field25519.square(z22, z2);
        Field25519.square(t1, z22);
        Field25519.square(t0, t1);
        Field25519.mult(z9, t0, z2);
        Field25519.mult(z11, z9, z22);
        Field25519.square(t0, z11);
        Field25519.mult(z2To5Minus1, t0, z9);
        Field25519.square(t0, z2To5Minus1);
        Field25519.square(t1, t0);
        Field25519.square(t0, t1);
        Field25519.square(t1, t0);
        Field25519.square(t0, t1);
        Field25519.mult(z2To10Minus1, t0, z2To5Minus1);
        Field25519.square(t0, z2To10Minus1);
        Field25519.square(t1, t0);
        for (i2 = 2; i2 < 10; i2 += 2) {
            Field25519.square(t0, t1);
            Field25519.square(t1, t0);
        }
        Field25519.mult(z2To20Minus1, t1, z2To10Minus1);
        Field25519.square(t0, z2To20Minus1);
        Field25519.square(t1, t0);
        for (i2 = 2; i2 < 20; i2 += 2) {
            Field25519.square(t0, t1);
            Field25519.square(t1, t0);
        }
        Field25519.mult(t0, t1, z2To20Minus1);
        Field25519.square(t1, t0);
        Field25519.square(t0, t1);
        for (i2 = 2; i2 < 10; i2 += 2) {
            Field25519.square(t1, t0);
            Field25519.square(t0, t1);
        }
        Field25519.mult(z2To50Minus1, t0, z2To10Minus1);
        Field25519.square(t0, z2To50Minus1);
        Field25519.square(t1, t0);
        for (i2 = 2; i2 < 50; i2 += 2) {
            Field25519.square(t0, t1);
            Field25519.square(t1, t0);
        }
        Field25519.mult(z2To100Minus1, t1, z2To50Minus1);
        Field25519.square(t1, z2To100Minus1);
        Field25519.square(t0, t1);
        for (i2 = 2; i2 < 100; i2 += 2) {
            Field25519.square(t1, t0);
            Field25519.square(t0, t1);
        }
        Field25519.mult(t1, t0, z2To100Minus1);
        Field25519.square(t0, t1);
        Field25519.square(t1, t0);
        for (i2 = 2; i2 < 50; i2 += 2) {
            Field25519.square(t0, t1);
            Field25519.square(t1, t0);
        }
        Field25519.mult(t0, t1, z2To50Minus1);
        Field25519.square(t1, t0);
        Field25519.square(t0, t1);
        Field25519.square(t1, t0);
        Field25519.square(t0, t1);
        Field25519.square(t1, t0);
        Field25519.mult(out, t1, z11);
    }

    private static int eq(int a2, int b2) {
        a2 = ~(a2 ^ b2);
        a2 &= a2 << 16;
        a2 &= a2 << 8;
        a2 &= a2 << 4;
        a2 &= a2 << 2;
        a2 &= a2 << 1;
        return a2 >> 31;
    }

    private static int gte(int a2, int b2) {
        return ~((a2 -= b2) >> 31);
    }
}

