/*
 * Decompiled with CFR 0.152.
 */
package com.google.auto.value.extension.serializable.processor;

import autovalue.shaded.com.google;
import autovalue.shaded.com.google$.auto.common.$GeneratedAnnotationSpecs;
import autovalue.shaded.com.google$.auto.common.$MoreTypes;
import autovalue.shaded.com.google$.common.base.$Equivalence;
import autovalue.shaded.com.google$.common.collect.$ImmutableList;
import autovalue.shaded.com.google$.common.collect.$ImmutableMap;
import autovalue.shaded.com.squareup.javapoet$.$AnnotationSpec;
import autovalue.shaded.com.squareup.javapoet$.$ClassName;
import autovalue.shaded.com.squareup.javapoet$.$CodeBlock;
import autovalue.shaded.com.squareup.javapoet$.$FieldSpec;
import autovalue.shaded.com.squareup.javapoet$.$JavaFile;
import autovalue.shaded.com.squareup.javapoet$.$MethodSpec;
import autovalue.shaded.com.squareup.javapoet$.$ParameterizedTypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeName;
import autovalue.shaded.com.squareup.javapoet$.$TypeSpec;
import autovalue.shaded.com.squareup.javapoet$.$TypeVariableName;
import com.google.auto.value.extension.AutoValueExtension;
import com.google.auto.value.extension.serializable.processor.PropertyMirror;
import com.google.auto.value.extension.serializable.serializer.SerializerFactoryLoader;
import com.google.auto.value.extension.serializable.serializer.interfaces.Serializer;
import com.google.auto.value.extension.serializable.serializer.interfaces.SerializerFactory;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

@google..AutoService(value={AutoValueExtension.class})
public final class SerializableAutoValueExtension
extends AutoValueExtension {
    @Override
    public boolean applicable(AutoValueExtension.Context context) {
        return SerializableAutoValueExtension.hasSerializableInterface(context) && SerializableAutoValueExtension.hasSerializableAutoValueAnnotation(context);
    }

    @Override
    public AutoValueExtension.IncrementalExtensionType incrementalType(ProcessingEnvironment processingEnvironment) {
        return AutoValueExtension.IncrementalExtensionType.ISOLATING;
    }

    @Override
    public String generateClass(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
        return new Generator(context, className, classToExtend, isFinal).generate();
    }

    private static boolean hasSerializableInterface(AutoValueExtension.Context context) {
        TypeMirror serializableTypeMirror = context.processingEnvironment().getElementUtils().getTypeElement(Serializable.class.getCanonicalName()).asType();
        return context.processingEnvironment().getTypeUtils().isAssignable(context.autoValueClass().asType(), serializableTypeMirror);
    }

    private static boolean hasSerializableAutoValueAnnotation(AutoValueExtension.Context context) {
        return context.autoValueClass().getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map($MoreTypes::asTypeElement).map(TypeElement::getQualifiedName).anyMatch(name -> name.contentEquals("com.google.auto.value.extension.serializable.SerializableAutoValue"));
    }

    private static final class ProxyGenerator {
        private static final String PROXY_CLASS_NAME = "Proxy$";
        private final $TypeName outerClassTypeName;
        private final $ImmutableList<$TypeVariableName> typeVariableNames;
        private final $ImmutableList<PropertyMirror> propertyMirrors;
        private final $ImmutableMap<$Equivalence.Wrapper<TypeMirror>, Serializer> serializersMap;

        ProxyGenerator($TypeName outerClassTypeName, $ImmutableList<$TypeVariableName> typeVariableNames, $ImmutableList<PropertyMirror> propertyMirrors, $ImmutableMap<$Equivalence.Wrapper<TypeMirror>, Serializer> serializersMap) {
            this.outerClassTypeName = outerClassTypeName;
            this.typeVariableNames = typeVariableNames;
            this.propertyMirrors = propertyMirrors;
            this.serializersMap = serializersMap;
        }

        private $TypeSpec generate() {
            $TypeSpec.Builder proxy = $TypeSpec.classBuilder(PROXY_CLASS_NAME).addModifiers(Modifier.STATIC).addTypeVariables(this.typeVariableNames).addSuperinterface((Type)((Object)Serializable.class)).addField(ProxyGenerator.serialVersionUid()).addFields(this.properties()).addMethod(this.constructor()).addMethod(this.readResolve());
            return proxy.build();
        }

        private static $FieldSpec serialVersionUid() {
            return $FieldSpec.builder(Long.TYPE, "serialVersionUID", Modifier.PRIVATE, Modifier.STATIC, Modifier.FINAL).initializer("0", new Object[0]).build();
        }

        private List<$FieldSpec> properties() {
            return this.propertyMirrors.stream().map(propertyMirror -> $FieldSpec.builder($TypeName.get(this.serializersMap.get($MoreTypes.equivalence().wrap(propertyMirror.getType())).proxyFieldType()), propertyMirror.getName(), Modifier.PRIVATE).build()).collect($ImmutableList.toImmutableList());
        }

        private $MethodSpec constructor() {
            $MethodSpec.Builder constructor = $MethodSpec.constructorBuilder();
            for (PropertyMirror propertyMirror : this.propertyMirrors) {
                Serializer serializer = this.serializersMap.get($MoreTypes.equivalence().wrap(propertyMirror.getType()));
                String name = propertyMirror.getName();
                constructor.addParameter($TypeName.get(propertyMirror.getType()), name, new Modifier[0]);
                constructor.addStatement($CodeBlock.of("this.$L = $L", name, serializer.toProxy($CodeBlock.of(name, new Object[0]))));
            }
            return constructor.build();
        }

        private $MethodSpec readResolve() {
            return $MethodSpec.methodBuilder("readResolve").returns((Type)((Object)Object.class)).addException((Type)((Object)Exception.class)).addStatement("return new $T($L)", this.outerClassTypeName, $CodeBlock.join(this.propertyMirrors.stream().map(this::resolve).collect($ImmutableList.toImmutableList()), ", ")).build();
        }

        private $CodeBlock resolve(PropertyMirror propertyMirror) {
            return this.serializersMap.get($MoreTypes.equivalence().wrap(propertyMirror.getType())).fromProxy($CodeBlock.of(propertyMirror.getName(), new Object[0]));
        }
    }

    private static final class Generator {
        private final AutoValueExtension.Context context;
        private final String className;
        private final String classToExtend;
        private final boolean isFinal;
        private final $ImmutableList<PropertyMirror> propertyMirrors;
        private final $ImmutableList<$TypeVariableName> typeVariableNames;
        private final ProxyGenerator proxyGenerator;

        Generator(AutoValueExtension.Context context, String className, String classToExtend, boolean isFinal) {
            this.context = context;
            this.className = className;
            this.classToExtend = classToExtend;
            this.isFinal = isFinal;
            this.propertyMirrors = context.propertyTypes().entrySet().stream().map(entry -> new PropertyMirror((TypeMirror)entry.getValue(), (String)entry.getKey(), context.properties().get(entry.getKey()).getSimpleName().toString())).collect($ImmutableList.toImmutableList());
            this.typeVariableNames = context.autoValueClass().getTypeParameters().stream().map($TypeVariableName::get).collect($ImmutableList.toImmutableList());
            $TypeName classTypeName = Generator.getClassTypeName($ClassName.get(context.packageName(), className, new String[0]), this.typeVariableNames);
            this.proxyGenerator = new ProxyGenerator(classTypeName, this.typeVariableNames, this.propertyMirrors, this.buildSerializersMap());
        }

        private String generate() {
            $ClassName superclass = $ClassName.get(this.context.packageName(), this.classToExtend, new String[0]);
            Optional<$AnnotationSpec> generatedAnnotationSpec = $GeneratedAnnotationSpecs.generatedAnnotationSpec(this.context.processingEnvironment().getElementUtils(), this.context.processingEnvironment().getSourceVersion(), SerializableAutoValueExtension.class);
            $TypeSpec.Builder subclass = $TypeSpec.classBuilder(this.className).superclass(Generator.getClassTypeName(superclass, this.typeVariableNames)).addTypeVariables(this.typeVariableNames).addModifiers(this.isFinal ? Modifier.FINAL : Modifier.ABSTRACT).addMethod(this.constructor()).addMethod(this.writeReplace()).addType(this.proxyGenerator.generate());
            generatedAnnotationSpec.ifPresent(subclass::addAnnotation);
            return $JavaFile.builder(this.context.packageName(), subclass.build()).build().toString();
        }

        private $MethodSpec constructor() {
            $MethodSpec.Builder constructor = $MethodSpec.constructorBuilder().addStatement("super($L)", this.propertyMirrors.stream().map(PropertyMirror::getName).collect(Collectors.joining(", ")));
            for (PropertyMirror propertyMirror : this.propertyMirrors) {
                constructor.addParameter($TypeName.get(propertyMirror.getType()), propertyMirror.getName(), new Modifier[0]);
            }
            return constructor.build();
        }

        private $MethodSpec writeReplace() {
            $ImmutableList<$CodeBlock> properties = this.propertyMirrors.stream().map(propertyMirror -> $CodeBlock.of("$L()", propertyMirror.getMethod())).collect($ImmutableList.toImmutableList());
            return $MethodSpec.methodBuilder("writeReplace").returns((Type)((Object)Object.class)).addStatement("return new $T($L)", Generator.getClassTypeName($ClassName.get(this.context.packageName(), this.className, "Proxy$"), this.typeVariableNames), $CodeBlock.join(properties, ", ")).build();
        }

        private $ImmutableMap<$Equivalence.Wrapper<TypeMirror>, Serializer> buildSerializersMap() {
            SerializerFactory factory2 = SerializerFactoryLoader.getFactory(this.context.processingEnvironment());
            return this.propertyMirrors.stream().map(PropertyMirror::getType).map($MoreTypes.equivalence()::wrap).distinct().collect($ImmutableMap.toImmutableMap(Function.identity(), equivalence -> factory2.getSerializer((TypeMirror)equivalence.get())));
        }

        private static $TypeName getClassTypeName($ClassName className, List<$TypeVariableName> typeVariableNames) {
            return typeVariableNames.isEmpty() ? className : $ParameterizedTypeName.get(className, typeVariableNames.toArray(new $TypeName[0]));
        }
    }
}

