/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueue;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueColdProducerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueConsumerFields;
import com.github.benmanes.caffeine.cache.BaseMpscLinkedArrayQueueProducerFields;
import com.github.benmanes.caffeine.cache.MpscAccess;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

final class VarHandleMpscAccess
implements MpscAccess {
    static final VarHandle REF_ARRAY;
    static final VarHandle P_INDEX;
    static final VarHandle C_INDEX;
    static final VarHandle P_LIMIT;

    VarHandleMpscAccess() {
    }

    @Override
    public long lvProducerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return P_INDEX.getVolatile(self);
    }

    @Override
    public long lvConsumerIndex(BaseMpscLinkedArrayQueue<?> self) {
        return C_INDEX.getVolatile(self);
    }

    @Override
    public void soProducerIndex(BaseMpscLinkedArrayQueue<?> self, long v2) {
        P_INDEX.setRelease(self, v2);
    }

    @Override
    public boolean casProducerIndex(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return P_INDEX.compareAndSet(self, expect, newValue);
    }

    @Override
    public void soConsumerIndex(BaseMpscLinkedArrayQueue<?> self, long v2) {
        C_INDEX.setRelease(self, v2);
    }

    @Override
    public boolean casProducerLimit(BaseMpscLinkedArrayQueue<?> self, long expect, long newValue) {
        return P_LIMIT.compareAndSet(self, expect, newValue);
    }

    @Override
    public void soProducerLimit(BaseMpscLinkedArrayQueue<?> self, long v2) {
        P_LIMIT.setRelease(self, v2);
    }

    @Override
    public <E> void spElement(E[] buffer, long offset, E e2) {
        REF_ARRAY.set(buffer, (int)offset, e2);
    }

    @Override
    public <E> void soElement(E[] buffer, long offset, E e2) {
        REF_ARRAY.setRelease(buffer, (int)offset, e2);
    }

    @Override
    public <E> E lpElement(E[] buffer, long offset) {
        return (E)REF_ARRAY.get(buffer, (int)offset);
    }

    @Override
    public <E> E lvElement(E[] buffer, long offset) {
        return (E)REF_ARRAY.getVolatile(buffer, (int)offset);
    }

    @Override
    public long calcElementOffset(long index) {
        return index >> 1;
    }

    @Override
    public long modifiedCalcElementOffset(long index, long mask) {
        return (index & mask) >> 1;
    }

    static {
        try {
            MethodHandles.Lookup pIndexLookup = MethodHandles.privateLookupIn(BaseMpscLinkedArrayQueueProducerFields.class, MethodHandles.lookup());
            MethodHandles.Lookup cIndexLookup = MethodHandles.privateLookupIn(BaseMpscLinkedArrayQueueConsumerFields.class, MethodHandles.lookup());
            MethodHandles.Lookup pLimitLookup = MethodHandles.privateLookupIn(BaseMpscLinkedArrayQueueColdProducerFields.class, MethodHandles.lookup());
            P_INDEX = pIndexLookup.findVarHandle(BaseMpscLinkedArrayQueueProducerFields.class, "producerIndex", Long.TYPE);
            C_INDEX = cIndexLookup.findVarHandle(BaseMpscLinkedArrayQueueConsumerFields.class, "consumerIndex", Long.TYPE);
            P_LIMIT = pLimitLookup.findVarHandle(BaseMpscLinkedArrayQueueColdProducerFields.class, "producerLimit", Long.TYPE);
            REF_ARRAY = MethodHandles.arrayElementVarHandle(Object[].class);
        }
        catch (ReflectiveOperationException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }
}

