/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.FS;
import com.github.benmanes.caffeine.cache.Node;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.ref.ReferenceQueue;

class FSR<K, V>
extends FS<K, V> {
    protected static final VarHandle WRITE_TIME;
    volatile long writeTime;

    FSR() {
    }

    FSR(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(key, keyReferenceQueue, value, valueReferenceQueue, weight, now);
        WRITE_TIME.set(this, now);
    }

    FSR(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        super(keyReference, value, valueReferenceQueue, weight, now);
        WRITE_TIME.set(this, now);
    }

    @Override
    public final long getWriteTime() {
        return WRITE_TIME.get(this);
    }

    @Override
    public final void setWriteTime(long writeTime) {
        WRITE_TIME.set(this, writeTime);
    }

    @Override
    public final boolean casWriteTime(long expect, long update) {
        return this.writeTime == expect && WRITE_TIME.compareAndSet(this, expect, update);
    }

    @Override
    public Node<K, V> newNode(K key, ReferenceQueue<K> keyReferenceQueue, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSR<K, V>(key, keyReferenceQueue, value, valueReferenceQueue, weight, now);
    }

    @Override
    public Node<K, V> newNode(Object keyReference, V value, ReferenceQueue<V> valueReferenceQueue, int weight, long now) {
        return new FSR<K, V>(keyReference, value, valueReferenceQueue, weight, now);
    }

    static {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            WRITE_TIME = lookup.findVarHandle(FSR.class, "writeTime", Long.TYPE);
        }
        catch (ReflectiveOperationException e2) {
            throw new ExceptionInInitializerError(e2);
        }
    }
}

