/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.YearMonth;

public class YearMonthDeserializer
extends JodaDateDeserializerBase<YearMonth> {
    private static final long serialVersionUID = 1L;

    public YearMonthDeserializer() {
        this(FormatConfig.DEFAULT_YEAR_MONTH_FORMAT);
    }

    public YearMonthDeserializer(JacksonJodaDateFormat format) {
        super(YearMonth.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new YearMonthDeserializer(format);
    }

    @Override
    public YearMonth deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p2, ctxt, p2.getText());
        }
        if (p2.isExpectedStartObjectToken()) {
            return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, this, this.handledType()));
        }
        return (YearMonth)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected JSON String", new Object[0]);
    }

    protected YearMonth _fromString(JsonParser p2, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (YearMonth)this._fromEmptyString(p2, ctxt, value);
        }
        return YearMonth.parse(value, this._format.createParser(ctxt));
    }
}

