/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import java.io.IOException;
import org.joda.time.MonthDay;

public class MonthDayDeserializer
extends JodaDateDeserializerBase<MonthDay> {
    private static final long serialVersionUID = 1L;

    public MonthDayDeserializer() {
        this(FormatConfig.DEFAULT_MONTH_DAY_FORMAT);
    }

    public MonthDayDeserializer(JacksonJodaDateFormat format) {
        super(MonthDay.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new MonthDayDeserializer(format);
    }

    @Override
    public MonthDay deserialize(JsonParser p2, DeserializationContext ctxt) throws IOException {
        if (p2.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p2, ctxt, p2.getText());
        }
        if (p2.isExpectedStartObjectToken()) {
            return this._fromString(p2, ctxt, ctxt.extractScalarFromObject(p2, this, this.handledType()));
        }
        return (MonthDay)ctxt.handleUnexpectedToken(this.handledType(), p2.currentToken(), p2, "expected JSON String", new Object[0]);
    }

    protected MonthDay _fromString(JsonParser p2, DeserializationContext ctxt, String value) throws IOException {
        if ((value = value.trim()).isEmpty()) {
            return (MonthDay)this._fromEmptyString(p2, ctxt, value);
        }
        return MonthDay.parse(value, this._format.createParser(ctxt));
    }
}

