/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext;

import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.ConfigurationProperty;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.logging.Logger;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlPlusRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private String spoolFilePath = null;
    private Boolean keepTempFile;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private String errorLoggingIdentifier;

    public SqlPlusRunner() {
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlArray, ResourceAccessor resourceAccessor) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setResourceAccessor(resourceAccessor);
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadSqlplusProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings((Database)object);
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = Boolean.FALSE;
        }
        if (!this.keepTempFile.booleanValue() && this.outFile != null) {
            this.outFile.deleteOnExit();
        }
        if (!list.contains("-L")) {
            list.add("-L");
        }
        list.add(this.buildConnectionString((Database)object));
        if (this.outFile != null) {
            list.add("@" + this.outFile.getAbsolutePath());
        }
        object = StringUtil.join(list, " ").replaceAll("(.*) (.*)/\"(.*)\"@(.)", "$1 $2/******@$4");
        Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS command:\n".concat(String.valueOf(object)));
        return list;
    }

    @Override
    protected void processResult(int n2, String string3, String string2, Database database) {
        try {
            List<?> list = this.processResultFromDaticalSpErrorLog(n2, database);
            StringBuilder stringBuilder = new StringBuilder();
            if (list == null || list.isEmpty()) {
                super.processResult(n2, string3, string2, database);
                return;
            }
            stringBuilder.append("Error executing change set '");
            stringBuilder.append(this.changeSet.toString());
            stringBuilder.append("'\n");
            for (String string3 : list) {
                stringBuilder.append(string3.toString().concat("\n"));
            }
            throw new DaticalSpErrorLogException(stringBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    @Override
    public void executeCommand(Database database) {
        this.createDaticalSpErrorLogIfNeeded(database);
        this.finalCommandArray = this.createFinalCommandArray(database);
        try {
            super.executeCommand(database);
            if (this.spoolFilePath != null) {
                this.captureSpoolOutputInLog();
            }
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                return;
            }
        }
        catch (Exception exception) {
            try {
                Exception exception2 = exception;
                if (exception instanceof TimeoutException) {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                    this.processResult(0, null, null, database);
                }
                throw new Exception(exception2);
            }
            catch (Throwable throwable) {
                if (this.spoolFilePath != null) {
                    this.captureSpoolOutputInLog();
                }
                if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
                }
                throw throwable;
            }
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        String string = database.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase(database);
        try {
            jdbcExecutor.execute(new RawSqlStatement(String.format("DROP TABLE %s.%s", string, DATICAL_SPERRORLOG)));
            return;
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to drop table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the DROP TABLE privilege. ", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    private List<?> processResultFromDaticalSpErrorLog(int n2, Database object) {
        block2: {
            String string = object.getLiquibaseCatalogName();
            JdbcExecutor jdbcExecutor = new JdbcExecutor();
            jdbcExecutor.setDatabase((Database)object);
            object = null;
            try {
                string = String.format("select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='" + this.errorLoggingIdentifier + "'", string, DATICAL_SPERRORLOG);
                object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement(string), String.class);
            }
            catch (DatabaseException databaseException) {
                if (n2 != 0) break block2;
                throw new DaticalSpErrorLogException(String.format("Table: %s unacceptable due to an error. ", DATICAL_SPERRORLOG), databaseException);
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void loadSqlplusProperties() {
        block40: {
            block38: {
                block39: {
                    if (StringUtil.trimToEmpty(System.getProperties().getProperty("os.name")).toLowerCase().startsWith("windows")) {
                        this.setExecutable("sqlplus.exe");
                    } else {
                        this.setExecutable("sqlplus");
                    }
                    var1_1 = null;
                    var2_4 = null;
                    var3_6 = new Properties();
                    var4_7 = this.getLiquibaseProperty("liquibase.sqlplus.path");
                    if (var4_7 != null && (var4_7 = var4_7.getValue(String.class)) != null && !var4_7.isEmpty()) {
                        var1_1 = new File((String)var4_7);
                    }
                    if ((var4_7 = this.getLiquibaseProperty("liquibase.sqlplus.timeout")) != null) {
                        var2_4 = var4_7.getValue(String.class);
                    }
                    if ((var4_7 = this.getLiquibaseProperty("liquibase.sqlplus.temp.keep")) != null) {
                        this.keepTempFile = var4_7.getValue(Boolean.class);
                    }
                    var4_7 = Scope.getCurrentScope().getResourceAccessor();
                    var5_10 = null;
                    var4_7 = var4_7.openStreams(null, "liquibase.sqlplus.conf");
                    var6_11 = null;
                    if (var4_7 != null && var4_7.size() != 0) break block38;
                    Scope.getCurrentScope().getLog(this.getClass()).warning("No configuration file named 'liquibase.sqlplus.conf' found.  Using default values.  Learn more at http://docs.liquibase.com.");
                    if (var4_7 == null) break block39;
                    var4_7.close();
                }
                return;
            }
            try {
                var5_10 = var4_7.iterator().next();
                var3_6.load(var5_10);
                if (var1_1 == null && var3_6.containsKey("liquibase.sqlplus.path")) {
                    var1_1 = new File(var3_6.getProperty("liquibase.sqlplus.path"));
                }
                if (var2_4 == null && var3_6.containsKey("liquibase.sqlplus.timeout")) {
                    var2_4 = var3_6.getProperty("liquibase.sqlplus.timeout");
                    try {
                        Integer.parseInt(var2_4);
                    }
                    catch (Exception v0) {
                        throw new UnexpectedLiquibaseException("Invalid value '" + var2_4 + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
                    }
                }
                if (this.keepTempFile == null && var3_6.containsKey("liquibase.sqlplus.keep.temp")) {
                    if (!((var3_6 = var3_6.getProperty("liquibase.sqlplus.keep.temp")) == null || var3_6.isEmpty() || (var3_6 = var3_6.toLowerCase()).equals("true") || var3_6.equals("false"))) {
                        throw new UnexpectedLiquibaseException("Invalid value '" + (String)var3_6 + "' for property 'liquibase.sqlplus.keep.temp'. Must be 'true' or 'false'.  Learn more at https://docs.liquibase.com");
                    }
                    this.keepTempFile = Boolean.valueOf((String)var3_6);
                }
                ** if (var4_7 == null) goto lbl-1000
            }
            catch (Throwable v1) {
                try {
                    var3_6 = v1;
                    var6_11 = v1;
                    throw var3_6;
                }
                catch (Throwable var1_2) {
                    if (var4_7 != null) {
                        if (var6_11 != null) {
                            try {
                                var4_7.close();
                            }
                            catch (Throwable var2_5) {
                                var6_11.addSuppressed(var2_5);
                            }
                        } else {
                            var4_7.close();
                        }
                    }
                    throw var1_2;
                }
            }
lbl-1000:
            // 1 sources

            {
                var4_7.close();
            }
lbl-1000:
            // 2 sources

            {
            }
            try {
                if (var5_10 != null) {
                    var5_10.close();
                }
                break block40;
            }
            catch (Exception v2) {}
            break block40;
            catch (IOException var4_8) {
                try {
                    throw new UnexpectedLiquibaseException(var4_8);
                }
                catch (Throwable var1_3) {
                    try {
                        if (var5_10 != null) {
                            var5_10.close();
                        }
                    }
                    catch (Exception v3) {}
                    throw var1_3;
                }
            }
        }
        if (var1_1 != null) {
            if (!var1_1.exists()) {
                throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + var1_1.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
            }
            if (!var1_1.canExecute()) {
                throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + var1_1.getAbsolutePath() + " cannot be executed");
            }
            try {
                this.setExecutable(var1_1.getCanonicalPath());
                Scope.getCurrentScope().getLog(this.getClass()).info("Using the 'sqlplus' executable located at:  '" + var1_1.getCanonicalPath() + "'");
            }
            catch (IOException var4_9) {
                throw new UnexpectedLiquibaseException(var4_9);
            }
        }
        if (var2_4 != null) {
            this.validateTimeout(var2_4);
            this.setTimeout(var2_4);
        }
    }

    private ConfigurationProperty getLiquibaseProperty(String string) {
        LiquibaseProConfiguration liquibaseProConfiguration = LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class);
        ConfigurationProperty configurationProperty = null;
        try {
            configurationProperty = liquibaseProConfiguration.getProperty(string);
        }
        catch (Exception exception) {}
        return configurationProperty;
    }

    private void validateTimeout(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        if ((string = string.trim()).equals("-1")) {
            return;
        }
        if (string.equals("0")) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of 0");
        }
        try {
            if (Integer.parseInt(string) <= 0) {
                throw new UnexpectedLiquibaseException("Invalid timeout value of '" + string + "'");
            }
            return;
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid timeout value of '" + string + "'");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeSqlStrings(Database object) {
        String string;
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.info("Creating the SQL run script");
        try {
            string = ("liquibase-spool-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-").replaceAll(" ", "_").replaceAll(":", "_");
            logger.info("Creating temporary spool file for '" + string + "'");
            File file = File.createTempFile(string, ".spool");
            file.deleteOnExit();
            this.spoolFilePath = file.getAbsolutePath();
            this.spoolFilePath = this.spoolFilePath.replaceAll("\\s", "");
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        try {
            string = ("liquibase-sqlplus-" + this.changeSet.getId() + "-" + this.changeSet.getAuthor() + "-").replaceAll(" ", "_").replaceAll(":", "_");
            logger.info("Creating temporary file for '" + string + "'");
            this.outFile = File.createTempFile(string, ".sql");
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
        boolean bl2 = true;
        Sql[] sqlArray = this.sqlStrings;
        int n2 = this.sqlStrings.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!sqlArray[i2].toSql().toLowerCase().startsWith("whenever")) continue;
            bl2 = false;
            break;
        }
        String string2 = object.getLiquibaseCatalogName();
        BufferedWriter bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
        Throwable throwable = null;
        try {
            bufferedWriter.write("SET ECHO ON\n");
            bufferedWriter.write("SET DEFINE OFF\n");
            bufferedWriter.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' \n", string2, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
            if (bl2) {
                bufferedWriter.write("WHENEVER SQLERROR EXIT FAILURE;\n");
            }
            bufferedWriter.write("SPOOL " + this.spoolFilePath + "\n");
            bufferedWriter.write("SET SQLBLANKLINES ON\n\n");
            boolean bl3 = false;
            Sql[] sqlArray2 = this.sqlStrings;
            int n3 = this.sqlStrings.length;
            for (n2 = 0; n2 < n3; ++n2) {
                for (String string3 : sqlArray2[n2].toSql().split("\n")) {
                    if (bl3 || !string3.toLowerCase().contains("spool ")) continue;
                    logger.warning("SPOOL statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
                    bl3 = true;
                }
            }
            sqlArray2 = this.sqlStrings;
            int n4 = this.sqlStrings.length;
            for (n2 = 0; n2 < n4; ++n2) {
                String string4 = sqlArray2[n2].toSql().replace("\r", "");
                bufferedWriter.write(string4 + "\n");
            }
            bufferedWriter.write("EXIT;\n");
            if (bufferedWriter == null) return;
        }
        catch (Throwable throwable2) {
            try {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            catch (Throwable throwable3) {
                if (bufferedWriter == null) throw throwable3;
                if (throwable != null) {
                    try {
                        bufferedWriter.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable3;
                } else {
                    bufferedWriter.close();
                }
                throw throwable3;
            }
        }
        bufferedWriter.close();
        return;
    }

    private void createDaticalSpErrorLogIfNeeded(Database object) {
        String string = object.getLiquibaseCatalogName();
        JdbcExecutor jdbcExecutor = new JdbcExecutor();
        jdbcExecutor.setDatabase((Database)object);
        try {
            object = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", string, DATICAL_SPERRORLOG);
            object = jdbcExecutor.queryForList((SqlStatement)new RawSqlStatement((String)object), String.class);
        }
        catch (DatabaseException databaseException) {
            throw new DaticalSpErrorLogException(String.format("Can't check if  table: %s exist due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (object != null && !object.isEmpty()) {
            try {
                jdbcExecutor.execute(new RawSqlStatement(String.format("DELETE FROM %s.%s", string, DATICAL_SPERRORLOG)));
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to clear rows from table: %s.%s due to an error. Table is locked or the user has insufficient privileges", string, DATICAL_SPERRORLOG));
            }
        }
        try {
            object = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", string, DATICAL_SPERRORLOG);
            jdbcExecutor.execute(new RawSqlStatement((String)object));
            return;
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(String.format("Unable to create table: %s.%s due to an error. Table already exists", string, DATICAL_SPERRORLOG));
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void captureSpoolOutputInLog() {
        Object object;
        block9: {
            object = Scope.getCurrentScope().getLog(this.getClass());
            if (!new File(this.spoolFilePath).exists()) {
                object.warning("Unable to locate spool output file " + this.spoolFilePath);
                return;
            }
            object.info("Writing spool output to log");
            BufferedReader bufferedReader = Files.newBufferedReader(Paths.get(this.spoolFilePath, new String[0]));
            Throwable throwable = null;
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    object.info(string);
                }
                if (bufferedReader == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (bufferedReader == null) throw throwable3;
                    if (throwable == null) {
                        bufferedReader.close();
                        throw throwable3;
                    }
                    try {
                        bufferedReader.close();
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        throwable.addSuppressed(throwable4);
                        throw throwable3;
                    }
                }
            }
            bufferedReader.close();
        }
        object.info("\n");
        object.info("Spool output written to log");
    }

    private String buildConnectionString(Database object) {
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = object.getConnectionUserName();
        String string2 = ((ProJdbcConnection)object).getPassword();
        if (string2 == null) {
            throw new UnexpectedLiquibaseException("Password for sqlplus was not set by the calling program, or could not determine password from connection.");
        }
        object = object.getURL().split("jdbc:oracle:(.*):@")[1];
        return string + "/\"" + string2 + "\"@" + (String)object;
    }
}

