/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public enum Severity {
    EMERGENCY(0, "EMERGENCY"),
    ALERT(1, "ALERT"),
    CRITICAL(2, "CRITICAL"),
    ERROR(3, "ERROR"),
    WARNING(4, "WARNING"),
    NOTICE(5, "NOTICE"),
    INFORMATIONAL(6, "INFORMATIONAL"),
    DEBUG(7, "DEBUG");

    private static final Map<String, Severity> severityFromLabel;
    private static final Map<Integer, Severity> severityFromNumericalCode;
    private final int numericalCode;
    @Nonnull
    private final String label;

    private Severity(int numericalCode, String label) {
        this.numericalCode = numericalCode;
        this.label = label;
    }

    public static Severity fromNumericalCode(int numericalCode) throws IllegalArgumentException {
        Severity severity = severityFromNumericalCode.get(numericalCode);
        if (severity == null) {
            throw new IllegalArgumentException("Invalid severity '" + numericalCode + "'");
        }
        return severity;
    }

    @Nullable
    public static Severity fromLabel(@Nullable String label) throws IllegalArgumentException {
        if (label == null || label.isEmpty()) {
            return null;
        }
        Severity severity = severityFromLabel.get(label);
        if (severity == null) {
            throw new IllegalArgumentException("Invalid severity '" + label + "'");
        }
        return severity;
    }

    public int numericalCode() {
        return this.numericalCode;
    }

    @Nonnull
    public String label() {
        return this.label;
    }

    public static Comparator<Severity> comparator() {
        return new Comparator<Severity>(){

            @Override
            public int compare(Severity s1, Severity s2) {
                return Integer.compare(s1.numericalCode, s2.numericalCode);
            }
        };
    }

    static {
        severityFromLabel = new HashMap<String, Severity>();
        severityFromNumericalCode = new HashMap<Integer, Severity>();
        for (Severity severity : Severity.values()) {
            severityFromLabel.put(severity.label, severity);
            severityFromNumericalCode.put(severity.numericalCode, severity);
        }
    }
}

