/*
 * Decompiled with CFR 0.152.
 */
package autovalue.shaded.com.google$.common.base;

import autovalue.shaded.com.google$.common.annotations.$GwtCompatible;
import autovalue.shaded.com.google$.common.base.$Function;
import autovalue.shaded.com.google$.common.base.$FunctionalEquivalence;
import autovalue.shaded.com.google$.common.base.$Objects;
import autovalue.shaded.com.google$.common.base.$PairwiseEquivalence;
import autovalue.shaded.com.google$.common.base.$Preconditions;
import autovalue.shaded.com.google$.common.base.$Predicate;
import autovalue.shaded.com.google$.errorprone.annotations.$ForOverride;
import autovalue.shaded.org.checkerframework;
import java.io.Serializable;
import java.util.function.BiPredicate;

@$GwtCompatible
public abstract class $Equivalence<T>
implements BiPredicate<T, T> {
    protected $Equivalence() {
    }

    public final boolean equivalent(@checkerframework..Nullable T a2, @checkerframework..Nullable T b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        return this.doEquivalent(a2, b2);
    }

    @Override
    @Deprecated
    public final boolean test(@checkerframework..Nullable T t2, @checkerframework..Nullable T u2) {
        return this.equivalent(t2, u2);
    }

    @$ForOverride
    protected abstract boolean doEquivalent(T var1, T var2);

    public final int hash(@checkerframework..Nullable T t2) {
        if (t2 == null) {
            return 0;
        }
        return this.doHash(t2);
    }

    @$ForOverride
    protected abstract int doHash(T var1);

    public final <F> $Equivalence<F> onResultOf($Function<F, ? extends T> function) {
        return new $FunctionalEquivalence<F, T>(function, this);
    }

    public final <S extends T> Wrapper<S> wrap(@checkerframework..Nullable S reference) {
        return new Wrapper(this, reference);
    }

    @$GwtCompatible(serializable=true)
    public final <S extends T> $Equivalence<Iterable<S>> pairwise() {
        return new $PairwiseEquivalence(this);
    }

    public final $Predicate<T> equivalentTo(@checkerframework..Nullable T target) {
        return new EquivalentToPredicate<T>(this, target);
    }

    public static $Equivalence<Object> equals() {
        return Equals.INSTANCE;
    }

    public static $Equivalence<Object> identity() {
        return Identity.INSTANCE;
    }

    static final class Identity
    extends $Equivalence<Object>
    implements Serializable {
        static final Identity INSTANCE = new Identity();
        private static final long serialVersionUID = 1L;

        Identity() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return false;
        }

        @Override
        protected int doHash(Object o2) {
            return System.identityHashCode(o2);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    static final class Equals
    extends $Equivalence<Object>
    implements Serializable {
        static final Equals INSTANCE = new Equals();
        private static final long serialVersionUID = 1L;

        Equals() {
        }

        @Override
        protected boolean doEquivalent(Object a2, Object b2) {
            return a2.equals(b2);
        }

        @Override
        protected int doHash(Object o2) {
            return o2.hashCode();
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    private static final class EquivalentToPredicate<T>
    implements $Predicate<T>,
    Serializable {
        private final $Equivalence<T> equivalence;
        private final @checkerframework..Nullable T target;
        private static final long serialVersionUID = 0L;

        EquivalentToPredicate($Equivalence<T> equivalence, @checkerframework..Nullable T target) {
            this.equivalence = $Preconditions.checkNotNull(equivalence);
            this.target = target;
        }

        @Override
        public boolean apply(@checkerframework..Nullable T input) {
            return this.equivalence.equivalent(input, this.target);
        }

        @Override
        public boolean equals(@checkerframework..Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof EquivalentToPredicate) {
                EquivalentToPredicate that = (EquivalentToPredicate)obj;
                return this.equivalence.equals(that.equivalence) && $Objects.equal(this.target, that.target);
            }
            return false;
        }

        public int hashCode() {
            return $Objects.hashCode(this.equivalence, this.target);
        }

        public String toString() {
            String string = String.valueOf(this.equivalence);
            String string2 = String.valueOf(this.target);
            return new StringBuilder(15 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".equivalentTo(").append(string2).append(")").toString();
        }
    }

    public static final class Wrapper<T>
    implements Serializable {
        private final $Equivalence<? super T> equivalence;
        private final @checkerframework..Nullable T reference;
        private static final long serialVersionUID = 0L;

        private Wrapper($Equivalence<? super T> equivalence, @checkerframework..Nullable T reference) {
            this.equivalence = $Preconditions.checkNotNull(equivalence);
            this.reference = reference;
        }

        public @checkerframework..Nullable T get() {
            return this.reference;
        }

        public boolean equals(@checkerframework..Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof Wrapper) {
                Wrapper that = (Wrapper)obj;
                if (this.equivalence.equals(that.equivalence)) {
                    $Equivalence<T> equivalence = this.equivalence;
                    return equivalence.equivalent(this.reference, that.reference);
                }
            }
            return false;
        }

        public int hashCode() {
            return this.equivalence.hash(this.reference);
        }

        public String toString() {
            String string = String.valueOf(this.equivalence);
            String string2 = String.valueOf(this.reference);
            return new StringBuilder(7 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".wrap(").append(string2).append(")").toString();
        }
    }
}

