/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.runtime.slotted;

import java.io.Serializable;
import java.util.Comparator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import org.neo4j.cypher.internal.physicalplanning.LongSlot;
import org.neo4j.cypher.internal.physicalplanning.RefSlot;
import org.neo4j.cypher.internal.physicalplanning.Slot;
import org.neo4j.cypher.internal.runtime.ReadableRow;
import org.neo4j.cypher.internal.runtime.slotted.ColumnOrder;
import org.neo4j.cypher.internal.runtime.slotted.ColumnOrder2;
import org.neo4j.cypher.internal.util.symbols.CypherType;
import org.neo4j.cypher.internal.util.symbols.NodeType;
import org.neo4j.cypher.internal.util.symbols.RelationshipType;
import org.neo4j.cypher.internal.util.symbols.package$;
import org.neo4j.exceptions.CantCompileQueryException;
import org.neo4j.values.AnyValue;
import org.neo4j.values.virtual.NodeIdReference;
import org.neo4j.values.virtual.RelationshipReference;
import org.neo4j.values.virtual.VirtualNodeValue;
import org.neo4j.values.virtual.VirtualRelationshipValue;
import org.neo4j.values.virtual.VirtualValues;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.IntRef;

public final class SlottedExecutionContextOrdering$ {
    public static final SlottedExecutionContextOrdering$ MODULE$ = new SlottedExecutionContextOrdering$();

    public Comparator<ReadableRow> comparator(ColumnOrder order) {
        boolean bl = false;
        LongSlot longSlot = null;
        Slot slot = order.slot();
        if (slot instanceof LongSlot) {
            bl = true;
            longSlot = (LongSlot)slot;
            int offset = longSlot.offset();
            boolean bl2 = longSlot.nullable();
            if (bl2) {
                return new Comparator<ReadableRow>(offset, order){
                    private final int offset$1;
                    private final ColumnOrder order$1;

                    public Comparator<ReadableRow> reversed() {
                        return Comparator.super.reversed();
                    }

                    public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparing(x$1);
                    }

                    public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                        return Comparator.super.thenComparing(x$1, x$2);
                    }

                    public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                        return Comparator.super.thenComparing(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingInt(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingLong(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingDouble(x$1);
                    }

                    public int compare(ReadableRow a, ReadableRow b) {
                        long aVal = a.getLongAt(this.offset$1);
                        long bVal = b.getLongAt(this.offset$1);
                        return this.order$1.compareNullableLongs(aVal, bVal);
                    }
                    {
                        this.offset$1 = offset$1;
                        this.order$1 = order$1;
                    }
                };
            }
        }
        if (bl) {
            int offset = longSlot.offset();
            boolean bl3 = longSlot.nullable();
            if (!bl3) {
                return new Comparator<ReadableRow>(offset, order){
                    private final int offset$2;
                    private final ColumnOrder order$1;

                    public Comparator<ReadableRow> reversed() {
                        return Comparator.super.reversed();
                    }

                    public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparing(x$1);
                    }

                    public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                        return Comparator.super.thenComparing(x$1, x$2);
                    }

                    public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                        return Comparator.super.thenComparing(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingInt(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingLong(x$1);
                    }

                    public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                        return Comparator.super.thenComparingDouble(x$1);
                    }

                    public int compare(ReadableRow a, ReadableRow b) {
                        long aVal = a.getLongAt(this.offset$2);
                        long bVal = b.getLongAt(this.offset$2);
                        return this.order$1.compareLongs(aVal, bVal);
                    }
                    {
                        this.offset$2 = offset$2;
                        this.order$1 = order$1;
                    }
                };
            }
        }
        if (slot instanceof RefSlot) {
            RefSlot refSlot = (RefSlot)slot;
            int offset = refSlot.offset();
            return new Comparator<ReadableRow>(offset, order){
                private final int offset$3;
                private final ColumnOrder order$1;

                public Comparator<ReadableRow> reversed() {
                    return Comparator.super.reversed();
                }

                public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                    return Comparator.super.thenComparing(x$1, x$2);
                }

                public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                    return Comparator.super.thenComparing(x$1);
                }

                public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                    return Comparator.super.thenComparingInt(x$1);
                }

                public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                    return Comparator.super.thenComparingLong(x$1);
                }

                public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                    return Comparator.super.thenComparingDouble(x$1);
                }

                public int compare(ReadableRow a, ReadableRow b) {
                    AnyValue aVal = a.getRefAt(this.offset$3);
                    AnyValue bVal = b.getRefAt(this.offset$3);
                    return this.order$1.compareValues(aVal, bVal);
                }
                {
                    this.offset$3 = offset$3;
                    this.order$1 = order$1;
                }
            };
        }
        throw new MatchError((Object)slot);
    }

    public Comparator<ReadableRow> comparator2(ColumnOrder2 order) {
        Tuple2 tuple2 = new Tuple2((Object)order.slot(), (Object)order.rhsSlot());
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot2 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                boolean bl = longSlot.nullable();
                if (!bl && slot2 instanceof LongSlot) {
                    LongSlot longSlot2 = (LongSlot)slot2;
                    int offsetB = longSlot2.offset();
                    boolean bl2 = longSlot2.nullable();
                    if (!bl2) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$1;
                            private final int offsetB$1;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                long aVal = a.getLongAt(this.offsetA$1);
                                long bVal = b.getLongAt(this.offsetB$1);
                                return this.order$2.compareLongs(aVal, bVal);
                            }
                            {
                                this.offsetA$1 = offsetA$1;
                                this.offsetB$1 = offsetB$1;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot3 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                if (slot3 instanceof LongSlot) {
                    LongSlot longSlot3 = (LongSlot)slot3;
                    int offsetB = longSlot3.offset();
                    return new Comparator<ReadableRow>(offsetA, offsetB, order){
                        private final int offsetA$2;
                        private final int offsetB$2;
                        private final ColumnOrder2 order$2;

                        public Comparator<ReadableRow> reversed() {
                            return Comparator.super.reversed();
                        }

                        public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                            return Comparator.super.thenComparing(x$1, x$2);
                        }

                        public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingInt(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingLong(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingDouble(x$1);
                        }

                        public int compare(ReadableRow a, ReadableRow b) {
                            long aVal = a.getLongAt(this.offsetA$2);
                            long bVal = b.getLongAt(this.offsetB$2);
                            return this.order$2.compareNullableLongs(aVal, bVal);
                        }
                        {
                            this.offsetA$2 = offsetA$2;
                            this.offsetB$2 = offsetB$2;
                            this.order$2 = order$2;
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot4 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                CypherType cypherType = longSlot.typ();
                NodeType nodeType = package$.MODULE$.CTNode();
                CypherType cypherType2 = cypherType;
                if (!(nodeType != null ? !nodeType.equals(cypherType2) : cypherType2 != null) && slot4 instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot4;
                    int offsetB = refSlot.offset();
                    CypherType cypherType3 = refSlot.typ();
                    NodeType nodeType2 = package$.MODULE$.CTNode();
                    CypherType cypherType4 = cypherType3;
                    if (!(nodeType2 != null ? !nodeType2.equals(cypherType4) : cypherType4 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$3;
                            private final int offsetB$3;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                long aVal = a.getLongAt(this.offsetA$3);
                                long bVal = ((VirtualNodeValue)b.getRefAt(this.offsetB$3)).id();
                                return this.order$2.compareNullableLongs(aVal, bVal);
                            }
                            {
                                this.offsetA$3 = offsetA$3;
                                this.offsetB$3 = offsetB$3;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot5 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                CypherType cypherType = longSlot.typ();
                RelationshipType relationshipType = package$.MODULE$.CTRelationship();
                CypherType cypherType5 = cypherType;
                if (!(relationshipType != null ? !relationshipType.equals(cypherType5) : cypherType5 != null) && slot5 instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot5;
                    int offsetB = refSlot.offset();
                    CypherType cypherType6 = refSlot.typ();
                    RelationshipType relationshipType2 = package$.MODULE$.CTRelationship();
                    CypherType cypherType7 = cypherType6;
                    if (!(relationshipType2 != null ? !relationshipType2.equals(cypherType7) : cypherType7 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$4;
                            private final int offsetB$4;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                long aVal = a.getLongAt(this.offsetA$4);
                                long bVal = ((VirtualRelationshipValue)b.getRefAt(this.offsetB$4)).id();
                                return this.order$2.compareNullableLongs(aVal, bVal);
                            }
                            {
                                this.offsetA$4 = offsetA$4;
                                this.offsetB$4 = offsetB$4;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot6 = (Slot)tuple2._2();
            if (slot instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot;
                int offsetA = refSlot.offset();
                CypherType cypherType = refSlot.typ();
                NodeType nodeType = package$.MODULE$.CTNode();
                CypherType cypherType8 = cypherType;
                if (!(nodeType != null ? !nodeType.equals(cypherType8) : cypherType8 != null) && slot6 instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot6;
                    int offsetB = longSlot.offset();
                    CypherType cypherType9 = longSlot.typ();
                    NodeType nodeType3 = package$.MODULE$.CTNode();
                    CypherType cypherType10 = cypherType9;
                    if (!(nodeType3 != null ? !nodeType3.equals(cypherType10) : cypherType10 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$5;
                            private final int offsetB$5;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                long aVal = ((VirtualNodeValue)a.getRefAt(this.offsetA$5)).id();
                                long bVal = b.getLongAt(this.offsetB$5);
                                return this.order$2.compareNullableLongs(aVal, bVal);
                            }
                            {
                                this.offsetA$5 = offsetA$5;
                                this.offsetB$5 = offsetB$5;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot7 = (Slot)tuple2._2();
            if (slot instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot;
                int offsetA = refSlot.offset();
                CypherType cypherType = refSlot.typ();
                RelationshipType relationshipType = package$.MODULE$.CTRelationship();
                CypherType cypherType11 = cypherType;
                if (!(relationshipType != null ? !relationshipType.equals(cypherType11) : cypherType11 != null) && slot7 instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot7;
                    int offsetB = longSlot.offset();
                    CypherType cypherType12 = longSlot.typ();
                    RelationshipType relationshipType3 = package$.MODULE$.CTRelationship();
                    CypherType cypherType13 = cypherType12;
                    if (!(relationshipType3 != null ? !relationshipType3.equals(cypherType13) : cypherType13 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$6;
                            private final int offsetB$6;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                long aVal = ((VirtualRelationshipValue)a.getRefAt(this.offsetA$6)).id();
                                long bVal = b.getLongAt(this.offsetB$6);
                                return this.order$2.compareNullableLongs(aVal, bVal);
                            }
                            {
                                this.offsetA$6 = offsetA$6;
                                this.offsetB$6 = offsetB$6;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot8 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                CypherType cypherType = longSlot.typ();
                NodeType nodeType = package$.MODULE$.CTNode();
                CypherType cypherType14 = cypherType;
                if (!(nodeType != null ? !nodeType.equals(cypherType14) : cypherType14 != null) && slot8 instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot8;
                    int offsetB = refSlot.offset();
                    return new Comparator<ReadableRow>(offsetA, offsetB, order){
                        private final int offsetA$7;
                        private final int offsetB$7;
                        private final ColumnOrder2 order$2;

                        public Comparator<ReadableRow> reversed() {
                            return Comparator.super.reversed();
                        }

                        public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                            return Comparator.super.thenComparing(x$1, x$2);
                        }

                        public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingInt(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingLong(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingDouble(x$1);
                        }

                        public int compare(ReadableRow a, ReadableRow b) {
                            NodeIdReference aVal = VirtualValues.node((long)a.getLongAt(this.offsetA$7));
                            AnyValue bVal = b.getRefAt(this.offsetB$7);
                            return this.order$2.compareValues((AnyValue)aVal, bVal);
                        }
                        {
                            this.offsetA$7 = offsetA$7;
                            this.offsetB$7 = offsetB$7;
                            this.order$2 = order$2;
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot9 = (Slot)tuple2._2();
            if (slot instanceof LongSlot) {
                LongSlot longSlot = (LongSlot)slot;
                int offsetA = longSlot.offset();
                CypherType cypherType = longSlot.typ();
                RelationshipType relationshipType = package$.MODULE$.CTRelationship();
                CypherType cypherType15 = cypherType;
                if (!(relationshipType != null ? !relationshipType.equals(cypherType15) : cypherType15 != null) && slot9 instanceof RefSlot) {
                    RefSlot refSlot = (RefSlot)slot9;
                    int offsetB = refSlot.offset();
                    return new Comparator<ReadableRow>(offsetA, offsetB, order){
                        private final int offsetA$8;
                        private final int offsetB$8;
                        private final ColumnOrder2 order$2;

                        public Comparator<ReadableRow> reversed() {
                            return Comparator.super.reversed();
                        }

                        public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                            return Comparator.super.thenComparing(x$1, x$2);
                        }

                        public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingInt(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingLong(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingDouble(x$1);
                        }

                        public int compare(ReadableRow a, ReadableRow b) {
                            RelationshipReference aVal = VirtualValues.relationship((long)a.getLongAt(this.offsetA$8));
                            AnyValue bVal = b.getRefAt(this.offsetB$8);
                            return this.order$2.compareValues((AnyValue)aVal, bVal);
                        }
                        {
                            this.offsetA$8 = offsetA$8;
                            this.offsetB$8 = offsetB$8;
                            this.order$2 = order$2;
                        }
                    };
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot10 = (Slot)tuple2._2();
            if (slot instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot;
                int offsetA = refSlot.offset();
                if (slot10 instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot10;
                    int offsetB = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    NodeType nodeType = package$.MODULE$.CTNode();
                    CypherType cypherType16 = cypherType;
                    if (!(nodeType != null ? !nodeType.equals(cypherType16) : cypherType16 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$9;
                            private final int offsetB$9;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                AnyValue aVal = a.getRefAt(this.offsetA$9);
                                NodeIdReference bVal = VirtualValues.node((long)b.getLongAt(this.offsetB$9));
                                return this.order$2.compareValues(aVal, (AnyValue)bVal);
                            }
                            {
                                this.offsetA$9 = offsetA$9;
                                this.offsetB$9 = offsetB$9;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot11 = (Slot)tuple2._2();
            if (slot instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot;
                int offsetA = refSlot.offset();
                if (slot11 instanceof LongSlot) {
                    LongSlot longSlot = (LongSlot)slot11;
                    int offsetB = longSlot.offset();
                    CypherType cypherType = longSlot.typ();
                    RelationshipType relationshipType = package$.MODULE$.CTRelationship();
                    CypherType cypherType17 = cypherType;
                    if (!(relationshipType != null ? !relationshipType.equals(cypherType17) : cypherType17 != null)) {
                        return new Comparator<ReadableRow>(offsetA, offsetB, order){
                            private final int offsetA$10;
                            private final int offsetB$10;
                            private final ColumnOrder2 order$2;

                            public Comparator<ReadableRow> reversed() {
                                return Comparator.super.reversed();
                            }

                            public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                                return Comparator.super.thenComparing(x$1, x$2);
                            }

                            public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                                return Comparator.super.thenComparing(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingInt(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingLong(x$1);
                            }

                            public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                                return Comparator.super.thenComparingDouble(x$1);
                            }

                            public int compare(ReadableRow a, ReadableRow b) {
                                AnyValue aVal = a.getRefAt(this.offsetA$10);
                                RelationshipReference bVal = VirtualValues.relationship((long)b.getLongAt(this.offsetB$10));
                                return this.order$2.compareValues(aVal, (AnyValue)bVal);
                            }
                            {
                                this.offsetA$10 = offsetA$10;
                                this.offsetB$10 = offsetB$10;
                                this.order$2 = order$2;
                            }
                        };
                    }
                }
            }
        }
        if (tuple2 != null) {
            Slot slot = (Slot)tuple2._1();
            Slot slot12 = (Slot)tuple2._2();
            if (slot instanceof RefSlot) {
                RefSlot refSlot = (RefSlot)slot;
                int offsetA = refSlot.offset();
                if (slot12 instanceof RefSlot) {
                    RefSlot refSlot2 = (RefSlot)slot12;
                    int offsetB = refSlot2.offset();
                    return new Comparator<ReadableRow>(offsetA, offsetB, order){
                        private final int offsetA$11;
                        private final int offsetB$11;
                        private final ColumnOrder2 order$2;

                        public Comparator<ReadableRow> reversed() {
                            return Comparator.super.reversed();
                        }

                        public Comparator<ReadableRow> thenComparing(Comparator<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public <U> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1, Comparator<? super U> x$2) {
                            return Comparator.super.thenComparing(x$1, x$2);
                        }

                        public <U extends Comparable<? super U>> Comparator<ReadableRow> thenComparing(Function<? super ReadableRow, ? extends U> x$1) {
                            return Comparator.super.thenComparing(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingInt(ToIntFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingInt(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingLong(ToLongFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingLong(x$1);
                        }

                        public Comparator<ReadableRow> thenComparingDouble(ToDoubleFunction<? super ReadableRow> x$1) {
                            return Comparator.super.thenComparingDouble(x$1);
                        }

                        public int compare(ReadableRow a, ReadableRow b) {
                            AnyValue aVal = a.getRefAt(this.offsetA$11);
                            AnyValue bVal = b.getRefAt(this.offsetB$11);
                            return this.order$2.compareValues(aVal, bVal);
                        }
                        {
                            this.offsetA$11 = offsetA$11;
                            this.offsetB$11 = offsetB$11;
                            this.order$2 = order$2;
                        }
                    };
                }
            }
        }
        throw new CantCompileQueryException("Do not know how to create comparator for " + order);
    }

    public Comparator<ReadableRow> asComparator(Seq<ColumnOrder> orderBy) {
        return this.composeComparator((Function1 & Serializable)order -> MODULE$.comparator((ColumnOrder)order), orderBy);
    }

    public Comparator<ReadableRow> asComparator2(Seq<ColumnOrder2> orderBy) {
        return this.composeComparator((Function1 & Serializable)order -> MODULE$.comparator2((ColumnOrder2)order), orderBy);
    }

    public <T, C extends ColumnOrder> Comparator<T> composeComparator(Function1<C, Comparator<T>> singleComparatorCreator, Seq<C> orderBy) {
        int size = orderBy.size();
        if (size == 1) {
            return (Comparator)singleComparatorCreator.apply(orderBy.head());
        }
        if (size == 2) {
            Comparator first = (Comparator)singleComparatorCreator.apply(orderBy.head());
            Comparator second = (Comparator)singleComparatorCreator.apply(orderBy.last());
            return (a, b) -> {
                int i = first.compare(a, b);
                if (i == 0) {
                    return second.compare(a, b);
                }
                return i;
            };
        }
        Comparator[] comparators = new Comparator[size];
        IntRef i = IntRef.create((int)0);
        orderBy.foreach((Function1 & Serializable)columnOrder -> {
            SlottedExecutionContextOrdering$.$anonfun$composeComparator$2(comparators, i, singleComparatorCreator, columnOrder);
            return BoxedUnit.UNIT;
        });
        return new Comparator<T>(comparators){
            private final Comparator[] comparators$1;

            public Comparator<T> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<T> thenComparing(Comparator<? super T> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<T> thenComparing(Function<? super T, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<T> thenComparing(Function<? super T, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<T> thenComparingInt(ToIntFunction<? super T> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<T> thenComparingLong(ToLongFunction<? super T> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<T> thenComparingDouble(ToDoubleFunction<? super T> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public int compare(T a, T b) {
                for (int c = 0; c < this.comparators$1.length; ++c) {
                    int i = this.comparators$1[c].compare(a, b);
                    if (i == 0) continue;
                    return i;
                }
                return 0;
            }
            {
                this.comparators$1 = comparators$1;
            }
        };
    }

    public static final /* synthetic */ void $anonfun$composeComparator$2(Comparator[] comparators$1, IntRef i$1, Function1 singleComparatorCreator$1, ColumnOrder columnOrder) {
        comparators$1[i$1.elem] = (Comparator)singleComparatorCreator$1.apply((Object)columnOrder);
        ++i$1.elem;
    }

    private SlottedExecutionContextOrdering$() {
    }
}

