/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.server.startup.validation.ConfigValidationIssue;
import org.neo4j.server.startup.validation.ConfigValidationSummary;
import org.neo4j.server.startup.validation.ConfigValidator;
import org.neo4j.server.startup.validation.Log4jConfigValidator;
import org.neo4j.server.startup.validation.Neo4jConfigValidator;
import org.neo4j.util.VisibleForTesting;

public class ConfigValidationHelper {
    private final ConfigValidator.Factory validatorFactory;

    public ConfigValidationHelper(Path configPath) {
        this(new DefaultValidatorFactory(configPath));
    }

    @VisibleForTesting
    public ConfigValidationHelper(ConfigValidator.Factory validatorFactory) {
        this.validatorFactory = validatorFactory;
    }

    public ConfigValidationSummary validateAll(Supplier<Config> config) {
        ConfigValidationSummary summary = new ConfigValidationSummary();
        summary.add(this.validate(this.validatorFactory.getNeo4jValidator(config)));
        if (summary.result() == ConfigValidationSummary.ValidationResult.ERRORS) {
            summary.add(new ConfigValidationSummary.MessageEvent("Skipping Log4j validation due to previous issues."));
            return summary;
        }
        summary.add(this.validate(this.validatorFactory.getLog4jUserValidator(config)));
        summary.add(this.validate(this.validatorFactory.getLog4jServerValidator(config)).treatErrorsAsWarnings());
        return summary;
    }

    private ConfigValidationSummary.Event validate(ConfigValidator validator) {
        try {
            List<ConfigValidationIssue> issues = validator.validate();
            return new ConfigValidationSummary.ResultEvent(validator.getLabel(), issues);
        }
        catch (Exception e) {
            return new ConfigValidationSummary.ErrorEvent(validator.getLabel(), e);
        }
    }

    private static class DefaultValidatorFactory
    implements ConfigValidator.Factory {
        private final Path configPath;

        private DefaultValidatorFactory(Path configPath) {
            this.configPath = configPath;
        }

        @Override
        public ConfigValidator getNeo4jValidator(Supplier<Config> config) {
            return new Neo4jConfigValidator(config, this.configPath);
        }

        @Override
        public ConfigValidator getLog4jUserValidator(Supplier<Config> config) {
            Path configPath = (Path)config.get().get(GraphDatabaseSettings.user_logging_config_path);
            return new Log4jConfigValidator(config, "user", configPath);
        }

        @Override
        public ConfigValidator getLog4jServerValidator(Supplier<Config> config) {
            Path configPath = (Path)config.get().get(GraphDatabaseSettings.server_logging_config_path);
            return new Log4jConfigValidator(config, "server", configPath);
        }
    }
}

