/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Environment;
import org.neo4j.server.startup.Neo4jAdminCommand;
import org.neo4j.server.startup.Neo4jCommand;
import picocli.CommandLine;

@CommandLine.Command(name="generate-cli-dump", description={"Generates cli dump"})
public class CliDumpGenerator
implements Callable<Integer> {
    @CommandLine.Parameters(index="0", description={"Output directory"})
    private Path output;
    private static final String SEPARATOR = ";";

    private void dumpCli(Neo4jAdminCommand command) throws IOException {
        CommandLine commandLine = command.getActualAdminCommand(new ExecutionContext(this.output, this.output));
        String name = commandLine.getCommand().getClass().getAnnotation(CommandLine.Command.class).name();
        Path file = this.output.resolve(name + "_dump.csv");
        String dump = CliDumpGenerator.dump(commandLine);
        Files.writeString(file, (CharSequence)dump, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private static String dump(CommandLine cmd) {
        StringBuilder stringBuilder = new StringBuilder();
        int numCommands = CliDumpGenerator.getNumCommands(cmd, 1);
        stringBuilder.append(CliDumpGenerator.header(numCommands));
        CliDumpGenerator.dump(cmd, 0, new String[numCommands], stringBuilder);
        return stringBuilder.toString();
    }

    private static void dump(CommandLine cmd, int depth, String[] commands, StringBuilder stringBuilder) {
        CommandLine.Model.CommandSpec spec = cmd.getCommandSpec();
        Object name = cmd.getCommandName();
        if (spec.usageMessage().hidden()) {
            name = (String)name + " <HIDDEN>";
        }
        commands[depth] = name;
        StringBuilder commandAndParams = new StringBuilder();
        for (String com : commands) {
            commandAndParams.append(com != null ? com : "").append(SEPARATOR);
        }
        String paramOptions = CliDumpGenerator.addParams(commandAndParams, spec);
        String comAndParams = commandAndParams.append(SEPARATOR).toString();
        for (CommandLine.Model.OptionSpec os : spec.options()) {
            stringBuilder.append(comAndParams).append(Arrays.toString(os.names())).append(os.hidden() ? " <HIDDEN>" : "").append(SEPARATOR).append(paramOptions).append(SEPARATOR).append(CliDumpGenerator.asOneLine(os.description())).append(System.lineSeparator());
        }
        cmd.getSubcommands().values().stream().distinct().forEach(subCmd -> CliDumpGenerator.dump(subCmd, depth + 1, commands, stringBuilder));
    }

    private static int getNumCommands(CommandLine cmd, int depth) {
        return cmd.getSubcommands().values().stream().distinct().map(c -> CliDumpGenerator.getNumCommands(c, depth + 1)).max(Integer::compare).orElse(depth);
    }

    private static String header(int numCommands) {
        StringBuilder header = new StringBuilder();
        for (int i = 1; i <= numCommands; ++i) {
            header.append("Command ").append(i).append(SEPARATOR);
        }
        header.append("Parameters").append(SEPARATOR).append("Option").append(SEPARATOR).append("Param descriptions").append(SEPARATOR).append("Option description").append(System.lineSeparator());
        return header.toString();
    }

    private static String addParams(StringBuilder commandAndParams, CommandLine.Model.CommandSpec spec) {
        List params = spec.positionalParameters();
        StringBuilder paramOptions = new StringBuilder();
        for (CommandLine.Model.PositionalParamSpec param : params) {
            commandAndParams.append(param.paramLabel());
            commandAndParams.append(param.hidden() ? " <HIDDEN>" : "");
            commandAndParams.append(" ");
            paramOptions.append(CliDumpGenerator.asOneLine(param.description())).append(" ");
        }
        return paramOptions.toString();
    }

    private static String asOneLine(String[] strings) {
        return Arrays.toString(strings).replace(System.lineSeparator(), " ").replace("%n", "");
    }

    @Override
    public Integer call() throws Exception {
        if (Files.exists(this.output, new LinkOption[0]) && !Files.isDirectory(this.output, new LinkOption[0])) {
            throw new FileAlreadyExistsException(this.output.toString() + " Needs to be a directory");
        }
        Files.createDirectories(this.output, new FileAttribute[0]);
        this.dumpCli(new Neo4jAdminCommand(Environment.SYSTEM));
        this.dumpCli(new Neo4jCommand(Environment.SYSTEM));
        return 0;
    }

    public static void main(String[] args) {
        new CommandLine((Object)new CliDumpGenerator()).execute(args);
    }
}

