/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.time.Clock;
import java.util.concurrent.TimeUnit;
import org.neo4j.configuration.Config;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.facade.SystemDatabaseRunner;
import org.neo4j.graphdb.factory.module.edition.migration.MigrationEditionModuleFactory;
import org.neo4j.graphdb.factory.module.edition.migration.SystemDatabaseMigrator;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitorFactory;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

public class SystemDatabaseUpgrader {
    private SystemDatabaseUpgrader() {
    }

    public static void upgrade(MigrationEditionModuleFactory editionFactory, SystemDatabaseMigrator systemDatabaseMigrator, Config config, InternalLogProvider logProvider, InternalLogProvider systemDbStartupLogProvider) throws Exception {
        InternalLog log = logProvider.getLog(SystemDatabaseUpgrader.class);
        MigrationProgressMonitor progressMonitor = VisibleMigrationProgressMonitorFactory.forSystemUpgrade((InternalLog)log);
        progressMonitor.started(3);
        ProgressListener bootstrapProgress = progressMonitor.startSection("Bootstrap");
        try (SystemDatabaseRunner systemDatabaseRunner = new SystemDatabaseRunner((FileSystemAbstraction)new DefaultFileSystemAbstraction(), editionFactory, config, systemDbStartupLogProvider).run();){
            bootstrapProgress.close();
            GraphDatabaseAPI systemDatabase = systemDatabaseRunner.systemDatabase();
            ProgressListener indexPopulationProgress = progressMonitor.startSection("Index population");
            try (Transaction tx = systemDatabase.beginTx();){
                tx.schema().awaitIndexesOnline(1L, TimeUnit.HOURS);
            }
            indexPopulationProgress.close();
            ProgressListener purgeTopologyGraphProgress = progressMonitor.startSection("Purge topology graph");
            try (Transaction tx = systemDatabase.beginTx();){
                systemDatabaseMigrator.performAdditionalSystemDatabaseMigrationSteps(systemDatabase, tx, (Clock)systemDatabaseRunner.globalModule().getGlobalClock(), log);
                tx.commit();
            }
            purgeTopologyGraphProgress.close();
        }
        progressMonitor.completed();
    }
}

