/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;

public class DefaultSystemGraphComponent
extends AbstractSystemGraphComponent {
    private final NormalizedDatabaseName defaultDbName;
    private final Clock clock;

    public DefaultSystemGraphComponent(Config config, Clock clock) {
        super(config);
        this.defaultDbName = new NormalizedDatabaseName((String)config.get(GraphDatabaseSettings.initial_default_database));
        this.clock = clock;
    }

    public SystemGraphComponent.Name componentName() {
        return ComponentVersion.MULTI_DATABASE_COMPONENT;
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        boolean hasDatabaseNode = DefaultSystemGraphComponent.hasDatabaseNode(tx);
        if (!hasDatabaseNode) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (!DefaultSystemGraphComponent.hasSystemDatabaseNode(tx)) {
            return SystemGraphComponent.Status.UNSUPPORTED;
        }
        if (DefaultSystemGraphComponent.hasUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name", "namespace"}) && DefaultSystemGraphComponent.hasUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_LABEL, (String[])new String[]{"name"})) {
            return SystemGraphComponent.Status.CURRENT;
        }
        return SystemGraphComponent.Status.REQUIRES_UPGRADE;
    }

    protected void initializeSystemGraphConstraints(Transaction tx) {
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name", "namespace"});
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_LABEL, (String[])new String[]{"name"});
    }

    public void initializeSystemGraphModel(GraphDatabaseService system) throws InvalidArgumentsException {
        try (Transaction tx = system.beginTx();){
            ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone());
            DefaultSystemGraphComponent.createDatabaseNode(tx, this.defaultDbName.name(), true, UUID.randomUUID(), now);
            DefaultSystemGraphComponent.createDatabaseNode(tx, "system", false, DatabaseId.SYSTEM_DATABASE_ID.uuid(), now);
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            throw new InvalidArgumentsException("The specified database '" + this.defaultDbName.name() + "' or 'system' already exists.");
        }
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
        this.updateDefaultDatabase(system);
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, this::initializeSystemGraphConstraints);
        SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, DefaultSystemGraphComponent::dropOldConstraints);
    }

    private static void dropOldConstraints(Transaction tx) {
        DefaultSystemGraphComponent.findUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name"}).ifPresent(ConstraintDefinition::drop);
    }

    private static boolean hasDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private static boolean hasSystemDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private void updateDefaultDatabase(GraphDatabaseService system) throws InvalidArgumentsException {
        try (Transaction tx = system.beginTx();){
            boolean defaultFound;
            Function<ResourceIterator<Node>, Boolean> unsetOldNode = nodes -> {
                boolean correctDefaultFound = false;
                while (nodes.hasNext()) {
                    Node oldDb = (Node)nodes.next();
                    if (oldDb.getProperty("name").equals(this.defaultDbName.name())) {
                        correctDefaultFound = true;
                        continue;
                    }
                    oldDb.setProperty("default", (Object)false);
                    oldDb.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.OFFLINE.statusName());
                }
                return correctDefaultFound;
            };
            try (ResourceIterator nodes2 = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "default", (Object)true);){
                defaultFound = unsetOldNode.apply((ResourceIterator)nodes2);
            }
            this.unsetAnyDeleted(tx, unsetOldNode);
            if (!defaultFound) {
                Node defaultDb = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)this.defaultDbName.name());
                if (defaultDb != null) {
                    defaultDb.setProperty("default", (Object)true);
                    defaultDb.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.ONLINE.statusName());
                } else {
                    ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone());
                    DefaultSystemGraphComponent.createDatabaseNode(tx, this.defaultDbName.name(), true, UUID.randomUUID(), now);
                }
            }
            tx.commit();
        }
    }

    private void unsetAnyDeleted(Transaction tx, Function<ResourceIterator<Node>, Boolean> unsetOldNode) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL, "default", (Object)true);){
            unsetOldNode.apply((ResourceIterator<Node>)nodes);
        }
    }

    public static Node createDatabaseNode(Transaction tx, String databaseName, boolean defaultDb, UUID uuid, ZonedDateTime now) {
        Node databaseNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_LABEL});
        databaseNode.setProperty("name", (Object)databaseName);
        databaseNode.setProperty("uuid", (Object)uuid.toString());
        databaseNode.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.ONLINE.statusName());
        databaseNode.setProperty("default", (Object)defaultDb);
        databaseNode.setProperty("created_at", (Object)now);
        databaseNode.setProperty("started_at", (Object)now);
        long randomId = ThreadLocalRandom.current().nextLong();
        databaseNode.setProperty("store_random_id", (Object)randomId);
        Node nameNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        nameNode.setProperty("name", (Object)databaseName);
        nameNode.setProperty("namespace", (Object)"system-root");
        nameNode.setProperty("displayName", (Object)databaseName);
        nameNode.setProperty("primary", (Object)true);
        nameNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
        return databaseNode;
    }
}

