/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.packstream.struct;

import java.util.Map;
import java.util.Optional;
import org.neo4j.packstream.struct.EmptyStructRegistry;
import org.neo4j.packstream.struct.ImmutableStructRegistry;
import org.neo4j.packstream.struct.StructHeader;
import org.neo4j.packstream.struct.StructReader;
import org.neo4j.packstream.struct.StructWriter;

public interface StructRegistry<CTX, S> {
    public static <CTX, S> Builder<CTX, S> builder() {
        return ImmutableStructRegistry.emptyBuilder();
    }

    public static <CTX, S> StructRegistry<CTX, S> empty() {
        return EmptyStructRegistry.getInstance();
    }

    public <C extends CTX> Builder<C, S> builderOf();

    public Optional<? extends StructReader<? super CTX, ? extends S>> getReader(StructHeader var1);

    public <O extends S> Optional<? extends StructWriter<? super CTX, ? super O>> getWriter(O var1);

    public static interface Builder<CTX, S> {
        public StructRegistry<CTX, S> build();

        default public Builder<CTX, S> register(StructReader<? super CTX, ? extends S> reader) {
            return this.register(reader.getTag(), reader);
        }

        default public Builder<CTX, S> unregister(StructReader<? super CTX, ? extends S> reader) {
            return this.unregisterReader(reader.getTag());
        }

        default public Builder<CTX, S> unregister(StructWriter<? super CTX, ? extends S> writer) {
            return this.unregisterWriter(writer.getType());
        }

        public Builder<CTX, S> register(short var1, StructReader<? super CTX, ? extends S> var2);

        public Builder<CTX, S> unregisterReader(short var1);

        public <T extends S> Builder<CTX, S> unregisterWriter(Class<T> var1);

        default public Builder<CTX, S> registerReaders(Map<Short, StructReader<? super CTX, ? extends S>> readers) {
            readers.forEach(this::register);
            return this;
        }

        default public <T extends S> Builder<CTX, S> register(StructWriter<? super CTX, T> writer) {
            return this.register(writer.getType(), writer);
        }

        public <T extends S> Builder<CTX, S> register(Class<T> var1, StructWriter<? super CTX, ? super T> var2);

        default public Builder<CTX, S> registerWriters(Map<Class<?>, StructWriter<? super CTX, ? super S>> writers) {
            writers.forEach((type, writer) -> this.register((Class)type, (StructWriter)writer));
            return this;
        }
    }
}

