/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.protocol.common.handler.listeners;

import io.netty.channel.ChannelHandler;
import org.neo4j.bolt.protocol.common.connector.connection.Connection;
import org.neo4j.bolt.protocol.common.connector.connection.listener.ConnectionListener;
import org.neo4j.bolt.protocol.common.handler.messages.ResetMessageHandler;
import org.neo4j.internal.kernel.api.security.LoginContext;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public class ResetMessageConnectionListener
implements ConnectionListener {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ResetMessageHandler.class);
    private final InternalLogProvider logger;
    private final Connection connection;
    private ResetMessageHandler resetMessageHandler;

    public ResetMessageConnectionListener(InternalLogProvider logger, Connection connection) {
        this.logger = logger;
        this.connection = connection;
    }

    @Override
    public void onLogon(LoginContext ctx) {
        this.connection.memoryTracker().allocateHeap(ResetMessageHandler.SHALLOW_SIZE);
        this.resetMessageHandler = new ResetMessageHandler(this.logger);
        this.connection.channel().pipeline().addBefore("goodbyeMessageHandler", "resetMessageHandler", (ChannelHandler)this.resetMessageHandler);
    }

    @Override
    public void onLogoff() {
        this.connection.channel().pipeline().remove((ChannelHandler)this.resetMessageHandler);
        this.resetMessageHandler = null;
    }
}

