/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.negotiation.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Iterator;
import org.neo4j.bolt.negotiation.ProtocolVersion;
import org.neo4j.bolt.negotiation.codec.ModernProtocolNegotiationFinalizeMessageDecoder;
import org.neo4j.bolt.negotiation.codec.ModernProtocolNegotiationInitMessageEncoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationRequestDecoder;
import org.neo4j.bolt.negotiation.codec.ProtocolNegotiationResponseEncoder;
import org.neo4j.bolt.negotiation.handler.AbstractProtocolHandshakeHandler;
import org.neo4j.bolt.negotiation.handler.ModernProtocolHandshakeHandler;
import org.neo4j.bolt.negotiation.message.ProtocolCapability;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationRequest;
import org.neo4j.bolt.negotiation.message.ProtocolNegotiationResponse;
import org.neo4j.bolt.protocol.BoltProtocolRegistry;
import org.neo4j.bolt.protocol.common.BoltProtocol;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.HeapEstimator;

public final class LegacyProtocolHandshakeHandler
extends AbstractProtocolHandshakeHandler<ProtocolNegotiationRequest> {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(LegacyProtocolHandshakeHandler.class);
    public static final int BOLT_MAGIC_PREAMBLE = 1616949271;

    public LegacyProtocolHandshakeHandler(InternalLogProvider logging) {
        super(logging);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().releaseHeap(SHALLOW_SIZE);
    }

    protected void channelRead0(ChannelHandlerContext ctx, ProtocolNegotiationRequest request) throws Exception {
        if (request.getMagicNumber() != 1616949271) {
            this.log.debug("Invalid Bolt handshake signature. Expected 0x%08X, but got: 0x%08X", new Object[]{1616949271, request.getMagicNumber()});
            ctx.close();
            return;
        }
        BoltProtocol selectedProtocol = null;
        BoltProtocolRegistry protocolRegistry = this.connector.protocolRegistry();
        Iterator<ProtocolVersion> it = request.proposedVersions().iterator();
        do {
            if (!it.hasNext()) {
                this.log.debug("Failed Bolt handshake: Bolt versions suggested by client '%s' are not supported by this server.", new Object[]{Arrays.toString(request.proposedVersions().toArray())});
                ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(ProtocolVersion.INVALID)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                return;
            }
            ProtocolVersion proposal = it.next();
            if (ProtocolVersion.INVALID.equals(proposal)) continue;
            if (proposal.isNegotiationVersion()) {
                if (!proposal.matches(ProtocolVersion.NEGOTIATION_V2)) {
                    this.log.debug("Rejected modern handshake: Handshake version(s) suggested by client '%s' are not supported by this server.", new Object[]{proposal});
                    continue;
                }
                this.handleModernHandshake(ctx);
                return;
            }
            selectedProtocol = protocolRegistry.get(proposal).orElse(null);
        } while (selectedProtocol == null);
        this.finalizeHandshake(ctx, selectedProtocol, EnumSet.noneOf(ProtocolCapability.class));
    }

    private void handleModernHandshake(ChannelHandlerContext ctx) {
        this.connection.memoryTracker().allocateHeap(ModernProtocolHandshakeHandler.SHALLOW_SIZE + ModernProtocolNegotiationInitMessageEncoder.SHALLOW_SIZE + ModernProtocolNegotiationFinalizeMessageDecoder.SHALLOW_SIZE);
        ctx.pipeline().addLast(new ChannelHandler[]{new ModernProtocolNegotiationInitMessageEncoder()}).addLast(new ChannelHandler[]{new ModernProtocolNegotiationFinalizeMessageDecoder()}).addLast(new ChannelHandler[]{new ModernProtocolHandshakeHandler(this.logging)});
        this.removeStageHandlers(ctx);
    }

    @Override
    protected void onVersionSelected(ChannelHandlerContext ctx, BoltProtocol protocol) {
        ctx.writeAndFlush((Object)new ProtocolNegotiationResponse(protocol.version()));
    }

    @Override
    protected void removeStageHandlers(ChannelHandlerContext ctx) {
        super.removeStageHandlers(ctx);
        ctx.pipeline().remove(ProtocolNegotiationResponseEncoder.class);
        ctx.pipeline().remove(ProtocolNegotiationRequestDecoder.class);
    }
}

