/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.bolt.fsm;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.bolt.fsm.ImmutableStateMachineConfiguration;
import org.neo4j.bolt.fsm.StateMachineConfiguration;
import org.neo4j.bolt.fsm.state.State;
import org.neo4j.bolt.fsm.state.StateReference;

final class StateMachineFactoryImpl
implements StateMachineConfiguration.Factory {
    private StateReference initialState;
    private final Map<StateReference, State.Factory> stateMap = new HashMap<StateReference, State.Factory>();

    StateMachineFactoryImpl() {
    }

    @Override
    public ImmutableStateMachineConfiguration build() {
        if (this.initialState == null) {
            throw new IllegalStateException("No initial state configured");
        }
        Map<StateReference, State> stateMap = this.stateMap.values().stream().map(State.Factory::build).collect(Collectors.toMap(State::reference, Function.identity()));
        State initialState = (State)stateMap.get(this.initialState);
        return new ImmutableStateMachineConfiguration(initialState, stateMap);
    }

    @Override
    public StateMachineConfiguration.Factory withInitialState(StateReference reference) {
        if (!this.stateMap.containsKey(reference)) {
            throw new IllegalArgumentException("No such state: " + reference);
        }
        this.initialState = reference;
        return this;
    }

    @Override
    public StateMachineFactoryImpl withInitialState(StateReference reference, Consumer<State.Factory> factoryConsumer) {
        this.withState(reference, (Consumer)factoryConsumer);
        this.initialState = reference;
        return this;
    }

    public StateMachineFactoryImpl withInitialState(StateReference reference, State.Factory factory) {
        this.withState(reference, factory);
        this.initialState = factory.reference();
        return this;
    }

    @Override
    public StateMachineFactoryImpl withState(StateReference reference, Consumer<State.Factory> factoryConsumer) {
        State.Factory factory = this.stateMap.computeIfAbsent(reference, State::builder);
        factoryConsumer.accept(factory);
        return this;
    }

    public StateMachineFactoryImpl withState(StateReference reference, State.Factory factory) {
        this.stateMap.put(reference, factory);
        return this;
    }

    @Override
    public StateMachineFactoryImpl withoutState(StateReference reference) {
        this.stateMap.remove(reference);
        if (Objects.equals(this.initialState, reference)) {
            this.initialState = null;
        }
        return this;
    }
}

