/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store.format;

import org.neo4j.internal.helpers.ArrayUtil;
import org.neo4j.storageengine.api.format.Capability;
import org.neo4j.storageengine.api.format.CapabilityType;

public enum RecordStorageCapability implements Capability
{
    RELATIONSHIP_TYPE_3BYTES(CapabilityType.FORMAT, CapabilityType.STORE),
    SECONDARY_RECORD_UNITS(CapabilityType.FORMAT),
    LITTLE_ENDIAN(CapabilityType.FORMAT, CapabilityType.STORE),
    MULTI_VERSIONED(CapabilityType.FORMAT, CapabilityType.STORE);

    private final CapabilityType[] types;
    private final boolean additive;

    private RecordStorageCapability(CapabilityType ... types) {
        this(false, types);
    }

    private RecordStorageCapability(boolean additive, CapabilityType ... types) {
        this.additive = additive;
        this.types = types;
    }

    public boolean isType(CapabilityType type) {
        return ArrayUtil.contains((Object[])this.types, (Object)type);
    }

    public boolean isAdditive() {
        return this.additive;
    }
}

