/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.id.SchemaIdType;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.layout.recordstorage.RecordDatabaseFile;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum StoreType {
    NODE_LABEL(RecordDatabaseFile.NODE_LABEL_STORE, RecordIdType.NODE_LABELS){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeLabelStore();
        }
    }
    ,
    NODE(RecordDatabaseFile.NODE_STORE, RecordIdType.NODE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createNodeStore();
        }
    }
    ,
    PROPERTY_KEY_TOKEN_NAME(RecordDatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, RecordIdType.PROPERTY_KEY_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenNamesStore();
        }
    }
    ,
    PROPERTY_KEY_TOKEN(RecordDatabaseFile.PROPERTY_KEY_TOKEN_STORE, (IdType)SchemaIdType.PROPERTY_KEY_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyKeyTokenStore();
        }
    }
    ,
    PROPERTY_STRING(RecordDatabaseFile.PROPERTY_STRING_STORE, RecordIdType.STRING_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStringStore();
        }
    }
    ,
    PROPERTY_ARRAY(RecordDatabaseFile.PROPERTY_ARRAY_STORE, RecordIdType.ARRAY_BLOCK){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyArrayStore();
        }
    }
    ,
    PROPERTY(RecordDatabaseFile.PROPERTY_STORE, RecordIdType.PROPERTY){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createPropertyStore();
        }
    }
    ,
    RELATIONSHIP(RecordDatabaseFile.RELATIONSHIP_STORE, RecordIdType.RELATIONSHIP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipStore();
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN_NAME(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, RecordIdType.RELATIONSHIP_TYPE_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenNamesStore();
        }
    }
    ,
    RELATIONSHIP_TYPE_TOKEN(RecordDatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, (IdType)SchemaIdType.RELATIONSHIP_TYPE_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipTypeTokenStore();
        }
    }
    ,
    LABEL_TOKEN_NAME(RecordDatabaseFile.LABEL_TOKEN_NAMES_STORE, RecordIdType.LABEL_TOKEN_NAME){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenNamesStore();
        }
    }
    ,
    LABEL_TOKEN(RecordDatabaseFile.LABEL_TOKEN_STORE, (IdType)SchemaIdType.LABEL_TOKEN){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createLabelTokenStore();
        }
    }
    ,
    SCHEMA(RecordDatabaseFile.SCHEMA_STORE, (IdType)SchemaIdType.SCHEMA){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createSchemaStore();
        }
    }
    ,
    RELATIONSHIP_GROUP(RecordDatabaseFile.RELATIONSHIP_GROUP_STORE, RecordIdType.RELATIONSHIP_GROUP){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createRelationshipGroupStore();
        }
    }
    ,
    META_DATA(RecordDatabaseFile.METADATA_STORE, RecordIdType.NODE){

        @Override
        public CommonAbstractStore open(NeoStores neoStores) {
            return neoStores.createMetadataStore();
        }
    };

    private final RecordDatabaseFile databaseFile;
    private final IdType idType;
    public static final StoreType[] STORE_TYPES;

    private StoreType(RecordDatabaseFile databaseFile, IdType idType) {
        this.databaseFile = databaseFile;
        this.idType = idType;
    }

    abstract CommonAbstractStore open(NeoStores var1);

    public RecordDatabaseFile getDatabaseFile() {
        return this.databaseFile;
    }

    public IdType getIdType() {
        return this.idType;
    }

    public static Optional<StoreType> typeOf(RecordDatabaseFile file) {
        Objects.requireNonNull(file);
        return Arrays.stream(STORE_TYPES).filter(type -> type.getDatabaseFile().equals((Object)file)).findFirst();
    }

    static {
        STORE_TYPES = StoreType.values();
    }
}

