/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.store;

import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.DynamicArrayStore;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NoStoreHeader;
import org.neo4j.kernel.impl.store.NoStoreHeaderFormat;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.PropertyType;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.util.BitBuffer;

public class NodeStore
extends CommonAbstractStore<NodeRecord, NoStoreHeader> {
    public static final String TYPE_DESCRIPTOR = "NodeStore";
    private final DynamicArrayStore dynamicLabelStore;

    public static Long readOwnerFromDynamicLabelsRecord(DynamicRecord record) {
        byte[] data = record.getData();
        byte[] header = PropertyType.ARRAY.readDynamicRecordHeader(data);
        byte[] array = Arrays.copyOfRange(data, header.length, data.length);
        byte requiredBits = header[2];
        if (requiredBits == 0) {
            return null;
        }
        BitBuffer bits = BitBuffer.bitsFromBytes((byte[])array);
        return bits.getLong((int)requiredBits);
    }

    public NodeStore(FileSystemAbstraction fileSystem, Path path, Path idFile, Config config, IdGeneratorFactory idGeneratorFactory, PageCache pageCache, PageCacheTracer pageCacheTracer, InternalLogProvider logProvider, DynamicArrayStore dynamicLabelStore, RecordFormats recordFormats, boolean readOnly, String databaseName, ImmutableSet<OpenOption> openOptions) {
        super(fileSystem, path, idFile, config, RecordIdType.NODE, idGeneratorFactory, pageCache, pageCacheTracer, logProvider, TYPE_DESCRIPTOR, recordFormats.node(), NoStoreHeaderFormat.NO_STORE_HEADER_FORMAT, readOnly, databaseName, openOptions);
        this.dynamicLabelStore = dynamicLabelStore;
    }

    @Override
    public void ensureHeavy(NodeRecord node, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (NodeLabelsField.fieldPointsToDynamicRecordOfLabels(node.getLabelField())) {
            this.ensureHeavy(node, NodeLabelsField.firstDynamicLabelRecordId(node.getLabelField()), storeCursors, memoryTracker);
        }
    }

    public void ensureHeavy(NodeRecord node, long firstDynamicLabelRecord, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (!node.isLight()) {
            return;
        }
        try {
            node.setLabelField(node.getLabelField(), this.dynamicLabelStore.getRecords(firstDynamicLabelRecord, RecordLoad.ALWAYS, false, storeCursors.readCursor((CursorType)RecordCursorTypes.DYNAMIC_LABEL_STORE_CURSOR), memoryTracker));
        }
        catch (InvalidRecordException e) {
            throw new InvalidRecordException(String.format("Error loading dynamic label records for %s | %s", node, e.getMessage()), (Throwable)((Object)e));
        }
    }

    @Override
    public void updateRecord(NodeRecord record, IdUpdateListener idUpdateListener, PageCursor cursor, CursorContext cursorContext, StoreCursors storeCursors) {
        super.updateRecord(record, idUpdateListener, cursor, cursorContext, storeCursors);
        this.updateDynamicLabelRecords(record.getDynamicLabelRecords(), idUpdateListener, cursorContext, storeCursors);
    }

    public DynamicArrayStore getDynamicLabelStore() {
        return this.dynamicLabelStore;
    }

    public void updateDynamicLabelRecords(Iterable<DynamicRecord> dynamicLabelRecords, IdUpdateListener idUpdateListener, CursorContext cursorContext, StoreCursors storeCursors) {
        try (PageCursor cursor = storeCursors.writeCursor((CursorType)RecordCursorTypes.DYNAMIC_LABEL_STORE_CURSOR);){
            for (DynamicRecord record : dynamicLabelRecords) {
                this.dynamicLabelStore.updateRecord(record, idUpdateListener, cursor, cursorContext, storeCursors);
            }
        }
    }
}

