/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage.indexcommand;

import java.io.IOException;
import java.util.Arrays;
import org.neo4j.internal.recordstorage.CommandVisitor;
import org.neo4j.internal.recordstorage.LogCommandSerialization;
import org.neo4j.internal.recordstorage.indexcommand.IndexUpdateCommand;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.string.Mask;
import org.neo4j.values.storable.Value;

public class ValueIndexUpdateCommand
extends IndexUpdateCommand<Value[]> {
    static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(ValueIndexUpdateCommand.class);
    private final Value[] before;
    private final Value[] values;

    public ValueIndexUpdateCommand(LogCommandSerialization serialization, UpdateMode updateMode, long indexId, long entityId, Value[] before, Value[] values) {
        super(serialization, updateMode, indexId, entityId);
        this.before = before;
        this.values = values;
    }

    @Override
    public Value[] getBefore() {
        return this.before;
    }

    @Override
    public Value[] getAfter() {
        return this.values;
    }

    @Override
    public String toString(Mask mask) {
        return String.format("ValueIndexUpdateCommand[mode:%s, indexId:%d, entityId:%d, before:%s, after:%s]", this.updateMode, this.indexId, this.entityId, Arrays.toString(this.before), Arrays.toString(this.values));
    }

    @Override
    public boolean handle(CommandVisitor handler) throws IOException {
        return handler.visitIndexUpdateCommand(this);
    }

    public void serialize(WritableChannel channel) throws IOException {
        this.serialization.writeIndexUpdateCommand(channel, this);
    }
}

